/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.refactoring.changes;

import java.awt.Component;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JOptionPane;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.cmd.RenameMessage;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.VetoableSubject;
import oracle.ide.model.Workspace;
import oracle.ide.model.Workspaces;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.IdeArb;
import oracle.jdeveloper.java.CacheSupport;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.refactoring.changes.RefactoringChange;
import oracle.jdeveloper.refactoring.changes.TextChange;

public class RenameNode
extends RefactoringChange {
    private URL _urlBefore;
    private URL _urlAfter;

    public RenameNode(Node node, URL uRL, URL uRL2) {
        super(node);
        this._urlBefore = uRL;
        this._urlAfter = uRL2;
    }

    public boolean doit() throws Exception {
        Node node = this.getNode();
        return CopyOfRenameCommand.rename(node, this._urlBefore, this._urlAfter);
    }

    public boolean undo() throws Exception {
        Node node = this.getNode();
        return CopyOfRenameCommand.rename(node, this._urlAfter, this._urlBefore);
    }

    public int compareTo(Object object) {
        if (object instanceof TextChange) {
            TextChange textChange = (TextChange)object;
            return -textChange.compareTo(this);
        }
        return this.hashCode() - object.hashCode();
    }

    public static class CopyOfRenameCommand {
        public static boolean rename(Node node, URL uRL, URL uRL2) {
            boolean bl = false;
            Context[] contextArray = CopyOfRenameCommand.getOwners(node);
            if (CopyOfRenameCommand.canRename(contextArray, node) && CopyOfRenameCommand.doSaveAs(contextArray, node, uRL, uRL2)) {
                if (URLFileSystem.exists((URL)uRL) && !URLFileSystem.isDirectory((URL)uRL) && !URLFileSystem.equals((URL)uRL, (URL)uRL2) && !URLFileSystem.delete((URL)uRL)) {
                    String string = IdeArb.format((int)245, (Object)URLFileSystem.getPlatformPathName((URL)uRL), (Object)URLFileSystem.getPlatformPathName((URL)uRL2));
                    JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), string, IdeArb.getString((int)240), 0);
                }
                bl = true;
            }
            return bl;
        }

        private static boolean canRename(Context[] contextArray, Node node) {
            int n = 0;
            while (n < contextArray.length) {
                Context context = contextArray[n];
                Project project = context.getProject();
                try {
                    UpdateMessage.fireCanRenameChild((VetoableSubject)project, (Object)node);
                }
                catch (Exception exception) {
                    boolean bl = false;
                    return bl;
                }
                ++n;
            }
            return true;
        }

        private static boolean saveNode(Node node, URL uRL, URL uRL2) {
            if (!URLFileSystem.exists((URL)uRL)) {
                return CopyOfRenameCommand.saveNode2(node, uRL, uRL2);
            }
            if (URLFileSystem.exists((URL)uRL2) && !URLFileSystem.equals((URL)uRL, (URL)uRL2) && !URLFileSystem.delete((URL)uRL2)) {
                String string = IdeArb.format((int)252, (Object)URLFileSystem.getPlatformPathName((URL)uRL2));
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), string, IdeArb.getString((int)240), 0);
                return false;
            }
            if (!URLFileSystem.renameTo((URL)uRL, (URL)uRL2)) {
                String string = IdeArb.format((int)253, (Object)URLFileSystem.getPlatformPathName((URL)uRL), (Object)URLFileSystem.getPlatformPathName((URL)uRL2));
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), string, IdeArb.getString((int)240), 0);
                return false;
            }
            node.setURL(uRL2);
            return true;
        }

        private static boolean saveAsNewNode(Context[] contextArray, Node node, URL uRL, URL uRL2) {
            CacheSupport[] cacheSupportArray = new CacheSupport[contextArray.length];
            int n = 0;
            while (n < contextArray.length) {
                Context context = contextArray[n];
                Project project = context.getProject();
                JavaManager javaManager = JavaManager.getJavaManager(project);
                cacheSupportArray[n] = javaManager.getCacheSupport();
                cacheSupportArray[n].beginCacheUse();
                try {
                    RenameMessage.firePreChildRenamed((Subject)project, (Context)context);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                ++n;
            }
            boolean bl = CopyOfRenameCommand.saveNode(node, uRL, uRL2);
            int n2 = 0;
            while (n2 < contextArray.length) {
                Context context = contextArray[n2];
                cacheSupportArray[n2].endCacheUse();
                if (bl) {
                    try {
                        Project project = context.getProject();
                        RenameMessage.fireObjectRenamed((Subject)node, (URL)uRL, (Context)context);
                        RenameMessage.fireChildRenamed((Subject)project, (URL)uRL, (Node)node, (Context)context);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                ++n2;
            }
            return bl;
        }

        private static boolean doSaveAs(Context[] contextArray, Node node, URL uRL, URL uRL2) {
            boolean bl = CopyOfRenameCommand.saveAsNewNode(contextArray, node, uRL, uRL2);
            if (bl) {
                int n = 0;
                while (n < contextArray.length) {
                    Context context = contextArray[n];
                    Project project = context.getProject();
                    project.markDirty(true);
                    ++n;
                }
            }
            return bl;
        }

        private static boolean saveNode2(Node node, URL uRL, URL uRL2) {
            boolean bl = false;
            node.setURL(uRL2);
            if (!URLFileSystem.isReadOnly((URL)uRL2) || URLFileSystem.setReadOnly((URL)uRL2, (boolean)false)) {
                node.markDirty(true);
                node.isReadOnly();
                try {
                    node.save();
                    bl = true;
                }
                catch (IOException iOException) {
                    node.setURL(uRL);
                    System.err.println("**** ERROR: IOException trying to save " + node.getURL());
                    System.err.println("****        Reason: " + iOException.getLocalizedMessage());
                }
            }
            return bl;
        }

        private static Context[] getOwners(Node node) {
            ArrayList<Context> arrayList = new ArrayList<Context>(1);
            Workspaces workspaces = Ide.getWorkspaces();
            Iterator iterator = workspaces.getChildren();
            while (iterator.hasNext()) {
                Workspace workspace = (Workspace)iterator.next();
                Iterator iterator2 = workspace.getChildren();
                while (iterator2.hasNext()) {
                    Project project = (Project)iterator2.next();
                    if (!project.containsChild((Element)node)) continue;
                    Context context = new Context(workspace, project);
                    context.setNode(node);
                    context.setElement((Element)node);
                    arrayList.add(context);
                }
            }
            return arrayList.toArray(new Context[arrayList.size()]);
        }

        CopyOfRenameCommand() {
        }
    }
}

