/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.refactoring.changes;

import javax.swing.undo.UndoableEdit;
import oracle.ide.model.Node;
import oracle.ide.model.TextNode;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.jdeveloper.refactoring.changes.RefactoringChange;

public class TextChange
extends RefactoringChange {
    private UndoableEdit _undoableEdit;
    private int _offset;
    private int _length;
    private String _textAfter;

    public TextChange(TextNode textNode, int n, String string, String string2) {
        super((Node)textNode);
        this.init(n, string.length(), string2);
    }

    public TextChange(TextNode textNode, int n, int n2, String string) {
        this(textNode, n, n2, string, false);
    }

    public TextChange(TextNode textNode, int n, int n2, String string, boolean bl) {
        super((Node)textNode);
        TextBuffer textBuffer = textNode.acquireTextBuffer();
        if (bl) {
            LineMap lineMap = textBuffer.getLineMap();
            int n3 = lineMap.getLineFromOffset(n);
            int n4 = lineMap.getLineStartOffset(n3);
            String string2 = textBuffer.getString(n4, n - n4);
            int n5 = string2.length() - 1;
            while (n5 >= 0 && Character.isWhitespace(string2.charAt(n5))) {
                --n;
                --n5;
            }
            int n6 = lineMap.getLineFromOffset(n2);
            int n7 = lineMap.getLineEndOffset(n6);
            String string3 = textBuffer.getString(n2, n7 - n2);
            int n8 = string3.length();
            int n9 = 0;
            while (n9 < n8 && Character.isWhitespace(string3.charAt(n9))) {
                ++n2;
                ++n9;
            }
        }
        String string4 = textBuffer.getString(n, n2 - n);
        this.init(n, string4.length(), string);
    }

    private void init(int n, int n2, String string) {
        this._offset = n;
        this._length = n2;
        this._textAfter = string;
    }

    public int compareTo(Object object) {
        RefactoringChange refactoringChange = (RefactoringChange)object;
        int n = TextChange.compareChangeTypes(this, refactoringChange);
        if (n == 0) {
            Node node;
            RefactoringChange refactoringChange2 = refactoringChange;
            Node node2 = this.getNode();
            if (node2 == (node = refactoringChange2.getNode())) {
                TextChange textChange = (TextChange)refactoringChange;
                int n2 = this.getOffset();
                int n3 = textChange.getOffset();
                n = n2 - n3;
            } else {
                String string = node2.getLongLabel();
                String string2 = node.getLongLabel();
                n = string.compareTo(string2);
            }
            n &= 0x8FFFFFFF;
        }
        return n;
    }

    public int getOffset() {
        return this._offset;
    }

    public String getTextAfter() {
        return this._textAfter;
    }

    public TextNode getTextNode() {
        return (TextNode)this.getNode();
    }

    public int getLength() {
        return this._length;
    }

    public boolean doit() throws Exception {
        if (this._undoableEdit == null) {
            String string = this.getTextAfter();
            TextNode textNode = this.getTextNode();
            TextBuffer textBuffer = textNode.acquireTextBuffer();
            int n = this.getOffset();
            int n2 = this.getLength();
            textBuffer.beginEdit();
            textBuffer.remove(n, n2);
            textBuffer.insert(n, string.toCharArray());
            this._undoableEdit = textBuffer.endEdit();
        } else {
            this._undoableEdit.redo();
        }
        return true;
    }

    public boolean undo() throws Exception {
        this._undoableEdit.undo();
        return true;
    }
}

