/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.refactoring.criteria;

import java.text.MessageFormat;
import java.util.Collection;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.jdeveloper.refactoring.criteria.MetParam;
import oracle.jdeveloper.refactoring.model.AbstractSearchCriteria;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;

public final class ChangeMethodCriteria
extends AbstractSearchCriteria {
    private SourceMethod _sourceMethod;
    private String _newMethodName;
    private String _newReturnType;
    private MetParam[] _params;
    private Integer _newModifiers;
    private boolean _useTasks;
    private Boolean _paramOrderChanged;
    private boolean _useExistingMethod;

    public ChangeMethodCriteria(SourceMethod sourceMethod, MetParam[] metParamArray) {
        this._sourceMethod = sourceMethod;
        this._params = metParamArray;
    }

    public int getSearchType() {
        return -2147483532;
    }

    public String getShortTitle() {
        return RefactoringArb.getString(154);
    }

    public String getLongTitle() {
        String string = Util.getFullMethodName((JavaMethod)this.getSourceMethod(), true, true, false);
        String string2 = MessageFormat.format(RefactoringArb.getString(155), string);
        return string2;
    }

    public String getNewMethodName() {
        return this._newMethodName;
    }

    public String getNewReturnType() {
        return this._newReturnType;
    }

    public Integer getNewModifiers() {
        return this._newModifiers;
    }

    public SourceMethod getSourceMethod() {
        return this._sourceMethod;
    }

    public MetParam[] getParams() {
        return this._params;
    }

    public void setNewMethodName(String string) {
        String string2 = this.getSourceMethod().getName();
        this._newMethodName = string2.equals(string) ? null : string;
    }

    public void setNewReturnType(String string) {
        SourceTypeReference sourceTypeReference = this.getSourceMethod().getSourceReturnType();
        boolean bl = ChangeMethodCriteria.isSameType(sourceTypeReference, string);
        this._newReturnType = bl ? null : string;
    }

    public void setAccessibility(int n) {
        this._newModifiers = null;
        int n2 = this.getSourceMethod().getModifiers() & 7;
        if (n2 != n) {
            this._newModifiers = new Integer(n);
        }
    }

    public void setUseTaks(boolean bl) {
        this._useTasks = bl;
    }

    public boolean isUseTasks() {
        return this._useTasks;
    }

    public void setUseExistingMethod(boolean bl) {
        this._useExistingMethod = bl;
    }

    public boolean isUseExistingMethod() {
        return this._useExistingMethod;
    }

    public static boolean isSameType(SourceTypeReference sourceTypeReference, String string) {
        boolean bl = false;
        String string2 = sourceTypeReference.getText();
        if (string.equals(string2)) {
            bl = true;
        } else {
            String string3;
            JavaType javaType = sourceTypeReference.getResolvedType();
            if (javaType != null && string.equals(string3 = javaType.getQualifiedName())) {
                bl = true;
            }
        }
        return bl;
    }

    public boolean isParamOrderChanged() {
        if (this._paramOrderChanged == null) {
            Collection collection = this.getSourceMethod().getParameters();
            if (collection.size() == this.getParams().length) {
                this._paramOrderChanged = Boolean.FALSE;
                int n = 0;
                while (this._paramOrderChanged == Boolean.FALSE && n < this.getParams().length) {
                    MetParam metParam = this.getParams()[n];
                    if (metParam.getOldPosition() != n) {
                        this._paramOrderChanged = Boolean.TRUE;
                    }
                    ++n;
                }
            } else {
                this._paramOrderChanged = Boolean.TRUE;
            }
        }
        return this._paramOrderChanged;
    }

    public boolean areParamsChanged() {
        if (this.isParamOrderChanged()) {
            return true;
        }
        int n = 0;
        while (n < this.getParams().length) {
            MetParam metParam = this.getParams()[n];
            if (metParam.isNameChanged() || metParam.isTypeChanged()) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

