/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.refactoring.criteria;

import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.jdeveloper.refactoring.model.AbstractSearchCriteria;
import oracle.jdeveloper.refactoring.model.ClassDescription;
import oracle.jdeveloper.refactoring.model.FieldDescription;
import oracle.jdeveloper.refactoring.model.MethodDescription;
import oracle.jdeveloper.resource.RefactoringArb;

public class ExtractInterfaceCriteria
extends AbstractSearchCriteria {
    private ClassDescription _sourceClassDescription;
    private String _pkgName;
    private String _interfaceName;
    private MethodDescription[] _methodDescriptions;
    private FieldDescription[] _fieldDescriptions;
    private final JavaType[] _selectedInterfaces;

    public ExtractInterfaceCriteria(ClassDescription classDescription, String string, String string2, JavaType[] javaTypeArray, SourceMethod[] sourceMethodArray, SourceFieldVariable[] sourceFieldVariableArray) {
        this._sourceClassDescription = classDescription;
        this._pkgName = string;
        this._interfaceName = string2;
        this._selectedInterfaces = javaTypeArray;
        this._methodDescriptions = new MethodDescription[sourceMethodArray.length];
        int n = 0;
        while (n < sourceMethodArray.length) {
            SourceMethod sourceMethod = sourceMethodArray[n];
            this._methodDescriptions[n] = new MethodDescription((JavaMethod)sourceMethod);
            ++n;
        }
        this._fieldDescriptions = new FieldDescription[sourceFieldVariableArray.length];
        int n2 = 0;
        while (n2 < sourceFieldVariableArray.length) {
            SourceFieldVariable sourceFieldVariable = sourceFieldVariableArray[n2];
            this._fieldDescriptions[n2] = new FieldDescription((JavaField)sourceFieldVariable);
            ++n2;
        }
    }

    public String getShortTitle() {
        return RefactoringArb.getString(80);
    }

    public int getSearchType() {
        return -2147483534;
    }

    public ClassDescription getSourceClassDescription() {
        return this._sourceClassDescription;
    }

    public String[] getExtractedInterfaceNames() {
        String[] stringArray = new String[this._selectedInterfaces.length];
        int n = 0;
        while (n < this._selectedInterfaces.length) {
            JavaType javaType = this._selectedInterfaces[n];
            stringArray[n] = javaType.getQualifiedName();
            ++n;
        }
        return stringArray;
    }

    public JavaType[] getSelectedInterfaces(JavaProvider javaProvider) {
        return this._selectedInterfaces;
    }

    public SourceMethod[] getSelectedMethods(JavaProvider javaProvider) {
        SourceMethod[] sourceMethodArray = new SourceMethod[this._methodDescriptions.length];
        int n = 0;
        while (n < this._methodDescriptions.length) {
            MethodDescription methodDescription = this._methodDescriptions[n];
            JavaMethod javaMethod = methodDescription.getJavaMethod(javaProvider);
            sourceMethodArray[n] = (SourceMethod)javaMethod.getSourceElement();
            ++n;
        }
        return sourceMethodArray;
    }

    public SourceFieldVariable[] getSelectedFields(JavaProvider javaProvider) {
        SourceFieldVariable[] sourceFieldVariableArray = new SourceFieldVariable[this._fieldDescriptions.length];
        int n = 0;
        while (n < this._fieldDescriptions.length) {
            FieldDescription fieldDescription = this._fieldDescriptions[n];
            JavaField javaField = fieldDescription.getJavaField(javaProvider);
            sourceFieldVariableArray[n] = (SourceFieldVariable)javaField.getSourceElement();
            ++n;
        }
        return sourceFieldVariableArray;
    }

    public String getPkgName() {
        return this._pkgName;
    }

    public String getInterfaceName() {
        return this._interfaceName;
    }

    public FieldDescription[] getFieldDescriptions() {
        return this._fieldDescriptions;
    }

    public MethodDescription[] getMethodDescriptions() {
        return this._methodDescriptions;
    }
}

