/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.refactoring.criteria;

import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.ide.Context;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.refactoring.RenameFilesCriteria;
import oracle.ide.util.ModelUtil;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.refactoring.model.AbstractSearchCriteria;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;

public class MoveClassesCriteria
extends AbstractSearchCriteria
implements RenameFilesCriteria {
    private boolean _searchInComments;
    private boolean _searchInNonJavaFiles;
    private ArrayList _movedClasses;
    private HashMap _mapClasses;
    private HashSet _mapOldPackages;
    private HashMap _mapNewClasses;
    private String _longTitle;
    private String _shortTitle;
    private HashMap _renamedFiles;
    private HashSet _reCaseOnly;
    private ArrayList _movedDirectories;
    private ArrayList _packagePrefixes;
    private final HashMap _misplacedClasses;

    void $init$() {
        this._renamedFiles = new HashMap();
        this._movedDirectories = new ArrayList();
        this._packagePrefixes = new ArrayList();
        this._misplacedClasses = new HashMap();
    }

    public MoveClassesCriteria(boolean bl, boolean bl2, String string, String string2) {
        this.$init$();
        this._longTitle = string;
        this._shortTitle = string2;
        this._movedClasses = new ArrayList();
        this._mapClasses = new HashMap();
        this._mapNewClasses = new HashMap();
        this._mapOldPackages = new HashSet();
        this._searchInComments = bl;
        this._searchInNonJavaFiles = bl2;
    }

    public int getSearchType() {
        return -2147483535;
    }

    public String getShortTitle() {
        if (this._shortTitle == null) {
            return MessageFormat.format(RefactoringArb.getString(105), "" + this._movedClasses.size() + " classes");
        }
        return this._shortTitle;
    }

    public String getLongTitle() {
        if (this._longTitle == null) {
            return this.getShortTitle();
        }
        return this._longTitle;
    }

    public URL[] getOldUrls() {
        Set set = this._renamedFiles.keySet();
        return set.toArray(new URL[set.size()]);
    }

    public URL[] getNewUrls() {
        Collection collection = this._renamedFiles.values();
        return collection.toArray(new URL[collection.size()]);
    }

    public URL getNewUrlFor(URL uRL) {
        return (URL)this._renamedFiles.get(uRL);
    }

    public URL getOverwrittenUrl() {
        URL[] uRLArray = this.getOldUrls();
        int n = 0;
        while (n < uRLArray.length) {
            URL uRL;
            URL uRL2 = uRLArray[n];
            if ((this._reCaseOnly == null || !this._reCaseOnly.contains(uRL2)) && URLFileSystem.exists((URL)(uRL = this.getNewUrlFor(uRL2)))) {
                return uRL;
            }
            ++n;
        }
        return null;
    }

    public void setPreferredPackageUrl(String string, URL uRL) {
        if (string.endsWith(".")) {
            string = string.substring(0, string.length() - 1);
        }
        if (this.getPreferredUrl(string) == null) {
            this.removePackagePrefix(string);
            Object[] objectArray = new Object[]{string, uRL};
            this._packagePrefixes.add(objectArray);
        }
    }

    private void removePackagePrefix(String string) {
        int n = this._packagePrefixes.size() - 1;
        while (n >= 0) {
            Object[] objectArray = (Object[])this._packagePrefixes.get(n);
            String string2 = (String)objectArray[0];
            if (string2.startsWith(string)) {
                this._packagePrefixes.remove(n);
            }
            --n;
        }
    }

    public URL getPreferredUrl(String string) {
        int n = 0;
        while (n < this._packagePrefixes.size()) {
            Object[] objectArray = (Object[])this._packagePrefixes.get(n);
            String string2 = (String)objectArray[0];
            if (string.equals(string2)) {
                URL uRL = (URL)objectArray[1];
                return uRL;
            }
            if (string.startsWith(string2 + '.')) {
                URL uRL = (URL)objectArray[1];
                String string3 = string.substring(string2.length() + 1);
                String string4 = string3.replace('.', '/');
                URL uRL2 = URLFactory.newURL((URL)uRL, (String)string4);
                return uRL2;
            }
            ++n;
        }
        return null;
    }

    private SingleMove addSingleMove(String string, String string2, String string3, String string4) {
        SingleMove singleMove = new SingleMove(string, string2, string3, string4);
        this._movedClasses.add(singleMove);
        this._mapClasses.put(singleMove.getFqOldClassName(), singleMove);
        this._mapNewClasses.put(singleMove.getFqNewClassName(), singleMove);
        this._mapOldPackages.add(singleMove.getOldPackageName());
        return singleMove;
    }

    public void addClassMove(JavaManager javaManager, String string, String string2, String string3, String string4) {
        String string5 = Util.getFqClassName(string, string2);
        SourceClass sourceClass = this.findSourceClass(javaManager, string5);
        if (sourceClass != null) {
            SourceClass sourceClass2;
            SourceFile sourceFile;
            JavaClass javaClass;
            String string6;
            SingleMove singleMove = this.addClassMove(sourceClass, string3, string4);
            if (string2.indexOf(46) == -1 && (string6 = singleMove.getFqOldClassName()).equals((javaClass = (sourceFile = (sourceClass2 = this.findSourceClass(javaManager, string6)).getOwningSourceFile()).getPrimaryClass()).getQualifiedName())) {
                URL uRL;
                URL uRL2 = sourceFile.getURL();
                String string7 = uRL2.getPath();
                int n = string7.lastIndexOf(46);
                String string8 = string7.substring(n);
                URL uRL3 = this.getPreferredUrl(string3);
                String string9 = string4 + string8;
                if (uRL3 == null) {
                    URL uRL4 = URLFileSystem.getParent((URL)uRL2);
                    String string10 = URLFileSystem.getPath((URL)uRL4);
                    int n2 = string != null && !string.equals("") ? string.length() : -1;
                    int n3 = string10.length();
                    String string11 = string10.substring(0, n3 - n2 - 1);
                    String string12 = string3.replace('.', '/');
                    if (!string12.equals("")) {
                        string12 = string12 + '/';
                    }
                    uRL = URLFactory.newFileURL((String)(string11 + string12 + string9));
                } else {
                    uRL = URLFactory.newURL((URL)uRL3, (String)string9);
                }
                if (!uRL2.equals(uRL)) {
                    this._renamedFiles.put(uRL2, uRL);
                    if (string.equalsIgnoreCase(string3) && string2.equalsIgnoreCase(string4)) {
                        if (this._reCaseOnly == null) {
                            this._reCaseOnly = new HashSet(1);
                        }
                        this._reCaseOnly.add(uRL2);
                    }
                }
            }
        }
    }

    public void addDirectoryMove(JavaManager javaManager, URL uRL, String string, Project project, URL uRL2, String string2) {
        if (!string.endsWith("/")) {
            string = string + '/';
        }
        if (!string2.endsWith("/")) {
            string2 = string2 + '/';
        }
        this._addDirectoryMove(javaManager, uRL, string, project, uRL2, string2);
    }

    private void _addDirectoryMove(JavaManager javaManager, URL uRL, String string, Project project, URL uRL2, String string2) {
        URL uRL3 = URLFactory.newURL((URL)uRL, (String)string);
        URL[] uRLArray = URLFileSystem.list((URL)uRL3);
        if (uRLArray != null) {
            URL uRL4 = URLFactory.newDirURL((URL)uRL2, (String)string2);
            this._movedDirectories.add(new URL[]{uRL3, uRL4});
            String string3 = URLFileSystem.getPath((URL)uRL3);
            int n = 0;
            while (n < uRLArray.length) {
                URL uRL5 = uRLArray[n];
                String string4 = URLFileSystem.getPath((URL)uRL5);
                String string5 = string4.substring(string3.length());
                this._addDirectoryMove(javaManager, uRL, string + string5, project, uRL2, string2 + string5);
                ++n;
            }
        } else {
            if (Util.isJavaSource(uRL3)) {
                String string6 = URLFileSystem.getFileName((URL)uRL3);
                String string7 = string2.substring(0, string2.length() - string6.length() - 1);
                String string8 = string7.replace('/', '.');
                SourceFile sourceFile = javaManager.getSourceFile(uRL3);
                Collection collection = sourceFile.getClasses();
                for (SourceClass sourceClass : collection) {
                    this.addClassMove(sourceClass, string8, sourceClass.getName());
                }
            }
            URL uRL6 = URLFactory.newURL((URL)uRL2, (String)string2);
            this._renamedFiles.put(uRL3, uRL6);
        }
    }

    public void addFileMove(Context context, URL uRL, URL uRL2) {
        URL uRL3 = URLFileSystem.exists((URL)uRL) ? uRL : (URLFileSystem.exists((URL)uRL2) ? uRL2 : null);
        if (uRL3 != null && Util.isJavaSource(uRL3)) {
            throw new IllegalArgumentException();
        }
        this._renamedFiles.put(uRL, uRL2);
    }

    private SingleMove addClassMove(SourceClass sourceClass, String string, String string2) {
        String string3 = sourceClass.getPackageName();
        int n = string3.length() == 0 ? 0 : string3.length() + 1;
        String string4 = sourceClass.getQualifiedName();
        String string5 = string4.substring(n);
        SingleMove singleMove = this.addSingleMove(string3, string5, string, string2);
        Collection collection = sourceClass.getDeclaredClasses();
        for (JavaClass javaClass : collection) {
            SourceClass sourceClass2;
            if (javaClass.getName() == null || (sourceClass2 = (SourceClass)javaClass.getSourceElement()) == null) continue;
            String string6 = sourceClass2.getName();
            this.addClassMove(sourceClass2, string, string2 + '.' + string6);
        }
        return singleMove;
    }

    public void hintMisplacedFile(SourceFile sourceFile) {
        List list = sourceFile.getSourceClasses();
        this.hintMisplacedClasses(list);
    }

    private void hintMisplacedClasses(Collection collection) {
        for (SourceClass sourceClass : collection) {
            String string = sourceClass.getRawName();
            this._misplacedClasses.put(string, sourceClass);
            Collection collection2 = sourceClass.getDeclaredClasses();
            this.hintMisplacedClasses(collection2);
        }
    }

    public SourceClass findSourceClass(JavaManager javaManager, String string) {
        SourceClass sourceClass = javaManager.getSourceClass(string);
        SourceClass sourceClass2 = sourceClass != null ? sourceClass : (SourceClass)this._misplacedClasses.get(string);
        return sourceClass2;
    }

    public boolean isSearchInComments() {
        return this._searchInComments;
    }

    public boolean isSearchInNonJavaFiles() {
        return this._searchInNonJavaFiles;
    }

    public String[] getFqOldClassesNames() {
        String[] stringArray = new String[this._movedClasses.size()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = ((SingleMove)this._movedClasses.get(n)).getFqOldClassName();
            ++n;
        }
        return stringArray;
    }

    public String[] getFqNewClassesNames() {
        String[] stringArray = new String[this._movedClasses.size()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = ((SingleMove)this._movedClasses.get(n)).getFqNewClassName();
            ++n;
        }
        return stringArray;
    }

    public String[] getNewClsNames() {
        String[] stringArray = new String[this._movedClasses.size()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = ((SingleMove)this._movedClasses.get(n)).getNewClsName();
            ++n;
        }
        return stringArray;
    }

    public String[] getOldClsNames() {
        String[] stringArray = new String[this._movedClasses.size()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = ((SingleMove)this._movedClasses.get(n)).getOldClsName();
            ++n;
        }
        return stringArray;
    }

    public String[] getOldPackageNames() {
        String[] stringArray = new String[this._mapOldPackages.size()];
        stringArray = this._mapOldPackages.toArray(stringArray);
        return stringArray;
    }

    public String[] getNewPackageNames() {
        HashSet<String> hashSet = new HashSet<String>();
        int n = 0;
        while (n < this._movedClasses.size()) {
            String string = ((SingleMove)this._movedClasses.get(n)).getNewPackageName();
            hashSet.add(string);
            ++n;
        }
        String[] stringArray = new String[hashSet.size()];
        stringArray = hashSet.toArray(stringArray);
        return stringArray;
    }

    public boolean isMovedClass(String string) {
        Object v = this._mapClasses.get(string);
        return v != null;
    }

    public boolean isChangedPackage(String string) {
        return this._mapOldPackages.contains(string);
    }

    public String convertClassName(String string) {
        SingleMove singleMove = (SingleMove)this._mapClasses.get(string);
        if (singleMove != null) {
            return singleMove.getFqNewClassName();
        }
        return string;
    }

    public String getPackageFromFqClassName(String string) {
        SingleMove singleMove = (SingleMove)this._mapClasses.get(string);
        if (singleMove != null) {
            return singleMove.getNewPackageName();
        }
        return null;
    }

    public String getNewPackageFromFqNewClassName(String string) {
        SingleMove singleMove = (SingleMove)this._mapNewClasses.get(string);
        if (singleMove != null) {
            return singleMove.getNewPackageName();
        }
        return null;
    }

    public String getNewClsNameFromFqClassName(String string) {
        SingleMove singleMove = (SingleMove)this._mapClasses.get(string);
        if (singleMove != null) {
            return singleMove.getNewClsName();
        }
        return null;
    }

    public String getOldClsNameFromFqClassName(String string) {
        SingleMove singleMove = (SingleMove)this._mapClasses.get(string);
        if (singleMove != null) {
            return singleMove.getOldClsName();
        }
        return null;
    }

    public String getNewClsNameFromFqNewClassName(String string) {
        SingleMove singleMove = (SingleMove)this._mapNewClasses.get(string);
        if (singleMove != null) {
            return singleMove.getNewClsName();
        }
        return null;
    }

    public String getNewFqClsNameFromFqOldClassName(String string) {
        SingleMove singleMove = (SingleMove)this._mapClasses.get(string);
        if (singleMove != null) {
            return singleMove.getFqNewClassName();
        }
        return null;
    }

    public String getOldPackageNameAtIndex(int n) {
        return ((SingleMove)this._movedClasses.get(n)).getOldPackageName();
    }

    public String getNewPackageNameAtIndex(int n) {
        return ((SingleMove)this._movedClasses.get(n)).getNewPackageName();
    }

    public String getNewClsNameAtIndex(int n) {
        return ((SingleMove)this._movedClasses.get(n)).getNewClsName();
    }

    public URL[][] getMovedDirectories() {
        URL[][] uRLArray = new URL[this._movedDirectories.size()][];
        this._movedDirectories.toArray((T[])uRLArray);
        return uRLArray;
    }

    public class SingleMove {
        private String _oldPackageName;
        private String _oldClsName;
        private String _newClsName;
        private String _newPackageName;

        SingleMove(String string, String string2, String string3, String string4) {
            this._oldPackageName = string;
            this._oldClsName = string2;
            this._newPackageName = string3;
            this._newClsName = string4;
        }

        public String getOldPackageName() {
            return this._oldPackageName;
        }

        public String getNewPackageName() {
            return this._newPackageName;
        }

        public String getOldClsName() {
            return this._oldClsName;
        }

        public String getNewClsName() {
            return this._newClsName;
        }

        public String getFqOldClassName() {
            if (!ModelUtil.hasLength((String)this._oldPackageName)) {
                return this._oldClsName;
            }
            return this._oldPackageName + "." + this._oldClsName;
        }

        public String getFqNewClassName() {
            if (!ModelUtil.hasLength((String)this._newPackageName)) {
                return this._newClsName;
            }
            return this._newPackageName + "." + this._newClsName;
        }
    }
}

