/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.refactoring.criteria;

import java.net.URL;
import java.text.MessageFormat;
import oracle.ide.net.URLFileSystem;
import oracle.jdeveloper.refactoring.model.AbstractSearchCriteria;
import oracle.jdeveloper.refactoring.model.ClassDescription;
import oracle.jdeveloper.resource.RefactoringArb;

public class SafeDeleteClassesCriteria
extends AbstractSearchCriteria {
    private URL[] _urls;
    private ClassDescription[] _classDescriptions;

    public SafeDeleteClassesCriteria(URL[] uRLArray, ClassDescription[] classDescriptionArray) {
        this._urls = uRLArray;
        this._classDescriptions = classDescriptionArray;
    }

    public int getSearchType() {
        return -2147483538;
    }

    public String getShortTitle() {
        int n = this._classDescriptions.length;
        String string = this._urls.length == 1 ? URLFileSystem.getFileName((URL)this._urls[0]) : (n == 1 ? this._classDescriptions[0].getClassName() : (this._urls.length > 1 ? URLFileSystem.getFileName((URL)this._urls[0]) + ", ..." : (n > 1 ? this._classDescriptions[0].getClassName() + ", ..." : "...")));
        return MessageFormat.format(RefactoringArb.getString(124), string);
    }

    public String getLongTitle() {
        int n = this._classDescriptions.length;
        String string = this._urls.length == 1 ? URLFileSystem.getPlatformPathName((URL)this._urls[0]) : (n == 1 ? this._classDescriptions[0].getQualifiedName() : (this._urls.length > 1 ? URLFileSystem.getPlatformPathName((URL)this._urls[0]) + ", ..." : (n > 1 ? this._classDescriptions[0].getQualifiedName() + ", ..." : "...")));
        String string2 = MessageFormat.format(RefactoringArb.getString(122), string);
        return string2;
    }

    public String[] getFqClassNames() {
        String[] stringArray = new String[this._classDescriptions.length];
        int n = 0;
        while (n < this._classDescriptions.length) {
            ClassDescription classDescription = this._classDescriptions[n];
            stringArray[n] = classDescription.getQualifiedName();
            ++n;
        }
        return stringArray;
    }

    public URL[] getUrls() {
        return this._urls;
    }
}

