/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.refactoring.criteria;

import java.text.MessageFormat;
import oracle.jdeveloper.refactoring.model.AbstractSearchCriteria;
import oracle.jdeveloper.refactoring.model.MethodDescription;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.search.Scope;

public class SearchMethodCriteria
extends AbstractSearchCriteria {
    private MethodDescription _methodDescription;
    private boolean _overloadedMethods;
    private boolean _searchInComments;
    private boolean _searchInLibraries;
    private boolean _searchInNonJavaFiles;
    private boolean _includeDeclaration;
    private boolean _includeInvocation;
    private Scope _scope;

    void $init$() {
        this._includeDeclaration = true;
        this._includeInvocation = true;
        this._scope = Scope.DUMMY_SCOPE;
    }

    public SearchMethodCriteria(MethodDescription methodDescription) {
        this(methodDescription, false);
    }

    public SearchMethodCriteria(MethodDescription methodDescription, boolean bl) {
        this.$init$();
        this._methodDescription = methodDescription;
        this._overloadedMethods = bl;
    }

    public int getSearchType() {
        return 2;
    }

    public String getShortTitle() {
        String string = this._overloadedMethods ? this._methodDescription.getClassName() + "." + this._methodDescription.getMemberName() + "(_)" : this._methodDescription.getShortName();
        return MessageFormat.format(RefactoringArb.getString(44), string);
    }

    public String getLongTitle() {
        String string = this._overloadedMethods ? this._methodDescription.getFqClassName() + "." + this._methodDescription.getMemberName() + "(_)" : this._methodDescription.getLongName();
        return MessageFormat.format(RefactoringArb.getString(44), string);
    }

    public MethodDescription getMethodDescription() {
        return this._methodDescription;
    }

    public String getFqClassName() {
        return this._methodDescription.getFqClassName();
    }

    public String getMethodName() {
        return this._methodDescription.getMemberName();
    }

    public boolean isOverloadedMethods() {
        return this._overloadedMethods;
    }

    public String[] getParameterTypes() {
        if (this.isOverloadedMethods()) {
            return null;
        }
        return this._methodDescription.getParameterTypes();
    }

    public boolean isIncludeDeclaration() {
        return this._includeDeclaration;
    }

    public void setIncludeDeclaration(boolean bl) {
        this._includeDeclaration = bl;
    }

    public boolean isIncludeInvocation() {
        return this._includeInvocation;
    }

    public void setIncludeInvocation(boolean bl) {
        this._includeInvocation = bl;
    }

    public boolean isSearchInComments() {
        return this._searchInComments;
    }

    public void setSearchInComments(boolean bl) {
        this._searchInComments = bl;
    }

    public boolean isSearchInLibraries() {
        return this._searchInLibraries;
    }

    public void setSearchInLibraries(boolean bl) {
        this._searchInLibraries = bl;
    }

    public boolean isSearchInNonJavaFiles() {
        return this._searchInNonJavaFiles;
    }

    public void setSearchInNonJavaFiles(boolean bl) {
        this._searchInNonJavaFiles = bl;
    }

    public Scope getScope() {
        return this._scope;
    }

    public void setScope(Scope scope) {
        this._scope = scope;
    }
}

