/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.refactoring.criteria;

import java.net.URL;
import java.text.MessageFormat;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.TextNode;
import oracle.javatools.buffer.OffsetMark;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferListener;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.jdeveloper.refactoring.model.AbstractSearchCriteria;
import oracle.jdeveloper.resource.RefactoringArb;

public class SearchVariableCriteria
extends AbstractSearchCriteria
implements TextBufferListener {
    private SourceVariable _sourceVariable;
    private SourceFile _sourceFile;
    private boolean _searchInComments;
    private OffsetMark _offsetMark;
    private int _startOffset;
    private int _length;
    private boolean _valid;

    void $init$() {
        this._valid = true;
    }

    public SearchVariableCriteria(SourceVariable sourceVariable, SourceFile sourceFile, boolean bl) {
        this.$init$();
        this._sourceVariable = sourceVariable;
        this._sourceFile = sourceFile;
        this._searchInComments = bl;
        URL uRL = sourceFile.getURL();
        TextNode textNode = (TextNode)NodeFactory.find((URL)uRL);
        TextBuffer textBuffer = textNode.acquireTextBuffer();
        this._startOffset = sourceVariable.getStartOffset();
        this._length = sourceVariable.getEndOffset() - sourceVariable.getStartOffset();
        this._offsetMark = textBuffer.addOffsetMark(this._startOffset);
        textBuffer.addTextBufferListener((TextBufferListener)this);
    }

    public int getSearchType() {
        return 6;
    }

    public String getShortTitle() {
        return MessageFormat.format(RefactoringArb.getString(44), this.getVariableName());
    }

    public boolean isValid() {
        return this._valid;
    }

    public SourceVariable getVariable() {
        return this._sourceVariable;
    }

    public String getVariableName() {
        return this._sourceVariable.getName();
    }

    public SourceFile getSourceFile() {
        return this._sourceFile;
    }

    public void insertUpdate(TextBuffer textBuffer, int n, int n2, char[] cArray) {
        this.whenTextChangesAt(n, n2);
    }

    public void removeUpdate(TextBuffer textBuffer, int n, int n2, char[] cArray) {
    }

    public void attributeUpdate(TextBuffer textBuffer, int n) {
    }

    private void whenTextChangesAt(int n, int n2) {
        int n3 = this._offsetMark.getOffset();
        if (SearchVariableCriteria.intersects(n, n + n2, n3) || SearchVariableCriteria.intersects(n3, n3 + this._length, n)) {
            this.whenTextHasChanged();
        }
    }

    private void whenTextHasChanged() {
        this._valid = false;
    }

    private static boolean intersects(int n, int n2, int n3) {
        return n <= n3 && n3 <= n2;
    }

    public boolean isSearchInComments() {
        return this._searchInComments;
    }
}

