/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.refactoring.model;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.ArrayList;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.LineNavigationPoint;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.navigation.NavigationManager;
import oracle.ide.navigation.NavigationPoint;

public abstract class BaseUsageEntry {
    public static final String PROPERTY_VALID = "VALID";
    public static final int TYPE_DEFINITION = 0;
    public static final int TYPE_USAGE = 1;
    private Project _project;
    private int _usageType;
    private ArrayList _propertyChangeListeners;
    private boolean _included;
    private Object _userObject;

    void $init$() {
        this._propertyChangeListeners = new ArrayList(2);
        this._included = true;
    }

    protected BaseUsageEntry(Project project, int n) {
        this.$init$();
        this._project = project;
        this._usageType = n;
    }

    public Project getProject() {
        return this._project;
    }

    public int getUsageType() {
        return this._usageType;
    }

    public void goToChange(boolean bl, boolean bl2) {
        Project project = this.getProject();
        Context context = Context.newIdeContext();
        context.setWorkspace(Ide.getActiveWorkspace());
        context.setProject(project);
        URL uRL = this.getURL();
        try {
            Node node = NodeFactory.findOrCreate((URL)uRL);
            context.setNode(node);
            int n = this.getOffset();
            if (bl) {
                LineNavigationPoint lineNavigationPoint = new LineNavigationPoint(context, n, false);
                NavigationManager navigationManager = NavigationManager.getNavigationManager();
                navigationManager.navigateTo((NavigationPoint)lineNavigationPoint);
            } else {
                EditorManager editorManager = EditorManager.getEditorManager();
                OpenEditorOptions openEditorOptions = new OpenEditorOptions(context, CodeEditor.class);
                openEditorOptions.setFlags(1);
                CodeEditor codeEditor = (CodeEditor)editorManager.openEditor(openEditorOptions);
                codeEditor.gotoOffset(n, 0);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._propertyChangeListeners.add(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._propertyChangeListeners.remove(propertyChangeListener);
    }

    protected void fireProperyChange(String string, Object object, Object object2) {
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, string, object, object2);
        int n = 0;
        while (n < this._propertyChangeListeners.size()) {
            PropertyChangeListener propertyChangeListener = (PropertyChangeListener)this._propertyChangeListeners.get(n);
            propertyChangeListener.propertyChange(propertyChangeEvent);
            ++n;
        }
    }

    public abstract void release();

    public abstract URL getURL();

    public abstract int getOffset();

    public abstract int getLength();

    public boolean isIncluded() {
        return this._included;
    }

    public void setIncluded(boolean bl) {
        this._included = bl;
    }

    public abstract boolean isValid();

    public Object getUserObject() {
        return this._userObject;
    }

    public void setUserObject(Object object) {
        this._userObject = object;
    }
}

