/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.refactoring.model;

import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.model.JavaClass;

public abstract class ClassDescription {
    public abstract String getPackageName();

    public abstract String getClassName();

    public abstract String getQualifiedName();

    public abstract boolean isInterface();

    public abstract JavaClass getJavaClass(JavaProvider var1);

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ClassDescription) {
            ClassDescription classDescription = (ClassDescription)object;
            if (this.getQualifiedName().equals(classDescription.getQualifiedName())) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.getQualifiedName().hashCode();
    }

    public static ClassDescription createClassDescription(JavaClass javaClass) {
        return new JotClassDescription(javaClass);
    }

    public static ClassDescription createClassDescription(String string, String string2, boolean bl) {
        return new StringClassDescription(string, string2, bl, null);
    }

    private static class JotClassDescription
    extends ClassDescription {
        private JavaClass _javaClass;

        public JotClassDescription(JavaClass javaClass) {
            this._javaClass = javaClass;
        }

        public String getPackageName() {
            return this._javaClass.getPackageName();
        }

        public String getClassName() {
            return this._javaClass.getName();
        }

        public String getQualifiedName() {
            return this._javaClass.getQualifiedName();
        }

        public boolean isInterface() {
            return this._javaClass.isInterface();
        }

        public JavaClass getJavaClass(JavaProvider javaProvider) {
            return this._javaClass;
        }
    }

    private static class StringClassDescription
    extends ClassDescription {
        private String _packageName;
        private String _className;
        private String _qualifiedName;
        private boolean _isInterface;

        private StringClassDescription(String string, String string2, boolean bl) {
            this._packageName = string == null ? "" : string;
            this._className = string2;
            this._qualifiedName = string == null ? string2 : string + '.' + string2;
            this._isInterface = bl;
        }

        public String getPackageName() {
            return this._packageName;
        }

        public String getClassName() {
            return this._className;
        }

        public String getQualifiedName() {
            return this._qualifiedName;
        }

        public boolean isInterface() {
            return this._isInterface;
        }

        public JavaClass getJavaClass(JavaProvider javaProvider) {
            String string = this.getQualifiedName();
            return javaProvider.getClass(string);
        }

        StringClassDescription(String string, String string2, boolean bl, 1 var4_4) {
            this(string, string2, bl);
        }

        public final class 1 {
        }
    }
}

