/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.refactoring.model;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.jdeveloper.refactoring.changes.RefactoringChange;
import oracle.jdeveloper.refactoring.model.SearchOperation;
import oracle.jdeveloper.refactoring.model.URLRefactoringHandler;
import oracle.jdeveloper.refactoring.model.UsageModel;
import oracle.jdevimpl.refactoring.TextChangeCommand;

public abstract class TextChangeBasedRefactoringHandler
extends URLRefactoringHandler {
    private static final String CACHED_CHANGES_KEY = "CACHED_CHANGES";

    protected RefactoringChange[] getChanges(SearchOperation searchOperation, UsageModel usageModel, Project project) {
        return null;
    }

    private RefactoringChange[] getCachedChanges(SearchOperation searchOperation, UsageModel usageModel, Project project) {
        RefactoringChange[] refactoringChangeArray = null;
        String string = CACHED_CHANGES_KEY + this.hashCode();
        HashMap<Project, RefactoringChange[]> hashMap = (HashMap<Project, RefactoringChange[]>)searchOperation.getProperty(string);
        if (hashMap == null) {
            hashMap = new HashMap<Project, RefactoringChange[]>();
            searchOperation.setProperty(string, hashMap);
        } else {
            refactoringChangeArray = (RefactoringChange[])hashMap.get(project);
        }
        if (refactoringChangeArray == null) {
            refactoringChangeArray = this.getChanges(searchOperation, usageModel, project);
            hashMap.put(project, refactoringChangeArray);
        }
        return refactoringChangeArray;
    }

    public Node[] getAffectedNodes(SearchOperation searchOperation, UsageModel usageModel, Project project) {
        RefactoringChange[] refactoringChangeArray = this.getCachedChanges(searchOperation, usageModel, project);
        HashSet<Node> hashSet = new HashSet<Node>();
        int n = 0;
        while (n < refactoringChangeArray.length) {
            RefactoringChange refactoringChange = refactoringChangeArray[n];
            Node node = refactoringChange.getNode();
            if (node != null) {
                hashSet.add(node);
            }
            ++n;
        }
        return hashSet.toArray(new Node[hashSet.size()]);
    }

    public boolean doChanges(SearchOperation searchOperation, UsageModel usageModel, Project project) {
        boolean bl = false;
        RefactoringChange[] refactoringChangeArray = this.getCachedChanges(searchOperation, usageModel, project);
        List<RefactoringChange> list = Arrays.asList(refactoringChangeArray);
        TextChangeCommand textChangeCommand = new TextChangeCommand(searchOperation, list);
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        try {
            if (commandProcessor.invoke((Command)textChangeCommand) == 0) {
                bl = true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bl;
    }
}

