/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.refactoring.model;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import oracle.ide.Context;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.jdeveloper.java.JavaClassLocator;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.refactoring.model.ProgressIndicator;
import oracle.jdeveloper.refactoring.model.SearchOperation;
import oracle.jdeveloper.refactoring.model.UsageModel;
import oracle.jdevimpl.refactoring.search.Scope;

public abstract class URLHandler {
    public Project[] getIncludedProjects(SearchOperation searchOperation, ProgressIndicator progressIndicator) {
        return null;
    }

    public abstract HashSet chooseURLs(SearchOperation var1, Project var2, ProgressIndicator var3);

    public abstract UsageModel findUsages(SearchOperation var1, Project var2, URL[] var3, ProgressIndicator var4);

    public static Project[] getIncludedProjects(SearchOperation searchOperation, String string) {
        return URLHandler.getIncludedProjects(searchOperation, new String[]{string});
    }

    public static Project[] getIncludedProjects(SearchOperation searchOperation, String[] stringArray) {
        return URLHandler.getIncludedProjects(searchOperation, stringArray, Scope.createDummyScope());
    }

    public static Project[] getIncludedProjects(SearchOperation searchOperation, String[] stringArray, Scope scope) {
        Context context = searchOperation.getContext();
        Workspace workspace = context.getWorkspace();
        Project project = context.getProject();
        ArrayList<Project> arrayList = new ArrayList<Project>();
        JavaManager javaManager = JavaManager.getJavaManager(project);
        JavaClassLocator javaClassLocator = javaManager.getJavaClassLocator();
        URL[] uRLArray = new URL[stringArray.length];
        URL[] uRLArray2 = new URL[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            uRLArray[n] = javaClassLocator.getClassURL(string);
            uRLArray2[n] = javaClassLocator.getSourceURL(string);
            ++n;
        }
        if (scope.isValidProject(project)) {
            arrayList.add(project);
        }
        Iterator iterator = workspace.getChildren();
        block1: while (iterator.hasNext()) {
            Project project2 = (Project)iterator.next();
            if (!scope.isValidProject(project2) || project.equals((Object)project2)) continue;
            JavaManager javaManager2 = JavaManager.getJavaManager(project2);
            JavaClassLocator javaClassLocator2 = javaManager2.getJavaClassLocator();
            int n2 = 0;
            while (n2 < stringArray.length) {
                URL uRL = uRLArray[n2];
                String string = stringArray[n2];
                if (URLHandler.isSameClassFile(uRL, javaClassLocator2, string)) {
                    arrayList.add(project2);
                    continue block1;
                }
                if (URLHandler.isSameSourceFile(uRLArray2[n2], javaClassLocator2, string)) {
                    arrayList.add(project2);
                    continue block1;
                }
                ++n2;
            }
        }
        Project[] projectArray = arrayList.toArray(new Project[arrayList.size()]);
        return projectArray;
    }

    private static boolean isSameClassFile(URL uRL, JavaClassLocator javaClassLocator, String string) {
        URL uRL2;
        return uRL != null && uRL.equals(uRL2 = javaClassLocator.getClassURL(string));
    }

    private static boolean isSameSourceFile(URL uRL, JavaClassLocator javaClassLocator, String string) {
        URL uRL2;
        return uRL != null && uRL.equals(uRL2 = javaClassLocator.getSourceURL(string));
    }
}

