/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.refactoring.model;

import java.net.URL;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.TextNode;
import oracle.javatools.buffer.OffsetMark;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferListener;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.jdeveloper.refactoring.model.BaseUsageEntry;

public class UsageEntry
extends BaseUsageEntry
implements TextBufferListener {
    public static final int VALIDITY_IGNORE = 0;
    public static final int VALIDITY_RANGE = 1;
    public static final int VALIDITY_BUFFER = 2;
    private TextNode _textNode;
    private int _validityType;
    private int _length;
    private boolean _valid;
    private OffsetMark _offsetMark;
    private TextBuffer _textBuffer;
    private String _originalText;
    private int _originalOffsetPos;

    void $init$() {
        this._valid = true;
    }

    public UsageEntry(Project project, TextNode textNode, int n, int n2, int n3) {
        super(project, n3);
        this.$init$();
        this.init(textNode, n2, n, 1);
    }

    public UsageEntry(Project project, URL uRL, int n, int n2, int n3, int n4) {
        super(project, n3);
        this.$init$();
        Node node = NodeFactory.find((URL)uRL);
        this.init((TextNode)node, n2, n, n4);
    }

    public UsageEntry(Project project, SourceElement sourceElement, int n, int n2) {
        super(project, n);
        this.$init$();
        SourceFile sourceFile = sourceElement.getOwningSourceFile();
        int n3 = sourceElement.getStartOffset();
        int n4 = sourceElement.getEndOffset();
        TextNode textNode = (TextNode)NodeFactory.find((URL)sourceFile.getURL());
        this.init(textNode, n4 - n3, n3, n2);
    }

    public static UsageEntry createEntry(Project project, URL uRL, int n, int n2) {
        return UsageEntry.createEntry(project, uRL, n, n2, 1);
    }

    public static UsageEntry createEntry(Project project, URL uRL, int n, int n2, int n3) {
        UsageEntry usageEntry = null;
        try {
            Node node = NodeFactory.findOrCreate((URL)uRL);
            if (node instanceof TextNode) {
                TextNode textNode = (TextNode)node;
                usageEntry = new UsageEntry(project, textNode, n, n2, n3);
            }
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        return usageEntry;
    }

    private void init(TextNode textNode, int n, int n2, int n3) {
        this._textNode = textNode;
        this._textBuffer = textNode.acquireTextBuffer();
        this._length = n;
        this._validityType = n3;
        this._originalOffsetPos = n2;
        this._offsetMark = this._textBuffer.addOffsetMark(this._originalOffsetPos);
        this._originalText = this._textBuffer.getString(n2, n);
        if (this._validityType != 0) {
            this._textBuffer.addTextBufferListener((TextBufferListener)this);
        }
    }

    public void release() {
        if (this._textBuffer != null) {
            this._textBuffer.removeOffsetMark(this._offsetMark);
            this._offsetMark = null;
            this._textBuffer.removeTextBufferListener((TextBufferListener)this);
            this._textBuffer = null;
        }
    }

    public boolean isValid() {
        return this._valid;
    }

    public TextNode getTextNode() {
        return this._textNode;
    }

    public URL getURL() {
        return this._textNode.getURL();
    }

    public TextBuffer getTextBuffer() {
        return this._textBuffer;
    }

    public int getOffset() {
        return this._offsetMark.getOffset();
    }

    public int getLength() {
        return this._length;
    }

    public void insertUpdate(TextBuffer textBuffer, int n, int n2, char[] cArray) {
        this.whenTextChangesAt(n, n2);
    }

    public void removeUpdate(TextBuffer textBuffer, int n, int n2, char[] cArray) {
        this.whenTextChangesAt(n, n2);
    }

    public void attributeUpdate(TextBuffer textBuffer, int n) {
        switch (n) {
            case 4: {
                int n2 = this.getOffset();
                int n3 = this._textBuffer.getLength();
                if (n2 + this._length < n3) {
                    String string = this._textBuffer.getString(n2, this._length);
                    if (this._originalText.equals(string)) break;
                    this.whenTextHasChanged();
                    break;
                }
                this.whenTextHasChanged();
            }
        }
    }

    private void whenTextChangesAt(int n, int n2) {
        boolean bl;
        int n3 = this._offsetMark.getOffset();
        switch (this._validityType) {
            case 1: {
                bl = UsageEntry.intersects(n, n + n2, n3) || UsageEntry.intersects(n3, n3 + this._length, n);
                break;
            }
            case 2: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        if (bl) {
            this.whenTextHasChanged();
        }
    }

    private static boolean intersects(int n, int n2, int n3) {
        return n <= n3 && n3 <= n2;
    }

    private void whenTextHasChanged() {
        if (this._valid) {
            this._valid = false;
            this.fireProperyChange("VALID", Boolean.TRUE, Boolean.FALSE);
        }
    }
}

