/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.refactoring.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.dialogs.ProgressBar;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.ResourceUtils;
import oracle.ide.vcs.VCSManager;
import oracle.jdeveloper.refactoring.util.Util;

public class MakeWritableHelper {
    private static String dialogTitle = "Refactoring";

    public static boolean makeWritable(URL[] uRLArray, String string) {
        String string2 = dialogTitle;
        dialogTitle = string;
        boolean bl = MakeWritableHelper.makeWritable(uRLArray);
        dialogTitle = string2;
        return bl;
    }

    public static boolean makeWritable(URL[] uRLArray) {
        ArrayList<URL> arrayList = new ArrayList<URL>(Arrays.asList(uRLArray));
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            if (URLFileSystem.isReadOnly((URL)((URL)iterator.next()))) continue;
            iterator.remove();
        }
        int n = 0;
        Iterator iterator2 = arrayList.iterator();
        while (iterator2.hasNext()) {
            if (!VCSManager.getVCSManager().isVersioned((URL)iterator2.next())) continue;
            ++n;
        }
        return (n <= 0 || MakeWritableHelper.checkout(arrayList, n)) && MakeWritableHelper.setReadWrite(arrayList);
    }

    private static boolean showMessage(Collection collection, String string) {
        boolean bl = false;
        Vector<String> vector = new Vector<String>();
        for (URL uRL : collection) {
            String string2 = URLFileSystem.getPlatformPathName((URL)uRL);
            vector.add(string2);
        }
        Collections.sort(vector);
        JList jList = new JList(vector);
        JScrollPane jScrollPane = new JScrollPane(jList);
        JLabel jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)jScrollPane, (String)string);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)jLabel, "North");
        jPanel.add((Component)jScrollPane, "Center");
        JEWTDialog jEWTDialog = new JEWTDialog((Frame)Ide.getMainWindow(), dialogTitle, 7);
        jEWTDialog.setContent((Component)jPanel);
        jEWTDialog.setDefaultButton(1);
        bl = jEWTDialog.runDialog();
        return bl;
    }

    private static boolean checkout(Collection collection, int n) {
        if (collection.size() <= 0) {
            return true;
        }
        boolean bl = true;
        1MyRunnable myRunnable = new 1MyRunnable((Component)Ide.getMainWindow(), collection, n);
        bl = myRunnable.start();
        return bl;
    }

    private static boolean setReadWrite(Collection collection) {
        boolean bl = false;
        if (collection.size() > 0) {
            boolean bl2 = MakeWritableHelper.showMessage(collection, "The following files will be made writable:");
            if (bl2) {
                bl = true;
                int n = 0;
                Iterator iterator = collection.iterator();
                while (bl && iterator.hasNext()) {
                    URL uRL = (URL)iterator.next();
                    if (URLFileSystem.setReadOnly((URL)uRL, (boolean)false)) {
                        iterator.remove();
                    } else if (Util.setReadOnly(uRL, false)) {
                        iterator.remove();
                    } else {
                        String string = MessageFormat.format("Failed to make {0} writable", URLFileSystem.getPlatformPathName((URL)uRL));
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)string, (String)"File State", null);
                        bl = false;
                    }
                    ++n;
                }
            }
        } else {
            bl = true;
        }
        return bl;
    }

    public static class 1MyRunnable
    implements Runnable {
        private ProgressBar _progressBar;
        private boolean _results;
        private final /* synthetic */ Collection v$urls;
        private final /* synthetic */ int v$versionedUrlCount;

        public 1MyRunnable(Component component, Collection collection, int n) {
            this.v$versionedUrlCount = n;
            this.v$urls = collection;
            this._progressBar = new ProgressBar(component, "File State", (Runnable)this, false);
        }

        public boolean start() {
            this._progressBar.start("Performing version control operations", " ");
            return this._results;
        }

        public void run() {
            boolean bl = true;
            int n = 0;
            Iterator iterator = this.v$urls.iterator();
            while (bl && iterator.hasNext()) {
                URL uRL = (URL)iterator.next();
                int n2 = (n + 1) * 100 / this.v$versionedUrlCount;
                String string = URLFileSystem.getPlatformPathName((URL)uRL);
                if (!VCSManager.getVCSManager().isVersioned(uRL)) continue;
                ++n;
                if (!this._progressBar.hasUserCancelled()) {
                    this._progressBar.updateProgress(n2, null, string);
                    try {
                        if (VCSManager.getVCSManager().checkOutNode(NodeFactory.find((URL)uRL))) {
                            iterator.remove();
                            continue;
                        }
                        bl = false;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    continue;
                }
                bl = false;
            }
            this._progressBar.setDoneStatus();
            this._results = bl;
        }
    }
}

