/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.refactoring.util;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.undo.UndoableEdit;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.TextNode;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.todo.AbstractToDoItem;
import oracle.ide.todo.ToDoItem;
import oracle.ide.todo.ToDoManager;
import oracle.ide.view.View;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.write.SourceTransaction;
import oracle.jdeveloper.java.CacheSupport;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdeveloper.refactoring.events.RefactoringEvent;
import oracle.jdeveloper.refactoring.model.SearchOperation;
import oracle.jdeveloper.refactoring.util.MakeWritableHelper;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdevimpl.refactoring.RefManagerImpl;
import oracle.jdevimpl.refactoring.util.AbortedOperationException;

public class RefactoringCommandSupport {
    private HashMap _transactions;
    private HashSet _affectedNodes;
    private ArrayList _createdURLs;
    private ArrayList _deletedURLs;
    private boolean _openCreatedFiles;
    private SearchOperation _searchOperation;
    private ArrayList _todos;
    private HashMap _caretPositionings;

    void $init$() {
        this._transactions = new HashMap();
        this._affectedNodes = new HashSet();
        this._todos = new ArrayList();
    }

    public RefactoringCommandSupport() {
        this.$init$();
    }

    public void setOpenCreatedFiles(boolean bl) {
        this._openCreatedFiles = bl;
    }

    public void setSearchOperation(SearchOperation searchOperation) {
        this._searchOperation = searchOperation;
    }

    public final SourceTransaction beginTransaction(SourceElement sourceElement) {
        SourceFile sourceFile = sourceElement.getOwningSourceFile();
        SourceTransaction sourceTransaction = (SourceTransaction)this._transactions.get(sourceFile);
        if (sourceTransaction == null) {
            TextBuffer textBuffer = sourceFile.getTextBuffer();
            textBuffer.setReadOnly(false);
            sourceTransaction = sourceFile.beginTransaction();
            this._transactions.put(sourceFile, sourceTransaction);
            URL uRL = sourceFile.getURL();
            this.addAffectedURL(uRL);
        }
        return sourceTransaction;
    }

    public SourceFile createSourceFile(Context context, String string, String string2) {
        String string3 = string.replace('.', '/');
        URL uRL = PathsConfiguration.getURLForPackage(string3, context);
        if (uRL == null) {
            throw new AbortedOperationException();
        }
        URL uRL2 = URLFactory.newURL((URL)uRL, (String)(string2 + ".java"));
        Project project = context.getProject();
        SourceFile sourceFile = this.createSourceFile(project, uRL2);
        return sourceFile;
    }

    public SourceFile createSourceFile(Project project, URL uRL) {
        JavaManager javaManager = JavaManager.getJavaManager(project);
        SourceFile sourceFile = javaManager.getSourceFile(uRL);
        if (sourceFile == null) {
            try {
                sourceFile = javaManager.createSourceFile(uRL);
                if (this._createdURLs == null) {
                    this._createdURLs = new ArrayList(1);
                }
                this._createdURLs.add(uRL);
                this.beginTransaction((SourceElement)sourceFile);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return sourceFile;
    }

    private boolean isCreatedFile(URL uRL) {
        return this._createdURLs != null && this._createdURLs.contains(uRL);
    }

    public void deleteFile(URL uRL) {
        if (this._deletedURLs == null) {
            this._deletedURLs = new ArrayList(1);
        }
        this._deletedURLs.add(uRL);
    }

    private boolean isDeletedFile(URL uRL) {
        return this._deletedURLs != null && this._deletedURLs.contains(uRL);
    }

    public void addAffectedURL(URL uRL) {
        try {
            Node node = NodeFactory.findOrCreate((URL)uRL);
            this._affectedNodes.add(node);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean commit(Context var1_1, String var2_2) {
        block7: {
            var3_3 = false;
            var4_4 = new MyCommand(var1_1, var2_2, this);
            var5_5 = CommandProcessor.getInstance();
            try {
                try {
                    if (this._searchOperation != null) {
                        this._searchOperation.clear();
                    }
                    var3_3 = var5_5.invoke((Command)var4_4) == 0;
                }
                catch (Exception var6_6) {
                    var6_6.printStackTrace();
                    var7_7 = FeedbackManager.getFeedbackManager();
                    var7_7.reportException("", (Throwable)var6_6);
                }
            }
            finally {
                if (var3_3) break block7;
                ** for (var9_12 : this._affectedNodes)
            }
lbl-1000:
            // 1 sources

            {
                if (!var9_12.isReadOnly() || !(var9_12 instanceof TextNode) || (var11_16 = (var10_14 = (TextNode)var9_12).acquireTextBuffer()).isReadOnly()) continue;
                var11_16.setReadOnly(true);
                continue;
            }
lbl21:
            // 1 sources

            this.abort();
        }
        return var3_3;
    }

    public void abort() {
        Collection collection = this._transactions.values();
        for (SourceTransaction sourceTransaction : collection) {
            sourceTransaction.abort();
        }
        this._affectedNodes.clear();
        this._transactions.clear();
    }

    public void addToDo(SourceElement sourceElement, String string) {
        Object[] objectArray = new Object[]{sourceElement, string};
        this._todos.add(objectArray);
    }

    public void repositionCaret(CodeEditor codeEditor, SourceElement sourceElement, boolean bl) {
        CaretPositioning caretPositioning = new CaretPositioning(codeEditor, sourceElement, bl);
        if (this._caretPositionings == null) {
            this._caretPositionings = new HashMap(1);
        }
        this._caretPositionings.put(codeEditor, caretPositioning);
    }

    static HashMap ra$_transactions(RefactoringCommandSupport refactoringCommandSupport) {
        return refactoringCommandSupport._transactions;
    }

    static ArrayList ra$_deletedURLs(RefactoringCommandSupport refactoringCommandSupport) {
        return refactoringCommandSupport._deletedURLs;
    }

    static boolean mav$isDeletedFile(RefactoringCommandSupport refactoringCommandSupport, URL uRL) {
        return refactoringCommandSupport.isDeletedFile(uRL);
    }

    static boolean mav$isCreatedFile(RefactoringCommandSupport refactoringCommandSupport, URL uRL) {
        return refactoringCommandSupport.isCreatedFile(uRL);
    }

    static ArrayList ra$_createdURLs(RefactoringCommandSupport refactoringCommandSupport) {
        return refactoringCommandSupport._createdURLs;
    }

    static ArrayList ra$_todos(RefactoringCommandSupport refactoringCommandSupport) {
        return refactoringCommandSupport._todos;
    }

    static boolean ra$_openCreatedFiles(RefactoringCommandSupport refactoringCommandSupport) {
        return refactoringCommandSupport._openCreatedFiles;
    }

    static HashMap ra$_caretPositionings(RefactoringCommandSupport refactoringCommandSupport) {
        return refactoringCommandSupport._caretPositionings;
    }

    static SearchOperation ra$_searchOperation(RefactoringCommandSupport refactoringCommandSupport) {
        return refactoringCommandSupport._searchOperation;
    }

    static HashSet ra$_affectedNodes(RefactoringCommandSupport refactoringCommandSupport) {
        return refactoringCommandSupport._affectedNodes;
    }

    private static class MyCommand
    extends Command {
        private Node[] _affectedNodes;
        private RefactoringCommandSupport _pendingCommand;
        private UndoableEdit[] _undoableEdits;
        private HashMap _createdFiles;
        private HashMap _deletedFiles;
        private SearchOperation _searchOperation;
        private int _caretPositionBefore;
        private int _caretPositionAfter;
        private WeakReference _codeEditorReference;
        private boolean _isDone;

        void $init$() {
            this._caretPositionBefore = -1;
            this._caretPositionAfter = -1;
            this._isDone = false;
        }

        public MyCommand(Context context, String string, RefactoringCommandSupport refactoringCommandSupport) {
            super(-1, 3, string);
            this.$init$();
            this.setContext(context);
            this._searchOperation = RefactoringCommandSupport.ra$_searchOperation(refactoringCommandSupport);
            HashSet hashSet = RefactoringCommandSupport.ra$_affectedNodes(refactoringCommandSupport);
            this._affectedNodes = hashSet.toArray(new Node[hashSet.size()]);
            this._pendingCommand = refactoringCommandSupport;
        }

        public int doit() throws Exception {
            int n = 1;
            if (this.prepareFiles()) {
                CacheSupport cacheSupport = this.beginCacheUse();
                try {
                    this.fireEvent(4);
                    if (this._pendingCommand == null) {
                        this.redo();
                    } else {
                        CodeEditor codeEditor;
                        boolean bl = RefactoringCommandSupport.ra$_openCreatedFiles(this._pendingCommand);
                        HashMap hashMap = RefactoringCommandSupport.ra$_caretPositionings(this._pendingCommand);
                        Context context = this.getContext();
                        View view = context.getView();
                        if (view instanceof CodeEditor) {
                            codeEditor = (CodeEditor)view;
                            this._caretPositionBefore = codeEditor.getCaretPosition();
                            this._codeEditorReference = new WeakReference<CodeEditor>(codeEditor);
                        } else {
                            codeEditor = null;
                        }
                        this.commitTransactions();
                        if (bl && this._createdFiles != null) {
                            for (URL uRL : this._createdFiles.keySet()) {
                                Util.openEditor(this.getContext(), uRL);
                            }
                        }
                        if (hashMap != null) {
                            Collection collection = hashMap.values();
                            for (CaretPositioning caretPositioning : collection) {
                                caretPositioning.repositionCaret();
                            }
                        }
                        if (codeEditor != null) {
                            this._caretPositionAfter = codeEditor.getCaretPosition();
                        }
                    }
                    this.deleteURLs(this._deletedFiles);
                    this._isDone = true;
                    n = 0;
                }
                finally {
                    this.saveClosedNodes();
                    cacheSupport.endCacheUse();
                }
                if (n == 0) {
                    this.fireEvent(5);
                }
            }
            return n;
        }

        private void createToDos() {
            ArrayList arrayList = RefactoringCommandSupport.ra$_todos(this._pendingCommand);
            ArrayList<AbstractToDoItem> arrayList2 = new ArrayList<AbstractToDoItem>(arrayList.size());
            ToDoManager toDoManager = ToDoManager.getToDoManager();
            int n = 0;
            while (n < arrayList.size()) {
                Object[] objectArray = (Object[])arrayList.get(n);
                SourceElement sourceElement = (SourceElement)objectArray[0];
                String string = (String)objectArray[1];
                AbstractToDoItem abstractToDoItem = (AbstractToDoItem)toDoManager.createToDoItem(string, 1, null);
                SourceFile sourceFile = sourceElement.getOwningSourceFile();
                URL uRL = sourceFile.getURL();
                abstractToDoItem.setURL(uRL);
                TextBuffer textBuffer = sourceFile.getTextBuffer();
                LineMap lineMap = textBuffer.getLineMap();
                int n2 = sourceElement.getStartOffset();
                int n3 = lineMap.getLineFromOffset(n2) + 1;
                abstractToDoItem.setLine(n3);
                arrayList2.add(abstractToDoItem);
                ++n;
            }
            if (arrayList2.size() > 0) {
                ToDoItem[] toDoItemArray = arrayList2.toArray(new ToDoItem[arrayList2.size()]);
                toDoManager.add(toDoItemArray);
            }
        }

        private void fireEvent(int n) {
            if (this._searchOperation != null) {
                RefManagerImpl refManagerImpl = RefManagerImpl.getImplInstance();
                refManagerImpl.fireRefEvent(new RefactoringEvent(n, this._searchOperation));
            }
        }

        private void saveClosedNodes() throws IOException {
            EditorManager editorManager = EditorManager.getEditorManager();
            if (editorManager != null) {
                HashSet<Node> hashSet = new HashSet<Node>();
                List list = editorManager.getAllEditors();
                int n = 0;
                while (n < list.size()) {
                    Node node;
                    Editor editor = (Editor)list.get(n);
                    Context context = editor.getContext();
                    if (context != null && (node = context.getNode()) != null) {
                        hashSet.add(node);
                    }
                    ++n;
                }
                Node[] nodeArray = this.getAffectedNodes();
                int n2 = 0;
                while (n2 < nodeArray.length) {
                    Node node = nodeArray[n2];
                    if (!hashSet.contains(node)) {
                        node.save();
                    }
                    ++n2;
                }
            }
        }

        private void redo() throws IllegalAccessException, InstantiationException, IOException {
            CodeEditor codeEditor;
            if (this._createdFiles != null) {
                for (URL uRL : this._createdFiles.keySet()) {
                    String string = (String)this._createdFiles.get(uRL);
                    this.createNode(uRL, string);
                }
            }
            int n = 0;
            while (n < this._undoableEdits.length) {
                UndoableEdit undoableEdit = this._undoableEdits[n];
                undoableEdit.redo();
                ++n;
            }
            if (this._caretPositionAfter >= 0 && this._codeEditorReference != null && (codeEditor = (CodeEditor)this._codeEditorReference.get()) != null) {
                codeEditor.setCaretPosition(this._caretPositionAfter);
            }
        }

        public int undo() throws Exception {
            int n = 1;
            if (this.prepareFiles()) {
                CacheSupport cacheSupport = this.beginCacheUse();
                this.fireEvent(6);
                try {
                    CodeEditor codeEditor;
                    if (this._deletedFiles != null) {
                        for (URL uRL : this._deletedFiles.keySet()) {
                            String string = (String)this._deletedFiles.get(uRL);
                            this.createNode(uRL, string);
                        }
                    }
                    int n2 = 0;
                    while (n2 < this._undoableEdits.length) {
                        UndoableEdit undoableEdit = this._undoableEdits[n2];
                        undoableEdit.undo();
                        ++n2;
                    }
                    this.deleteURLs(this._createdFiles);
                    if (this._caretPositionBefore >= 0 && this._codeEditorReference != null && (codeEditor = (CodeEditor)this._codeEditorReference.get()) != null) {
                        codeEditor.setCaretPosition(this._caretPositionBefore);
                    }
                    n = 0;
                    this._isDone = false;
                }
                finally {
                    this.saveClosedNodes();
                    cacheSupport.endCacheUse();
                }
                if (n == 0) {
                    this.fireEvent(7);
                }
            }
            return n;
        }

        private boolean prepareFiles() {
            URL[] uRLArray = new URL[this._affectedNodes.length];
            int n = 0;
            while (n < this._affectedNodes.length) {
                Node node = this._affectedNodes[n];
                uRLArray[n] = node.getURL();
                ++n;
            }
            return MakeWritableHelper.makeWritable(uRLArray);
        }

        private void deleteURLs(Map map) throws IOException {
            if (map != null) {
                for (URL uRL : map.keySet()) {
                    Node node = NodeFactory.find((URL)uRL);
                    if (node != null) {
                        node.delete();
                        continue;
                    }
                    URLFileSystem.delete((URL)uRL);
                }
            }
        }

        public Node[] getAffectedNodes() {
            ArrayList<Object> arrayList;
            Collection<Object> collection;
            if (this._pendingCommand == null) {
                HashMap hashMap = this._isDone ? this._deletedFiles : this._createdFiles;
                collection = hashMap == null ? null : hashMap.keySet();
            } else {
                collection = RefactoringCommandSupport.ra$_createdURLs(this._pendingCommand);
            }
            if (collection != null) {
                arrayList = new ArrayList(this._affectedNodes.length);
                int n = 0;
                while (n < this._affectedNodes.length) {
                    Node node = this._affectedNodes[n];
                    URL uRL = node.getURL();
                    if (!collection.contains(uRL)) {
                        arrayList.add(node);
                    }
                    ++n;
                }
            } else {
                arrayList = new ArrayList<Node>(Arrays.asList(this._affectedNodes));
            }
            Node node = this.context.getNode();
            arrayList.remove(node);
            return arrayList.toArray(new Node[arrayList.size()]);
        }

        private CacheSupport beginCacheUse() {
            Context context = this.getContext();
            Project project = context.getProject();
            JavaManager javaManager = JavaManager.getJavaManager(project);
            CacheSupport cacheSupport = javaManager.getCacheSupport();
            cacheSupport.beginCacheUse();
            return cacheSupport;
        }

        private void commitTransactions() {
            HashMap hashMap = RefactoringCommandSupport.ra$_transactions(this._pendingCommand);
            ArrayList arrayList = RefactoringCommandSupport.ra$_deletedURLs(this._pendingCommand);
            if (arrayList != null) {
                int n = 0;
                while (n < arrayList.size()) {
                    URL uRL = (URL)arrayList.get(n);
                    this.addFileDeletion(uRL);
                    ++n;
                }
            }
            Set set = hashMap.keySet();
            int n = set.size();
            ArrayList<UndoableEdit> arrayList2 = new ArrayList<UndoableEdit>(n);
            for (SourceFile sourceFile : set) {
                URL uRL = sourceFile.getURL();
                if (RefactoringCommandSupport.mav$isDeletedFile(this._pendingCommand, uRL)) continue;
                SourceTransaction sourceTransaction = (SourceTransaction)hashMap.get(sourceFile);
                try {
                    UndoableEdit undoableEdit = sourceTransaction.commit();
                    if (RefactoringCommandSupport.mav$isCreatedFile(this._pendingCommand, uRL)) {
                        this.addFileCreation(sourceFile);
                        Node node = NodeFactory.find((URL)uRL);
                        node.save();
                        continue;
                    }
                    if (undoableEdit == null) continue;
                    arrayList2.add(undoableEdit);
                }
                catch (Exception exception) {
                    System.out.println("Failed to commit " + URLFileSystem.getPlatformPathName((URL)uRL));
                    exception.printStackTrace();
                }
            }
            this.createToDos();
            this._pendingCommand = null;
            this._undoableEdits = arrayList2.toArray(new UndoableEdit[arrayList2.size()]);
        }

        private void addFileCreation(SourceFile sourceFile) {
            URL uRL = sourceFile.getURL();
            String string = sourceFile.getText();
            if (this._createdFiles == null) {
                this._createdFiles = new HashMap(1);
                this._createdFiles.put(uRL, string);
            }
        }

        private void addFileDeletion(URL uRL) {
            try {
                TextNode textNode = (TextNode)NodeFactory.findOrCreate((URL)uRL);
                TextBuffer textBuffer = textNode.acquireTextBuffer();
                String string = textBuffer.getString(0, textBuffer.getLength());
                if (this._deletedFiles == null) {
                    this._deletedFiles = new HashMap(1);
                    this._deletedFiles.put(uRL, string);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        private void createNode(URL uRL, String string) throws IllegalAccessException, InstantiationException, IOException {
            char[] cArray = string.toCharArray();
            TextNode textNode = (TextNode)NodeFactory.findOrCreate((URL)uRL);
            TextBuffer textBuffer = textNode.acquireTextBuffer();
            textBuffer.beginEdit();
            textBuffer.removeToEnd(0);
            textBuffer.append(cArray);
            textBuffer.endEdit();
            textNode.releaseTextBuffer();
            textNode.save();
        }
    }

    private static class CaretPositioning {
        private CodeEditor _codeEditor;
        private SourceElement _element;
        private boolean _after;

        public CaretPositioning(CodeEditor codeEditor, SourceElement sourceElement, boolean bl) {
            this._codeEditor = codeEditor;
            this._element = sourceElement;
            this._after = bl;
        }

        public void repositionCaret() {
            int n = this._after ? this._element.getEndOffset() : this._element.getStartOffset();
            this._codeEditor.setCaretPosition(n);
        }
    }
}

