/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.refactoring.util;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import oracle.ide.model.Project;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.jdeveloper.java.util.SourceElementHandle;
import oracle.jdeveloper.refactoring.model.BaseUsageEntry;
import oracle.jdevimpl.refactoring.util.AbortedOperationException;

public class SourceElementEntry
extends BaseUsageEntry
implements PropertyChangeListener {
    private SourceElementHandle _sourceElementHandle;

    public SourceElementEntry(Project project, SourceElement sourceElement, int n) {
        super(project, n);
        this._sourceElementHandle = new SourceElementHandle(sourceElement);
        this._sourceElementHandle.addPropertyChangeListener(this);
    }

    public void release() {
        this._sourceElementHandle.removePropertyChangeListener(this);
        this._sourceElementHandle.release();
    }

    public URL getURL() {
        return this._sourceElementHandle.getURL();
    }

    public int getOffset() {
        return this._sourceElementHandle.getOffset();
    }

    public int getLength() {
        int n = 0;
        SourceElement sourceElement = this.getSourceElement();
        if (sourceElement != null) {
            int n2 = sourceElement.getStartOffset();
            int n3 = sourceElement.getEndOffset();
            n = n3 - n2;
        }
        return n;
    }

    public SourceElement getSourceElement() {
        return this._sourceElementHandle.getElement();
    }

    public SourceElement getSourceElementOrThrow() throws AbortedOperationException {
        SourceElement sourceElement = this.getSourceElement();
        if (sourceElement == null) {
            URL uRL = this.getURL();
            String string = URLFileSystem.getPlatformPathName((URL)uRL);
            throw new AbortedOperationException("The content of the file has changed:" + string);
        }
        return sourceElement;
    }

    public boolean isValid() {
        SourceElement sourceElement = this.getSourceElement();
        return sourceElement != null;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        Object object = propertyChangeEvent.getOldValue();
        Object object2 = propertyChangeEvent.getNewValue();
        this.fireProperyChange(string, object, object2);
    }
}

