/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.refactoring.util;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Dependable;
import oracle.ide.model.DependencyConfiguration;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.TextNode;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.util.ModelUtil;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaMember;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceClassInitializer;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFieldDeclaration;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceMember;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.jdeveloper.model.JavaSourceNode;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdeveloper.refactoring.model.ProgressIndicator;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdeveloper.style.CodingStyleManager;
import oracle.jdeveloper.style.CodingStyleOptions;
import oracle.jdeveloper.usage.UsageQueryTask;
import oracle.jdeveloper.usage.util.BackgroundTask;
import oracle.jdevimpl.refactoring.model.SearchOperationImpl;

public class Util {
    private static final boolean WAIT_WITH_SLEEP = true;
    private static final int SLEEP_TIME = 25;
    private static final int REFRESH_RATE = 500;
    public static final Comparator SOURCE_ELEMENT_POSITION_COMPARATOR = new 1();

    public static void waitUntilFinished(UsageQueryTask usageQueryTask, ProgressIndicator progressIndicator) {
        int n = 500;
        while (!usageQueryTask.isFinished()) {
            if (n >= 500) {
                if (progressIndicator != null) {
                    String string = usageQueryTask.getProgressText();
                    progressIndicator.setProgressStepText(string);
                    n = 0;
                }
            } else {
                n += 25;
            }
            Util.sleep();
        }
    }

    public static void waitUntilFinished(BackgroundTask backgroundTask) {
        while (!backgroundTask.isFinished()) {
            Util.sleep();
        }
    }

    public static void waitUntilFinished(BackgroundTask backgroundTask, ProgressIndicator progressIndicator) {
        int n = 500;
        while (!backgroundTask.isFinished() && !progressIndicator.isUserCancelled()) {
            if (n >= 500) {
                if (progressIndicator != null) {
                    String string = backgroundTask.getProgressText();
                    progressIndicator.setProgressStepText(string);
                    n = 0;
                }
            } else {
                n += 25;
            }
            Util.sleep();
        }
    }

    public static TextNode getTextNode(URL uRL) {
        TextNode textNode = null;
        try {
            textNode = (TextNode)NodeFactory.findOrCreate((URL)uRL);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return textNode;
    }

    public static TextBuffer getTextBuffer(URL uRL) {
        TextBuffer textBuffer = null;
        TextNode textNode = Util.getTextNode(uRL);
        if (textNode != null) {
            textBuffer = textNode.acquireTextBuffer();
        }
        return textBuffer;
    }

    public static void setMnemonic(AbstractButton abstractButton, String string) {
        int n = StringUtils.getMnemonicKeyCode((String)string);
        abstractButton.setMnemonic(n);
        int n2 = StringUtils.getMnemonicIndex((String)string);
        if (n2 != -1) {
            abstractButton.setDisplayedMnemonicIndex(n2);
        }
    }

    public static boolean isJavaSource(URL uRL) {
        String string = uRL.getFile();
        if (string != null) {
            String string2 = string.toLowerCase();
            return string2.endsWith(".java") || string2.endsWith(".sqlj");
        }
        return false;
    }

    public static String cutLongFileName(URL uRL, int n) {
        String string = URLFileSystem.getPlatformPathName((URL)uRL);
        int n2 = string.length();
        if (n2 > n) {
            int n3 = n / 2;
            int n4 = 5;
            int n5 = n3;
            while (n5 > 5) {
                char c = string.charAt(n5);
                if (c == '/' || c == '\\') {
                    n4 = n5 + 1;
                }
                --n5;
            }
            int n6 = n2 - 5;
            int n7 = n2 - n3;
            while (n7 < n2 - 5) {
                char c = string.charAt(n7);
                if (c == '/' || c == '\\') {
                    n6 = n7;
                }
                ++n7;
            }
            string = string.substring(0, n4) + "..." + string.substring(n6);
        }
        return string;
    }

    private static void sleep() {
        try {
            Thread.sleep(25);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    public static String getPackageName(String string) {
        int n = string.lastIndexOf(46);
        if (n > 0) {
            return string.substring(0, n);
        }
        return string;
    }

    public static String getClassName(String string) {
        int n = string.lastIndexOf(46);
        if (n != -1) {
            string = string.substring(n + 1);
        }
        string.replace('$', '.');
        return string;
    }

    public static String getFqClassName(String string, String string2) {
        if (ModelUtil.hasLength((String)string)) {
            return string + "." + string2;
        }
        return string2;
    }

    public static String getFqClassName(String string, String string2, String string3) {
        String string4 = "";
        if (string != null && string.length() != 0) {
            string4 = string4 + string + '.';
        }
        if (string2 != null && string2.length() != 0) {
            string4 = string4 + string2 + '.';
        }
        string4 = string4 + string3;
        return string4;
    }

    public static void openEditor(Context context, URL uRL) {
        Context context2 = new Context(context);
        try {
            JavaSourceNode javaSourceNode = (JavaSourceNode)NodeFactory.findOrCreate((URL)uRL);
            javaSourceNode.setURL(uRL);
            context2.setNode((Node)javaSourceNode);
            EditorManager editorManager = EditorManager.getEditorManager();
            editorManager.openEditorInFrame(CodeEditor.class, context2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static HashSet getDependentProjects(Workspace workspace, Project project) {
        HashSet hashSet = new HashSet();
        Util.getDependantProjects(workspace, project, hashSet);
        return hashSet;
    }

    private static void getDependantProjects(Workspace workspace, Project project, HashSet hashSet) {
        Iterator iterator = workspace.getChildren();
        List list = Util.iteratorAsList(iterator);
        HashSet hashSet2 = new HashSet();
        Util.getDependantProjects(project, list, hashSet2);
        hashSet.addAll(hashSet2);
    }

    private static void getDependantProjects(Project project, List list, HashSet hashSet) {
        if (!hashSet.contains(project)) {
            hashSet.add(project);
            int n = 0;
            while (n < list.size()) {
                Project project2 = (Project)list.get(n);
                Iterator iterator = DependencyConfiguration.getInstance((Project)project2).getDependencies();
                while (iterator.hasNext()) {
                    Project project3;
                    Dependable dependable = (Dependable)iterator.next();
                    Element element = dependable.getSource();
                    if (!(element instanceof Project) || !project.equals((Object)(project3 = (Project)element))) continue;
                    Util.getDependantProjects(project2, list, hashSet);
                }
                ++n;
            }
        }
    }

    public static void showRefactoringErrorMessage(int n) {
        Util.showRefactoringErrorMessage(null, n);
    }

    public static void showRefactoringErrorMessage(int n, int n2) {
        String string = n == -1 ? "Refactoring" : RefactoringArb.getString(n);
        Util.showRefactoringErrorMessage(string, n2);
    }

    private static void showRefactoringErrorMessage(String string, int n) {
        String string2 = RefactoringArb.getString(n);
        Util.showRefactoringErrorMessage(string, string2);
    }

    public static void showRefactoringErrorMessage(String string, String string2) {
        IdeMainWindow ideMainWindow = Ide.getMainWindow();
        if (ideMainWindow != null) {
            MessageDialog.information((Component)ideMainWindow, (Object)string2, (String)(string == null ? "Refactoring" : string), null);
        }
    }

    static boolean isClassInSources(Workspace workspace, Project project, URL uRL) {
        boolean bl = false;
        Project project2 = Util.getDefiningProject(workspace, project, uRL);
        bl = project2 != null;
        return bl;
    }

    public static boolean canRefactor(SourceElement sourceElement) {
        URL uRL;
        SourceFile sourceFile;
        return sourceElement != null && (sourceFile = sourceElement.getOwningSourceFile()) != null && (uRL = sourceFile.getURL()) != null && Util.canRefactor(uRL);
    }

    public static boolean canRefactor(Context context, URL uRL) {
        return Util.canRefactor(uRL) && Util.workspaceContains(context, uRL);
    }

    private static boolean workspaceContains(Context context, URL uRL) {
        Workspace workspace = context != null ? context.getWorkspace() : Ide.getActiveWorkspace();
        Project project = context.getProject();
        if (Util.projectContains(project, uRL)) {
            return true;
        }
        Iterator iterator = workspace.getChildren();
        while (iterator.hasNext()) {
            Project project2 = (Project)iterator.next();
            if (!Util.projectContains(project2, uRL)) continue;
            return true;
        }
        return false;
    }

    private static boolean projectContains(Project project, URL uRL) {
        PathsConfiguration pathsConfiguration;
        URLPath uRLPath;
        boolean bl = false;
        if (project != null && (uRLPath = (pathsConfiguration = PathsConfiguration.getInstance(project)).getProjectSourcePath()).getLongestMatchingEntry(uRL) != null) {
            bl = true;
        }
        return bl;
    }

    public static boolean canRefactor(URL uRL) {
        boolean bl = false;
        try {
            Node node = NodeFactory.findOrCreate((URL)uRL);
            if (node != null && Util.canMakeReadWrite(uRL)) {
                bl = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    private static boolean canMakeReadWrite(URL uRL) {
        String string = uRL.getProtocol();
        return !string.equalsIgnoreCase("jar") && !string.equalsIgnoreCase("zip");
    }

    public static boolean hasUpperCase(String string) {
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (Character.isUpperCase(c)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static boolean isPackagePrivate(int n) {
        return (n & 7) == 0;
    }

    public static boolean isClassInSources(Workspace workspace, Project project, SourceClass sourceClass) {
        boolean bl = false;
        if (sourceClass != null) {
            SourceFile sourceFile = sourceClass.getOwningSourceFile();
            URL uRL = sourceFile.getURL();
            bl = Util.isClassInSources(workspace, project, uRL);
        }
        return bl;
    }

    public static SourceElement getAncestorOfClass(Class clazz, SourceElement sourceElement) {
        while (sourceElement != null) {
            if (clazz.isInstance(sourceElement)) {
                return sourceElement;
            }
            sourceElement = sourceElement.getParent();
        }
        return null;
    }

    public static SourceElement getAncestorOfKind(int n, SourceElement sourceElement) {
        while (sourceElement != null) {
            if (sourceElement.getSymbolKind() == n) {
                return sourceElement;
            }
            sourceElement = sourceElement.getParent();
        }
        return null;
    }

    public static String[] getFqParamTypes(JavaMethod javaMethod) {
        Collection collection = javaMethod.getParameters();
        String[] stringArray = new String[collection.size()];
        int n = 0;
        for (JavaVariable javaVariable : collection) {
            String string = "";
            JavaType javaType = javaVariable.getResolvedType();
            if (javaType != null) {
                string = javaType.getQualifiedName();
            } else {
                SourceTypeReference sourceTypeReference;
                SourceVariable sourceVariable = (SourceVariable)javaVariable.getSourceElement();
                if (sourceVariable != null && (sourceTypeReference = sourceVariable.getSourceType()) != null) {
                    string = sourceTypeReference.getName();
                }
            }
            stringArray[n++] = string;
        }
        return stringArray;
    }

    public static String getFullMethodName(JavaMethod javaMethod, boolean bl, boolean bl2, boolean bl3) {
        String string = null;
        if (bl) {
            JavaClass javaClass = javaMethod.getOwningClass();
            string = bl2 ? javaClass.getQualifiedName() : javaClass.getName();
        }
        String string2 = javaMethod.isConstructor() ? javaMethod.getOwningClass().getName() : javaMethod.getName();
        Collection collection = javaMethod.getParameters();
        String[] stringArray = new String[collection.size()];
        Iterator iterator = collection.iterator();
        int n = 0;
        while (n < stringArray.length) {
            JavaVariable javaVariable = (JavaVariable)iterator.next();
            JavaType javaType = javaVariable.getResolvedType();
            stringArray[n] = javaType != null ? (bl3 ? javaType.getQualifiedName() : javaType.getName()) : "???";
            ++n;
        }
        return Util.getFullMethodName(string, string2, stringArray);
    }

    public static String getFullMethodName(String string, String string2, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null) {
            stringBuffer.append(string);
            stringBuffer.append('.');
        }
        stringBuffer.append(string2);
        stringBuffer.append('(');
        int n = 0;
        while (n < stringArray.length) {
            String string3 = stringArray[n];
            if (n != 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(string3);
            ++n;
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public static SourceElement getStatementLevelElement(SourceElement sourceElement) {
        SourceElement sourceElement2 = sourceElement.getParent();
        while (sourceElement2 != null) {
            int n = sourceElement2.getSymbolKind();
            if (n == 2) {
                return sourceElement;
            }
            sourceElement = sourceElement2;
            sourceElement2 = sourceElement2.getParent();
        }
        return null;
    }

    public static boolean setReadOnly(URL uRL, boolean bl) {
        boolean bl2 = false;
        String[] stringArray = null;
        String string = URLFileSystem.getPlatformPathName((URL)uRL);
        String string2 = System.getProperty("os.name", "");
        if (string2.startsWith("Windows")) {
            stringArray = new String[]{"ATTRIB", bl ? "+R" : "-R", '\"' + string + '\"'};
        } else if (string.equalsIgnoreCase("Linux")) {
            stringArray = new String[]{"chmod", bl ? "u-w" : "u+w", '\"' + string + '\"'};
        }
        if (stringArray != null) {
            Runtime runtime = Runtime.getRuntime();
            try {
                Node node;
                Process process = runtime.exec(stringArray);
                if (process.waitFor() == 0 && (bl2 = new File(string).canWrite()) && (node = NodeFactory.find((URL)uRL)) instanceof TextNode) {
                    TextNode textNode = (TextNode)node;
                    textNode.isReadOnly();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        return bl2;
    }

    public static boolean isInCallToConstructor(SourceElement sourceElement) {
        while (sourceElement != null) {
            int n = sourceElement.getSymbolKind();
            switch (n) {
                case 54: {
                    SourceMethodCallExpression sourceMethodCallExpression = (SourceMethodCallExpression)sourceElement;
                    JavaMethod javaMethod = sourceMethodCallExpression.getResolvedMethod();
                    if (javaMethod == null || !javaMethod.isConstructor()) break;
                    return true;
                }
                case 2: {
                    return false;
                }
            }
            sourceElement = sourceElement.getParent();
        }
        return false;
    }

    public static URL createTypeURL(Context context, String string, String string2) {
        Project project = context.getProject();
        PathsConfiguration pathsConfiguration = PathsConfiguration.getInstance(project);
        URLPath uRLPath = pathsConfiguration.getProjectSourcePath();
        URL[] uRLArray = uRLPath.getEntries();
        URL uRL = uRLArray[0];
        String string3 = string.replace('.', '/');
        uRL = URLFactory.newURL((URL)uRL, (String)string3);
        int n = string2.indexOf(46);
        String string4 = n != -1 ? string2.substring(0, n - 1) : string2;
        URL uRL2 = URLFactory.newURL((URL)uRL, (String)(string4 + ".java"));
        return uRL2;
    }

    public static String getIndentString() {
        CodingStyleManager codingStyleManager = CodingStyleManager.getCodingStyleManager();
        CodingStyleOptions codingStyleOptions = codingStyleManager.getCodingStyleOptions();
        return new String(codingStyleOptions.getIndentChars(1));
    }

    public static Project[] getAffectedProjects(Workspace workspace, URL uRL) {
        HashSet<Project> hashSet = new HashSet<Project>();
        Project[] projectArray = Util.getProjectsContainingSource(workspace, uRL);
        ArrayList<Project> arrayList = new ArrayList<Project>(Arrays.asList(projectArray));
        while (!arrayList.isEmpty()) {
            Project project = arrayList.remove(0);
            hashSet.add(project);
            Iterator iterator = DependencyConfiguration.getInstance((Project)project).getDependencies();
            while (iterator.hasNext()) {
                Dependable dependable = (Dependable)iterator.next();
                Project project2 = (Project)dependable.getSource();
                arrayList.add(project2);
            }
        }
        return hashSet.toArray(new Project[hashSet.size()]);
    }

    public static Project[] getProjectsContainingSource(Workspace workspace, URL uRL) {
        ArrayList<Project> arrayList = new ArrayList<Project>();
        Iterator iterator = workspace.getChildren();
        while (iterator.hasNext()) {
            Project project = (Project)iterator.next();
            ContentSet contentSet = ProjectContent.getInstance((PropertyStorage)project).getAllContents();
            if (!contentSet.canHaveMember(uRL)) continue;
            arrayList.add(0, project);
        }
        return arrayList.toArray(new Project[arrayList.size()]);
    }

    public static Project getDefiningProject(Context context, URL uRL) {
        Project project = context.getProject();
        Workspace workspace = context.getWorkspace();
        return Util.getDefiningProject(workspace, project, uRL);
    }

    private static Project getDefiningProject(Workspace workspace, Project project, URL uRL) {
        Project project2 = null;
        if (Util.isDefiningProject(project, uRL)) {
            project2 = project;
        } else {
            Project[] projectArray = Util.getProjectsContainingSource(workspace, uRL);
            int n = 0;
            while (project2 == null && n < projectArray.length) {
                Project project3 = projectArray[n];
                if (!project3.equals((Object)project) && Util.isDefiningProject(project3, uRL)) {
                    project2 = project3;
                }
                ++n;
            }
        }
        return project2;
    }

    private static boolean isDefiningProject(Project project, URL uRL) {
        ContentSet contentSet = ProjectContent.getInstance((PropertyStorage)project).getAllContents();
        return contentSet.canHaveMember(uRL);
    }

    public static boolean isStaticContext(SourceExpression sourceExpression) {
        SourceExpression sourceExpression2 = sourceExpression;
        while (sourceExpression2 != null) {
            switch (sourceExpression2.getSymbolKind()) {
                case 19: {
                    return ((SourceMethod)sourceExpression2).isStatic();
                }
                case 6: {
                    return false;
                }
                case 9: {
                    return ((SourceFieldDeclaration)sourceExpression2).isStatic();
                }
                case 5: {
                    return ((SourceClassInitializer)sourceExpression2).isStatic();
                }
            }
            sourceExpression2 = sourceExpression2.getParent();
        }
        return false;
    }

    public static SourceTypeReference createSourceType(SourceTypeReference sourceTypeReference, SourceFile sourceFile) {
        SourceTypeReference sourceTypeReference2;
        JavaType javaType = sourceTypeReference.getResolvedType();
        if (javaType != null) {
            SourceFactory sourceFactory = sourceFile.getFactory();
            sourceTypeReference2 = sourceFactory.createType(javaType.getQualifiedName());
        } else {
            sourceTypeReference2 = (SourceTypeReference)sourceTypeReference.cloneSelf(sourceFile);
        }
        return sourceTypeReference2;
    }

    public static void setOperationHints(SearchOperationImpl searchOperationImpl, JavaMember[] javaMemberArray) {
        if (javaMemberArray.length > 0) {
            SourceMember sourceMember;
            int n = 2;
            int n2 = 0;
            while (n > 0 && n2 < javaMemberArray.length) {
                JavaMember javaMember = javaMemberArray[n2];
                int n3 = javaMember.isPrivate() ? 2 : (javaMember.isPackagePrivate() ? 1 : 0);
                n = Math.min(n, n3);
                ++n2;
            }
            if (n > 0 && (sourceMember = (SourceMember)javaMemberArray[0].getSourceElement()) != null) {
                SourceFile sourceFile = sourceMember.getOwningSourceFile();
                switch (n) {
                    case 2: {
                        URL uRL = sourceFile.getURL();
                        searchOperationImpl.setSearchHintFile(uRL);
                        break;
                    }
                    case 1: {
                        String string = sourceFile.getPackageName();
                        searchOperationImpl.setSearchHintPackage(string);
                    }
                }
            }
        }
    }

    public static void setOperationHints(SearchOperationImpl searchOperationImpl, JavaMember javaMember, boolean bl) {
        JavaMember[] javaMemberArray;
        if (bl) {
            JavaClass javaClass = javaMember.getOwningClass();
            Collection collection = javaClass.getDeclaredMethods(javaMember.getName());
            javaMemberArray = collection.toArray(new JavaMember[collection.size()]);
        } else {
            javaMemberArray = new JavaMember[]{javaMember};
        }
        Util.setOperationHints(searchOperationImpl, javaMemberArray);
    }

    public static void setOperationHints(SearchOperationImpl searchOperationImpl, JavaClass javaClass, boolean bl) {
        JavaClass javaClass2 = javaClass.getOwningClass();
        if (javaClass2 != null) {
            JavaMember[] javaMemberArray;
            if (bl) {
                ArrayList<JavaClass> arrayList = new ArrayList<JavaClass>();
                arrayList.add(javaClass2);
                arrayList.addAll(javaClass2.getDeclaredMethods());
                arrayList.addAll(javaClass2.getDeclaredFields());
                arrayList.addAll(javaClass2.getDeclaredClasses());
                javaMemberArray = arrayList.toArray(new JavaMember[arrayList.size()]);
            } else {
                javaMemberArray = new JavaMember[]{javaClass};
            }
            Util.setOperationHints(searchOperationImpl, javaMemberArray);
        }
    }

    public static void dumpProjectDependencies(Workspace workspace) {
        List list = Util.iteratorAsList(workspace.getChildren());
        HashSet hashSet = new HashSet(list);
        System.out.println("---------------------------------------------------");
        int n = 0;
        while (n < list.size()) {
            Project project = (Project)list.get(n);
            Iterator iterator = DependencyConfiguration.getInstance((Project)project).getDependencies();
            while (iterator.hasNext()) {
                Dependable dependable = (Dependable)iterator.next();
                Element element = dependable.getSource();
                if (!(element instanceof Project)) continue;
                System.out.println(project.getShortLabel() + " depends on " + element.getShortLabel());
                hashSet.remove(project);
            }
            ++n;
        }
        System.out.println("---------------------------------------------------");
        for (Project project : hashSet) {
            System.out.println(project.getShortLabel());
            Util.dumpDependencies(workspace, project, "  ", new HashSet());
        }
    }

    private static void dumpDependencies(Workspace workspace, Project project, String string, HashSet hashSet) {
        Iterator iterator = workspace.getChildren();
        while (iterator.hasNext()) {
            Project project2 = (Project)iterator.next();
            if (hashSet.contains(project2)) continue;
            Iterator iterator2 = DependencyConfiguration.getInstance((Project)project2).getDependencies();
            while (iterator2.hasNext()) {
                Dependable dependable = (Dependable)iterator2.next();
                Element element = dependable.getSource();
                if (!element.equals(project)) continue;
                String string2 = project2.getShortLabel();
                System.out.println(string + string2);
                hashSet.add(project2);
                Util.dumpDependencies(workspace, project2, string + "  ", hashSet);
                hashSet.remove(project2);
            }
        }
    }

    private static List iteratorAsList(Iterator iterator) {
        ArrayList arrayList = new ArrayList(10);
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }

    public static final class 1
    implements Comparator {
        public int compare(Object object, Object object2) {
            SourceElement sourceElement = (SourceElement)object;
            SourceElement sourceElement2 = (SourceElement)object2;
            return sourceElement.getStartOffset() - sourceElement2.getStartOffset();
        }
    }
}

