/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.runner;

import java.awt.Component;
import java.io.File;
import java.net.URL;
import java.util.List;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.compiler.Compiler;
import oracle.ide.log.LogPage;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ide.runner.RunProcess;
import oracle.ide.runner.Runner;
import oracle.ide.runner.Starter;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.cm.dt.CmJavaUtil;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.model.JProjectLibraries;
import oracle.jdeveloper.runner.JStarter;
import oracle.jdeveloper.runner.RunConfiguration;
import oracle.jdeveloper.runner.RunMgrArb;
import oracle.jdevimpl.runner.RunConfigurationLaunchPanel;

public abstract class JRunProcess
extends RunProcess {
    protected boolean considerDefaultRunTarget;
    protected RunConfiguration runConfiguration;
    protected long timeAfterCompile;
    public static final String RUN_TYPE_JAVA = "Java";
    public static final String RUN_TYPE_DATABASE = "Database";
    public static final String RUN_TYPE_XSLT = "XSLT";
    public static final String RUN_TYPE_XQUERY = "XQuery";
    public static final String RUN_TYPE_ANT = "Ant";
    public static final String RUN_COOKIE_JAVA_EMBEDDED_SERVER = "Embedded Server";
    public static final String JAVA_FIRST_COMMAND_OPTIONS = "FirstJavaCommandOptions";
    public static final String JAVA_LAST_COMMAND_OPTIONS = "LastJavaCommandOptions";
    public static final String JAVA_CLASS_PATH = "ClassPath";
    public static final String JAVA_BOOT_CLASS_PATH = "BootClassPath";
    public static final String DATABASE_RUN_HELPER = "DatabaseRunHelper";
    public static final String XSLT_FIRST_COMMAND_OPTIONS = "FirstXSLTCommandOptions";
    public static final String XSLT_LAST_COMMAND_OPTIONS = "LastXSLTCommandOptions";
    public static final String ANT_FIRST_COMMAND_OPTIONS = "FirstAntCommandOptions";
    public static final String ANT_LAST_COMMAND_OPTIONS = "LastAntCommandOptions";

    public JRunProcess() {
        this(null);
    }

    public JRunProcess(Context context) {
        super(context);
        if (context != null) {
            this.context = context;
            Node node = RunProcess.getContextNodeForRun((Context)context);
            this.considerDefaultRunTarget = node == null || node instanceof Workspace || node instanceof Project;
        } else {
            Context context2 = new Context(Ide.getMainWindow().getLastActiveView().getContext());
            context2.setWorkspace(Ide.getActiveWorkspace());
            context2.setProject(Ide.getActiveProject());
            this.context = context2;
            this.considerDefaultRunTarget = true;
        }
        Project project = this.getProject();
        this.runConfiguration = RunConfiguration.getInstance((PropertyStorage)project);
        this.logCommandString = this.runConfiguration.isLogCommand();
        this.logOutput = this.runConfiguration.isLogOutput();
        this.logError = this.runConfiguration.isLogError();
        this.allowInput = this.runConfiguration.isAllowInput();
        this.logExit = this.runConfiguration.isLogExit();
    }

    public Project getJProject() {
        return this.getProject();
    }

    public RunConfiguration getRunConfiguration() {
        return this.runConfiguration;
    }

    public long getTimeAfterCompile() {
        return this.timeAfterCompile;
    }

    protected void determineTargetAndStarter(Class clazz) {
        Runner runner = Runner.getRunner();
        Project project = this.getProject();
        boolean bl = project.isDefaultProject();
        URL uRL = null;
        if (this.runConfiguration != null) {
            uRL = this.runConfiguration.getTargetURL();
        }
        boolean bl2 = true;
        if (this.considerDefaultRunTarget && this.runConfiguration != null && !bl) {
            bl2 = this.runConfiguration.isRunActiveFile();
        }
        Node node = null;
        if (bl2) {
            super.determineTargetAndStarter(clazz);
            if (this.target != null) {
                return;
            }
            Node node2 = RunProcess.getContextNodeForRun((Context)this.context);
            if (node2 != null) {
                if (CmJavaUtil.isCMUrl(node2.getURL())) {
                    return;
                }
                if (runner.couldNodeBeRunnable(node2, clazz)) {
                    node = node2;
                }
            }
        }
        if (this.considerDefaultRunTarget) {
            if (uRL == null && !bl) {
                if (RunConfigurationLaunchPanel.showTargetDialog(project, this)) {
                    uRL = this.runConfiguration.getTargetURL();
                } else {
                    this.errors.clear();
                    return;
                }
            }
            if (uRL != null) {
                Node node3 = this.makeTargetNode(uRL);
                if (node3 != null) {
                    if (node3 != node) {
                        String string;
                        boolean bl3 = false;
                        if (runner.couldNodeBeRunnable(node3, clazz)) {
                            if (node != null) {
                                string = RunMgrArb.format(4, node.getShortLabel(), node3.getShortLabel());
                                this.errors.add(string);
                            }
                            int n = this.errors.size();
                            Starter starter = this.getStarterForTarget(node3, clazz);
                            if (starter != null) {
                                this.target = node3;
                                this.starter = starter;
                                if (node != null) {
                                    String string2 = RunMgrArb.format(5, node.getShortLabel(), this.target.getShortLabel());
                                    this.log(string2 + "\n");
                                }
                                return;
                            }
                            bl3 = this.errors.size() == n;
                        } else {
                            bl3 = true;
                        }
                        if (bl3) {
                            string = RunMgrArb.format(3, node3.getShortLabel());
                            this.errors.add(string);
                        }
                    }
                } else {
                    String string = URLFileSystem.getFileName((URL)uRL);
                    String string3 = RunMgrArb.format(2, string);
                    this.errors.add(string3);
                }
            }
        }
    }

    protected boolean checkStarter(Starter starter, List list) {
        if (!(starter instanceof JStarter)) {
            return false;
        }
        return super.checkStarter(starter, list);
    }

    private Node makeTargetNode(URL uRL) {
        try {
            Node node = NodeFactory.find((URL)uRL);
            if (node != null) {
                Node node2 = node;
                return node2;
            }
            if (URLFileSystem.exists((URL)uRL)) {
                Node node3 = node = NodeFactory.findOrCreate((URL)uRL);
                return node3;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    public File getStartDirectory() {
        URL uRL = this.runConfiguration.getRunDirectoryURL();
        if (uRL != null) {
            return new File(uRL.getPath());
        }
        return null;
    }

    private void super_start() {
        super.start();
    }

    public final void start() {
        1 var1_1 = new 1();
        var1_1.setPriority(var1_1.getPriority() - 1);
        var1_1.start();
    }

    protected boolean compile() {
        if (this.runConfiguration != null) {
            Project project;
            Compiler compiler;
            if (this.runConfiguration.isRemoteDebuggingProfiling()) {
                return true;
            }
            if (this.runConfiguration.isCompileBeforeRun() && (compiler = Compiler.getCompiler()) != null && (project = this.getProject()) != null && !project.isDefaultProject()) {
                Context context = new Context((Node)project);
                boolean bl = this.runConfiguration.isIgnoreCompilerErrors();
                if (bl) {
                    this.context.setProperty("CompilerGenerateClassesDespiteErrors", (Object)Boolean.TRUE);
                }
                if (!compiler.compile(context, false, true, true)) {
                    if (bl) {
                        String string = RunMgrArb.getString(7);
                        String string2 = RunMgrArb.getString(8);
                        boolean bl2 = MessageDialog.optionalConfirm((String)"RunWithCompilerErrors", (Component)Ide.getMainWindow(), (String)string2, (String)string, null);
                        if (bl2) {
                            return true;
                        }
                    }
                    return false;
                }
            }
        }
        return true;
    }

    protected LogPage makeLogPage(boolean bl) {
        LogPage logPage = super.makeLogPage(bl);
        if (logPage != null && this.runConfiguration != null && this.runConfiguration.isClearLogBeforeRun()) {
            logPage.clearAll();
        }
        return logPage;
    }

    protected boolean startTarget() {
        Compiler compiler = Compiler.getCompiler();
        if (compiler != null && !compiler.lock(this.context, false)) {
            String string = RunMgrArb.getString(6);
            this.log(string + "\n");
            return false;
        }
        boolean bl = super.startTarget();
        if (compiler != null) {
            compiler.unlock(this.context);
        }
        return bl;
    }

    public JDK getJdkDefinition() {
        Project project = this.getProject();
        JProjectLibraries jProjectLibraries = JProjectLibraries.getInstance((PropertyStorage)project);
        if (jProjectLibraries != null) {
            return jProjectLibraries.getJDK();
        }
        return null;
    }

    public boolean isPlainRun() {
        String[] stringArray = (String[])this.getValue(RUN_TYPE_JAVA, null, JAVA_FIRST_COMMAND_OPTIONS);
        if (stringArray != null && stringArray.length > 0) {
            return false;
        }
        stringArray = (String[])this.getValue(RUN_TYPE_JAVA, null, JAVA_LAST_COMMAND_OPTIONS);
        return stringArray == null || stringArray.length <= 0;
    }

    public boolean isSameType(JRunProcess jRunProcess) {
        return jRunProcess != null && this.getClass() == jRunProcess.getClass();
    }

    static Starter ra$starter(JRunProcess jRunProcess) {
        return jRunProcess.starter;
    }

    static void mav$super_start(JRunProcess jRunProcess) {
        jRunProcess.super_start();
    }

    public final class oracle.jdeveloper.runner.JRunProcess$1
    extends Thread {
        public void run() {
            if (JRunProcess.this.compile()) {
                JRunProcess.this.timeAfterCompile = System.currentTimeMillis();
                SwingUtilities.invokeLater(new 1());
            } else if (JRunProcess.ra$starter(JRunProcess.this) instanceof JStarter) {
                ((JStarter)JRunProcess.ra$starter(JRunProcess.this)).fireCompilationError();
            }
        }

        public final class 1
        implements Runnable {
            public void run() {
                JRunProcess.mav$super_start(JRunProcess.this);
            }
        }
    }
}

