/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.runner;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import oracle.ide.Ide;
import oracle.ide.config.IdeSettings;
import oracle.ide.model.Project;
import oracle.ide.runner.RunProcess;
import oracle.ide.runner.Starter;
import oracle.ide.util.IdeUtil;
import oracle.ide.webbrowser.ProxyOptions;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdeveloper.runner.JRunProcess;
import oracle.jdeveloper.runner.JavaOptionProvider;
import oracle.jdeveloper.runner.RunConfiguration;

public class JStarter
extends Starter {
    private static final List javaOptionProviders = new ArrayList();
    protected JRunProcess jrunProcess;
    protected String[] target;
    protected RunConfiguration runConfiguration;

    public static void addJavaOptionProvider(JavaOptionProvider javaOptionProvider) {
        javaOptionProviders.add(javaOptionProvider);
    }

    public static void removeJavaOptionProvider(JavaOptionProvider javaOptionProvider) {
        javaOptionProviders.remove(javaOptionProvider);
    }

    protected JStarter(JRunProcess jRunProcess, String[] stringArray) {
        super((RunProcess)jRunProcess);
        this.jrunProcess = jRunProcess;
        this.target = stringArray;
        this.runConfiguration = jRunProcess.getRunConfiguration();
    }

    public String[] getStartCommand() {
        ArrayList arrayList = new ArrayList();
        if (!this.addJavaExecutableName(arrayList)) {
            return null;
        }
        if (!this.addJavaVmOption(arrayList)) {
            return null;
        }
        this.addFirstJavaCommandOptions(arrayList);
        this.addClassPathOption(arrayList);
        this.addBootClassPathOption(arrayList);
        this.addJavaOptions(arrayList);
        this.addLastJavaCommandOptions(arrayList);
        this.addTarget(arrayList);
        this.addProgramArguments(arrayList);
        return arrayList.toArray(new String[arrayList.size()]);
    }

    protected boolean addJavaExecutableName(List list) {
        JDK jDK = this.jrunProcess.getJdkDefinition();
        if (jDK != null) {
            String string = jDK.getSDKBinJavaExecutableNoConsole();
            if (string != null) {
                list.add(string);
                return true;
            }
            string = jDK.getJavaExecutableNoConsole();
            if (string != null) {
                list.add(string);
                return true;
            }
        }
        return false;
    }

    protected boolean addJavaVmOption(List list) {
        String string = this.getVMName();
        if (string != null && string.length() > 0) {
            String string2 = "-" + string;
            list.add(string2);
        }
        return true;
    }

    protected final String getVMName() {
        JDK jDK = this.jrunProcess.getJdkDefinition();
        Project project = this.jrunProcess.getJProject();
        return this.runConfiguration.getVMName(jDK, project);
    }

    protected final void addFirstJavaCommandOptions(List list) {
        String[] stringArray = (String[])this.jrunProcess.getValue("Java", null, "FirstJavaCommandOptions");
        if (stringArray != null) {
            JStarter.addArrayToList(list, stringArray);
        }
    }

    protected void addJavaOptions(List list) {
        String string = this.runConfiguration.getJavaOptions();
        String[] stringArray = IdeUtil.convertStringToStringArray((String)string, (boolean)true, (boolean)true);
        JStarter.addArrayToList(list, stringArray);
        int n = javaOptionProviders.size();
        int n2 = 0;
        while (n2 < n) {
            try {
                JavaOptionProvider javaOptionProvider = (JavaOptionProvider)javaOptionProviders.get(n2);
                String[] stringArray2 = javaOptionProvider.getJavaOptions(this.jrunProcess);
                if (stringArray2 != null && stringArray2.length > 0) {
                    JStarter.addArrayToList(list, stringArray2);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n2;
        }
        if (this.runConfiguration.isUseProxy()) {
            String[] stringArray3;
            IdeSettings ideSettings = Ide.getSettings();
            ProxyOptions proxyOptions = ProxyOptions.getProxyOptions();
            if (proxyOptions != null && (stringArray3 = proxyOptions.getJavaProxyOptions()) != null) {
                int n3 = stringArray3.length;
                int n4 = 0;
                while (n4 < n3) {
                    list.add(stringArray3[n4]);
                    ++n4;
                }
            }
        }
    }

    protected final void addClassPathOption(List list) {
        String[] stringArray;
        String string = this.getClassPath();
        if (string != null && string.length() > 0 && (stringArray = this.makeClassPathOption(string)) != null) {
            JStarter.addArrayToList(list, stringArray);
        }
    }

    protected String getClassPath() {
        String string;
        Project project = this.jrunProcess.getJProject();
        String string2 = PathsConfiguration.getInstance(project).getRunClassPath().toString();
        if (string2 == null) {
            string2 = "";
        }
        if ((string = (String)this.jrunProcess.getValue("Java", null, "ClassPath")) != null && string.length() != 0) {
            if (string2.length() > 0) {
                string2 = string2 + File.pathSeparator;
            }
            string2 = string2 + string;
        }
        return string2;
    }

    private String[] makeClassPathOption(String string) {
        if (string != null && string.length() > 0) {
            String[] stringArray = new String[]{"-classpath", string};
            return stringArray;
        }
        return null;
    }

    protected final void addBootClassPathOption(List list) {
        String[] stringArray;
        String string = this.getBootClassPath();
        if (string != null && string.length() > 0 && (stringArray = this.makeBootClassPathOption(string)) != null) {
            JStarter.addArrayToList(list, stringArray);
        }
    }

    protected String getBootClassPath() {
        String string = "";
        String string2 = (String)this.jrunProcess.getValue("Java", null, "BootClassPath");
        if (string2 != null && string2.length() != 0) {
            string = string + string2;
        }
        return string;
    }

    void fireCompilationError() {
    }

    private String[] makeBootClassPathOption(String string) {
        if (string != null && string.length() > 0) {
            String[] stringArray = new String[]{"-Xbootclasspath/a:" + string};
            return stringArray;
        }
        return null;
    }

    protected final void addLastJavaCommandOptions(List list) {
        String[] stringArray = (String[])this.jrunProcess.getValue("Java", null, "LastJavaCommandOptions");
        if (stringArray != null) {
            JStarter.addArrayToList(list, stringArray);
        }
    }

    private void addTarget(List list) {
        if (this.target != null) {
            JStarter.addArrayToList(list, this.target);
        }
    }

    protected void addProgramArguments(List list) {
        String string = this.runConfiguration.getProgramArguments();
        String[] stringArray = IdeUtil.convertStringToStringArray((String)string, (boolean)true, (boolean)true);
        JStarter.addArrayToList(list, stringArray);
        int n = javaOptionProviders.size();
        int n2 = 0;
        while (n2 < n) {
            try {
                JavaOptionProvider javaOptionProvider = (JavaOptionProvider)javaOptionProviders.get(n2);
                String[] stringArray2 = javaOptionProvider.getProgramArguments(this.jrunProcess);
                if (stringArray2 != null && stringArray2.length > 0) {
                    JStarter.addArrayToList(list, stringArray2);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n2;
        }
    }

    protected static void addArrayToList(List list, String[] stringArray) {
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            list.add(stringArray[n2]);
            ++n2;
        }
    }
}

