/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.runner;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.controls.GridBagConstraints2;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.HistoryList;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.runner.RunMgrArb;

public final class RemoteConnectDialog {
    private JEWTDialog dlg;
    private JPanel panel = new JPanel(new GridBagLayout());
    private Listener listener = new Listener();
    private int count;
    private String[] names;
    private String[] values;
    private boolean[] allowBlanks;
    private boolean[] save;
    private JLabel[] labels;
    private HistoryList[] historyLists;
    private JComboBox[] comboBoxes;
    private JTextField[] editors;
    private JCheckBox saveCheckBox;
    private static final String HistoryNamePrefix = "RemoteConnect";

    public static boolean showRemoteConnectDialog(String string, String[] stringArray, String[] stringArray2, boolean[] blArray) {
        return RemoteConnectDialog.showRemoteConnectDialog(string, stringArray, stringArray2, blArray, null, null);
    }

    public static boolean showRemoteConnectDialog(String string, String[] stringArray, String[] stringArray2, boolean[] blArray, String string2) {
        return RemoteConnectDialog.showRemoteConnectDialog(string, stringArray, stringArray2, blArray, null, string2);
    }

    public static boolean showRemoteConnectDialog(String string, String[] stringArray, String[] stringArray2, boolean[] blArray, boolean[] blArray2) {
        return RemoteConnectDialog.showRemoteConnectDialog(string, stringArray, stringArray2, blArray, blArray2, null);
    }

    public static boolean showRemoteConnectDialog(String string, String[] stringArray, String[] stringArray2, boolean[] blArray, boolean[] blArray2, String string2) {
        int n = stringArray.length;
        if (stringArray2.length != n) {
            throw new IllegalArgumentException("values.length must equal names.length");
        }
        if (blArray.length != n) {
            throw new IllegalArgumentException("allowBlanks.length must equal names.length");
        }
        if (blArray2 != null && blArray2.length != 1) {
            throw new IllegalArgumentException("save.length must be 1");
        }
        RemoteConnectDialog remoteConnectDialog = new RemoteConnectDialog(stringArray, stringArray2, blArray, blArray2);
        JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)remoteConnectDialog.panel, (Component)remoteConnectDialog.getInitialFocus(), (String)string);
        remoteConnectDialog.setJEWTDialog(jEWTDialog);
        remoteConnectDialog.setLabels();
        jEWTDialog.setOKButtonEnabled(remoteConnectDialog.canOk());
        if (string2 != null) {
            HelpSystem.getHelpSystem().registerTopic((JComponent)remoteConnectDialog.panel, string2);
        }
        if (WizardLauncher.runDialog((JDialog)jEWTDialog)) {
            remoteConnectDialog.finish();
            return true;
        }
        return false;
    }

    private RemoteConnectDialog(String[] stringArray, String[] stringArray2, boolean[] blArray, boolean[] blArray2) {
        this.count = stringArray.length;
        this.names = stringArray;
        this.values = stringArray2;
        this.allowBlanks = blArray;
        this.save = blArray2;
        int n = 0;
        this.labels = new JLabel[this.count];
        this.comboBoxes = new JComboBox[this.count];
        this.editors = new JTextField[this.count];
        this.historyLists = new HistoryList[this.count];
        int n2 = 0;
        while (n2 < this.count) {
            this.labels[n2] = new JLabel();
            this.historyLists[n2] = Ide.loadHistoryList((String)(HistoryNamePrefix + stringArray[n2]));
            this.comboBoxes[n2] = new JComboBox<String>(this.historyLists[n2].getHistory());
            this.comboBoxes[n2].setEditable(true);
            this.editors[n2] = (JTextField)this.comboBoxes[n2].getEditor().getEditorComponent();
            this.comboBoxes[n2].addActionListener(this.listener);
            IdeUtil.comboBoxSelectItem((JComboBox)this.comboBoxes[n2], (Object)stringArray2[n2]);
            IdeUtil.addComboBoxDocumentListener((JComboBox)this.comboBoxes[n2], (DocumentListener)this.listener);
            this.comboBoxes[n2].addItemListener(this.listener);
            this.panel.add((Component)this.labels[n2], new GridBagConstraints2(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0));
            this.panel.add((Component)this.comboBoxes[n2], new GridBagConstraints2(1, n++, 0, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
            ++n2;
        }
        if (blArray2 != null) {
            this.saveCheckBox = new JCheckBox();
            ResourceUtils.resButton((AbstractButton)this.saveCheckBox, (String)RunMgrArb.getString(21));
            this.panel.add((Component)this.saveCheckBox, new GridBagConstraints2(0, n++, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        }
        this.panel.add((Component)new JLabel(), new GridBagConstraints2(0, n, 0, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    private Component getInitialFocus() {
        if (this.editors.length > 0) {
            return this.editors[0];
        }
        return null;
    }

    private void setJEWTDialog(JEWTDialog jEWTDialog) {
        this.dlg = jEWTDialog;
    }

    private void setLabels() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (this.saveCheckBox != null && (n6 = this.saveCheckBox.getMnemonic()) != 0) {
            arrayList.add(new Integer(n6));
        }
        if (((n5 = this.dlg.getButtonMask()) & 1) != 0 && (n4 = this.dlg.getButtonMnemonic(1)) != 0) {
            arrayList.add(new Integer(n4));
        }
        if ((n5 & 2) != 0 && (n3 = this.dlg.getButtonMnemonic(2)) != 0) {
            arrayList.add(new Integer(n3));
        }
        if ((n5 & 4) != 0 && (n2 = this.dlg.getButtonMnemonic(4)) != 0) {
            arrayList.add(new Integer(n2));
        }
        if ((n5 & 8) != 0 && (n = this.dlg.getButtonMnemonic(8)) != 0) {
            arrayList.add(new Integer(n));
        }
        int n7 = 0;
        while (n7 < this.count) {
            String string = this.names[n7];
            int n8 = 0;
            while (n8 < string.length()) {
                Integer n9;
                char c = string.charAt(n8);
                if (c >= 'a' && c <= 'z') {
                    c = (char)(c - 32);
                }
                if ((c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') && !arrayList.contains(n9 = new Integer(c))) {
                    arrayList.add(n9);
                    string = string.substring(0, n8) + "&" + string.substring(n8);
                    break;
                }
                ++n8;
            }
            ResourceUtils.resLabel((JLabel)this.labels[n7], (Component)this.editors[n7], (String)RunMgrArb.format(20, string));
            ++n7;
        }
    }

    private void enableOk() {
        this.dlg.setOKButtonEnabled(this.canOk());
    }

    private boolean canOk() {
        int n = 0;
        while (n < this.count) {
            String string;
            if (!this.allowBlanks[n] && (string = this.editors[n].getText()).length() == 0) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private void finish() {
        int n = 0;
        while (n < this.count) {
            this.values[n] = this.historyLists[n].comboBoxGetSelectedItem(this.comboBoxes[n]);
            ++n;
        }
        if (this.save != null) {
            this.save[0] = this.saveCheckBox.isSelected();
        }
    }

    static void mav$enableOk(RemoteConnectDialog remoteConnectDialog) {
        remoteConnectDialog.enableOk();
    }

    static JComboBox[] ra$comboBoxes(RemoteConnectDialog remoteConnectDialog) {
        return remoteConnectDialog.comboBoxes;
    }

    static JTextField[] ra$editors(RemoteConnectDialog remoteConnectDialog) {
        return remoteConnectDialog.editors;
    }

    static int ra$count(RemoteConnectDialog remoteConnectDialog) {
        return remoteConnectDialog.count;
    }

    public class Listener
    implements ItemListener,
    DocumentListener,
    ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            int n = 0;
            while (n < RemoteConnectDialog.ra$count(RemoteConnectDialog.this)) {
                if (object == RemoteConnectDialog.ra$comboBoxes(RemoteConnectDialog.this)[n]) {
                    RemoteConnectDialog.ra$editors(RemoteConnectDialog.this)[n].setText((String)RemoteConnectDialog.ra$comboBoxes(RemoteConnectDialog.this)[n].getSelectedItem());
                    break;
                }
                ++n;
            }
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            RemoteConnectDialog.mav$enableOk(RemoteConnectDialog.this);
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            RemoteConnectDialog.mav$enableOk(RemoteConnectDialog.this);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            RemoteConnectDialog.mav$enableOk(RemoteConnectDialog.this);
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            RemoteConnectDialog.mav$enableOk(RemoteConnectDialog.this);
        }

        Listener() {
        }
    }
}

