/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.runner;

import java.net.URL;
import oracle.ide.model.Project;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.runner.RunConfigurations;
import oracle.jdeveloper.runner.RunMgrArb;

public class RunConfiguration
extends HashStructureAdapter
implements PropertyStorage {
    public static final String NAME = "name";
    public static final String CUSTOM = "custom";
    public static final String RUN_DIRECTORY_URL = "runDirectoryURL";
    public static final String VM_NAME = "VMName";
    public static final String JAVA_OPTIONS = "javaOptions";
    public static final String TARGET_URL = "targetURL";
    public static final String RUN_ACTIVE_FILE = "runActiveFile";
    public static final String PROGRAM_ARGUMENTS = "programArguments";
    public static final String REMOTE_DEBUGGING_PROFILING = "remoteDebuggingProfiling";
    public static final String CONNECTION_NAME = "connectionName";
    public static final String COMPILE_BEFORE_RUN = "compileBeforeRun";
    public static final String IGNORE_COMPILER_ERRORS = "ignoreCompilerErrors";
    public static final String CLEAR_LOG_BEFORE_RUN = "clearLogBeforeRun";
    public static final String LOG_COMMAND = "logCommand";
    public static final String LOG_OUTPUT = "logOutput";
    public static final String LOG_ERROR = "logError";
    public static final String ALLOW_INPUT = "allowInput";
    public static final String LOG_EXIT = "logExit";
    public static final String USE_PROXY = "useProxy";

    public RunConfiguration(HashStructure hashStructure) {
        super(hashStructure);
    }

    public RunConfiguration() {
        super(HashStructure.newInstance());
    }

    public RunConfiguration(RunConfiguration runConfiguration, String string, boolean bl) {
        super(HashStructure.newInstance());
        if (runConfiguration != null) {
            runConfiguration.getProperties().copyTo(this._hash);
        }
        this.setName(string);
        this.setCustom(bl);
    }

    public static RunConfiguration getInstance(PropertyStorage propertyStorage) {
        if (propertyStorage instanceof Project) {
            return RunConfigurations.getActiveRunConfiguration((Project)propertyStorage);
        }
        return null;
    }

    public static RunConfiguration getRunConfiguration(Project project, String string) {
        return RunConfiguration.getInstance((PropertyStorage)project);
    }

    public static String getDefaultName() {
        return RunMgrArb.getString(0);
    }

    public String toString() {
        return this.getName();
    }

    public HashStructure getProperties() {
        return this._hash;
    }

    public void restoreDefaults() {
        String string = this.getName();
        boolean bl = this.isCustom();
        this._hash.clear();
        this.setName(string);
        this.setCustom(bl);
    }

    public String getName() {
        return this._hash.getString(NAME, "");
    }

    public void setName(String string) {
        if (string == null) {
            string = "";
        }
        this._hash.putString(NAME, string);
    }

    public boolean isCustom() {
        return this._hash.getBoolean(CUSTOM, false);
    }

    public void setCustom(boolean bl) {
        this._hash.putBoolean(CUSTOM, bl);
    }

    public URL getRunDirectoryURL() {
        return this._hash.getURL(RUN_DIRECTORY_URL, null);
    }

    public void setRunDirectoryURL(URL uRL) {
        if (uRL == null || uRL.getProtocol().equals("file")) {
            this._hash.putURL(RUN_DIRECTORY_URL, uRL);
        }
    }

    private String getVMName() {
        return this._hash.getString(VM_NAME, "ojvm");
    }

    public void setVMName(String string) {
        this._hash.putString(VM_NAME, string);
    }

    public String getJavaOptions() {
        return this._hash.getString(JAVA_OPTIONS, "");
    }

    public void setJavaOptions(String string) {
        if (string == null) {
            string = "";
        }
        this._hash.putString(JAVA_OPTIONS, string);
    }

    public URL getTargetURL() {
        return this._hash.getURL(TARGET_URL, null);
    }

    public void setTargetURL(URL uRL) {
        this._hash.putURL(TARGET_URL, uRL);
    }

    public boolean isRunActiveFile() {
        return this._hash.getBoolean(RUN_ACTIVE_FILE, true);
    }

    public void setRunActiveFile(boolean bl) {
        this._hash.putBoolean(RUN_ACTIVE_FILE, bl);
    }

    public String getProgramArguments() {
        return this._hash.getString(PROGRAM_ARGUMENTS, "");
    }

    public void setProgramArguments(String string) {
        if (string == null) {
            string = "";
        }
        this._hash.putString(PROGRAM_ARGUMENTS, string);
    }

    public boolean isRemoteDebuggingProfiling() {
        return this._hash.getBoolean(REMOTE_DEBUGGING_PROFILING, false);
    }

    public void setRemoteDebuggingProfiling(boolean bl) {
        this._hash.putBoolean(REMOTE_DEBUGGING_PROFILING, bl);
    }

    public String getConnectionName() {
        return this._hash.getString(CONNECTION_NAME, null);
    }

    public void setConnectionName(String string) {
        this._hash.putString(CONNECTION_NAME, string);
    }

    public boolean isCompileBeforeRun() {
        return this._hash.getBoolean(COMPILE_BEFORE_RUN, true);
    }

    public void setCompileBeforeRun(boolean bl) {
        this._hash.putBoolean(COMPILE_BEFORE_RUN, bl);
    }

    public boolean isIgnoreCompilerErrors() {
        return this._hash.getBoolean(IGNORE_COMPILER_ERRORS, false);
    }

    public void setIgnoreCompilerErrors(boolean bl) {
        this._hash.putBoolean(IGNORE_COMPILER_ERRORS, bl);
    }

    public boolean isClearLogBeforeRun() {
        return this._hash.getBoolean(CLEAR_LOG_BEFORE_RUN, true);
    }

    public void setClearLogBeforeRun(boolean bl) {
        this._hash.putBoolean(CLEAR_LOG_BEFORE_RUN, bl);
    }

    public boolean isLogCommand() {
        return this._hash.getBoolean(LOG_COMMAND, true);
    }

    public void setLogCommand(boolean bl) {
        this._hash.putBoolean(LOG_COMMAND, bl);
    }

    public boolean isLogOutput() {
        return this._hash.getBoolean(LOG_OUTPUT, true);
    }

    public void setLogOutput(boolean bl) {
        this._hash.putBoolean(LOG_OUTPUT, bl);
    }

    public boolean isLogError() {
        return this._hash.getBoolean(LOG_ERROR, true);
    }

    public void setLogError(boolean bl) {
        this._hash.putBoolean(LOG_ERROR, bl);
    }

    public boolean isAllowInput() {
        return this._hash.getBoolean(ALLOW_INPUT, false);
    }

    public void setAllowInput(boolean bl) {
        this._hash.putBoolean(ALLOW_INPUT, bl);
    }

    public boolean isLogExit() {
        return this._hash.getBoolean(LOG_EXIT, true);
    }

    public void setLogExit(boolean bl) {
        this._hash.putBoolean(LOG_EXIT, bl);
    }

    public boolean isUseProxy() {
        return this._hash.getBoolean(USE_PROXY, true);
    }

    public void setUseProxy(boolean bl) {
        this._hash.putBoolean(USE_PROXY, bl);
    }

    public String getVMName(JDK jDK) {
        return this.getVMName(jDK, null);
    }

    public String getVMName(JDK jDK, Project project) {
        String string = this.getVMName();
        if (jDK != null) {
            int n;
            boolean bl = false;
            String string2 = null;
            String[] stringArray = jDK.getInstalledVMs();
            if (stringArray != null && (n = stringArray.length) > 0) {
                string2 = stringArray[0];
                if (string != null) {
                    int n2 = 0;
                    while (n2 < n) {
                        if (string.equals(stringArray[n2])) {
                            bl = true;
                            break;
                        }
                        ++n2;
                    }
                }
            }
            if (!bl) {
                if (project != null) {
                    this.setVMName(string2);
                    project.markDirty(true);
                }
                return string2;
            }
        }
        return string;
    }

    public boolean usingOJVM(JDK jDK) {
        String string = this.getVMName(jDK, null);
        return string != null && string.startsWith("ojvm");
    }

    public boolean usingMinimal(JDK jDK) {
        String string = this.getVMName(jDK, null);
        return string != null && string.equals("minimal");
    }

    public boolean usingVanilla(JDK jDK) {
        String string = this.getVMName(jDK, null);
        return string != null && string.equals("vanilla");
    }

    public boolean usingClassic(JDK jDK) {
        String string = this.getVMName(jDK, null);
        return string != null && string.equals("classic");
    }
}

