/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.runner;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import oracle.ide.model.Project;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.runner.RunConfiguration;
import oracle.jdeveloper.runner.RunMgrArb;
import oracle.jdevimpl.runner.xslt.XSLTConfiguration;

public class RunConfigurations
extends HashStructureAdapter {
    public static final String DATA_KEY = RunConfigurations.class.getName();
    public static final String RUN_CONFIGURATION_DEFINITIONS = "runConfigurationDefinitions";
    public static final String RUN_CONFIGURATION_LIST = "runConfigurationList";
    private static final String ACTIVE_NAME = "activeName";

    public RunConfigurations(HashStructure hashStructure) {
        super(hashStructure);
    }

    private static HashStructure getRunConfigurationsProperties(PropertyStorage propertyStorage) {
        return RunConfigurations.findOrCreate((PropertyStorage)propertyStorage, (String)DATA_KEY);
    }

    public static RunConfigurations getInstance(PropertyStorage propertyStorage) {
        return new RunConfigurations(RunConfigurations.getRunConfigurationsProperties(propertyStorage));
    }

    public static void projectCreated(Project project) {
        RunConfigurations.migrate(project, true);
    }

    public static void projectMigrating(Project project) {
        RunConfigurations.migrate(project, true);
    }

    public static void projectCheck(Project project) {
        project.getProperties().applyBatchChanges((Runnable)new 1(project));
    }

    private static void migrate(Project project, boolean bl) {
        HashStructure hashStructure;
        HashStructure hashStructure2 = hashStructure = bl ? project.getSharedPropertiesOnly() : project.getUserPropertiesOnly();
        if (!hashStructure.containsKey(DATA_KEY)) {
            String string = RunConfiguration.class.getName();
            HashStructure hashStructure3 = hashStructure.getHashStructure(string);
            if (hashStructure3 != null) {
                hashStructure.remove(string);
            } else if (bl) {
                hashStructure3 = HashStructure.newInstance();
            }
            String string2 = XSLTConfiguration.class.getName();
            HashStructure hashStructure4 = hashStructure.getHashStructure(string2);
            if (hashStructure4 != null) {
                hashStructure.remove(string2);
                if (hashStructure3 != null) {
                    hashStructure3.putHashStructure(XSLTConfiguration.DATA_KEY, hashStructure4);
                }
            }
            if (hashStructure3 != null) {
                RunConfiguration runConfiguration = new RunConfiguration(hashStructure3);
                String string3 = bl ? RunMgrArb.getString(0) : RunMgrArb.getString(1);
                runConfiguration.setName(string3);
                runConfiguration.setCustom(bl ^ true);
                RunConfigurations.addRunConfiguration(project, runConfiguration);
            }
        }
    }

    public static void addRunConfiguration(Project project, RunConfiguration runConfiguration) {
        boolean bl = runConfiguration.isCustom();
        String string = runConfiguration.getName();
        HashStructure hashStructure = runConfiguration.getProperties();
        HashStructure hashStructure2 = bl ? project.getUserPropertiesOnly() : project.getSharedPropertiesOnly();
        HashStructure hashStructure3 = hashStructure2.getOrCreateHashStructure(DATA_KEY);
        HashStructure hashStructure4 = hashStructure3.getOrCreateHashStructure(RUN_CONFIGURATION_DEFINITIONS);
        hashStructure4.putHashStructure(string, hashStructure);
        ListStructure listStructure = hashStructure3.getOrCreateListStructure(RUN_CONFIGURATION_LIST);
        listStructure.add((Object)string);
    }

    private HashStructure getRunConfigurationDefinitions() {
        return this._hash.getOrCreateHashStructure(RUN_CONFIGURATION_DEFINITIONS);
    }

    private ListStructure getRunConfigurationList() {
        return this._hash.getOrCreateListStructure(RUN_CONFIGURATION_LIST);
    }

    public static String getActiveName(Project project) {
        HashStructure hashStructure = project.getUserPropertiesOnly();
        HashStructure hashStructure2 = hashStructure.getOrCreateHashStructure(DATA_KEY);
        String string = hashStructure2.getString(ACTIVE_NAME);
        RunConfigurations runConfigurations = RunConfigurations.getInstance((PropertyStorage)project);
        ListStructure listStructure = runConfigurations.getRunConfigurationList();
        HashStructure hashStructure3 = runConfigurations.getRunConfigurationDefinitions();
        if (string == null || !listStructure.contains((Object)string) || !hashStructure3.containsKey(string)) {
            string = RunMgrArb.getString(1);
        }
        if (string == null || !listStructure.contains((Object)string) || !hashStructure3.containsKey(string)) {
            string = RunMgrArb.getString(0);
        }
        if (string == null || !listStructure.contains((Object)string) || !hashStructure3.containsKey(string)) {
            int n = listStructure.size();
            int n2 = 0;
            while (n2 < n) {
                String string2 = (String)listStructure.get(n2);
                if (hashStructure3.containsKey(string2)) {
                    string = string2;
                    hashStructure2.putString(ACTIVE_NAME, string);
                    break;
                }
                ++n2;
            }
        }
        return string;
    }

    private static void setActiveName(Project project, String string) {
        HashStructure hashStructure = project.getUserPropertiesOnly();
        HashStructure hashStructure2 = hashStructure.getOrCreateHashStructure(DATA_KEY);
        hashStructure2.putString(ACTIVE_NAME, string);
    }

    public Map getDefinedRunConfigurations() {
        HashMap<String, RunConfiguration> hashMap = new HashMap<String, RunConfiguration>();
        HashStructure hashStructure = this.getRunConfigurationDefinitions();
        for (String string : hashStructure.keySet()) {
            HashStructure hashStructure2 = hashStructure.getHashStructure(string);
            RunConfiguration runConfiguration = new RunConfiguration(hashStructure2);
            hashMap.put(string, runConfiguration);
        }
        return hashMap;
    }

    public RunConfiguration[] getVisibleRunConfigurations() {
        ArrayList<RunConfiguration> arrayList = new ArrayList<RunConfiguration>();
        ListStructure listStructure = this.getRunConfigurationList();
        arrayList.addAll((Collection<RunConfiguration>)listStructure);
        HashStructure hashStructure = this.getRunConfigurationDefinitions();
        int n = arrayList.size() - 1;
        while (n >= 0) {
            String string = (String)arrayList.get(n);
            HashStructure hashStructure2 = hashStructure.getHashStructure(string);
            if (hashStructure2 != null) {
                RunConfiguration runConfiguration = new RunConfiguration(hashStructure2);
                arrayList.set(n, runConfiguration);
            } else {
                arrayList.remove(n);
                listStructure.remove(n);
            }
            --n;
        }
        return arrayList.toArray(new RunConfiguration[arrayList.size()]);
    }

    public void setRunConfigurations(RunConfiguration[] runConfigurationArray, boolean bl) {
        HashStructure hashStructure = this.getRunConfigurationDefinitions();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = runConfigurationArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = runConfigurationArray[n2].getName();
            arrayList.add(string);
            if (!hashStructure.containsKey(string)) {
                hashStructure.putHashStructure(string, runConfigurationArray[n2].getProperties());
            }
            ++n2;
        }
        Collections.sort(arrayList);
        ListStructure listStructure = this.getRunConfigurationList();
        listStructure.mirror(arrayList);
        String[] stringArray = hashStructure.keySet().toArray(new String[hashStructure.size()]);
        int n3 = stringArray.length - 1;
        while (n3 >= 0) {
            String string = stringArray[n3];
            HashStructure hashStructure2 = hashStructure.getHashStructure(string);
            RunConfiguration runConfiguration = new RunConfiguration(hashStructure2);
            if (runConfiguration.isCustom() == bl && !arrayList.contains(string)) {
                hashStructure.remove(string);
            }
            --n3;
        }
    }

    public static boolean isActiveRunConfiguration(Project project, RunConfiguration runConfiguration) {
        return RunConfigurations.getActiveName(project).equals(runConfiguration.getName());
    }

    public static void setActiveRunConfiguration(Project project, RunConfiguration runConfiguration) {
        RunConfigurations.setActiveName(project, runConfiguration.getName());
    }

    private static RunConfiguration getRunConfigurationByName(Project project, String string, boolean bl) {
        RunConfigurations runConfigurations = RunConfigurations.getInstance((PropertyStorage)project);
        HashStructure hashStructure = runConfigurations.getRunConfigurationDefinitions();
        HashStructure hashStructure2 = hashStructure.getHashStructure(string);
        if (hashStructure2 == null) {
            if (bl) {
                hashStructure2 = HashStructure.newInstance();
            } else {
                return null;
            }
        }
        RunConfiguration runConfiguration = new RunConfiguration(hashStructure2);
        return runConfiguration;
    }

    public static RunConfiguration getRunConfigurationByName(Project project, String string) {
        return RunConfigurations.getRunConfigurationByName(project, string, false);
    }

    public static RunConfiguration getActiveRunConfiguration(Project project) {
        String string = RunConfigurations.getActiveName(project);
        return RunConfigurations.getRunConfigurationByName(project, string, true);
    }

    static void maS$migrate(Project project, boolean bl) {
        RunConfigurations.migrate(project, bl);
    }

    public static final class 1
    implements Runnable {
        private final /* synthetic */ Project v$project;

        public void run() {
            RunConfigurations.maS$migrate(this.v$project, true);
            RunConfigurations.maS$migrate(this.v$project, false);
        }

        public 1(Project project) {
            this.v$project = project;
        }
    }
}

