/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.runner;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.CodeEditorGutter;
import oracle.ide.ceditor.LineNavigationPoint;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.navigation.NavigationManager;
import oracle.ide.navigation.NavigationPoint;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.ResourceUtils;
import oracle.ide.view.View;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.model.PackagedSource;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.runner.RunMgrArb;
import oracle.jdeveloper.runner.SourceFinder;
import oracle.jdeveloper.runner.SourceFinderManager;
import oracle.jdevimpl.uieditor.UIEditorImpl;

public final class Source {
    private static ArrayList _sourceFinderList = new ArrayList(2);
    private static ArrayList _sourceFinderManagerList = new ArrayList(2);
    private static final int DO_NOTHING = 0;
    private static final int LOOK_IN_PROJECT = 1;
    private static final int LOOK_IN_SOURCE_FINDER = 2;
    private static final int URL_CHOOSER = 3;
    private static final int GENERATE_STUB = 4;
    private static final int DONT_ASK = 5;
    private static List dontAsk = null;

    private Source() {
    }

    public static boolean showSourceFile(Workspace workspace, Project project, String string, String string2, String string3, int n, boolean bl) {
        return Source.showSourceFile(workspace, project, string, string2, string3, n, bl, null);
    }

    public static boolean showSourceFile(Workspace workspace, Project project, String string, String string2, String string3, int n, boolean bl, String string4) {
        try {
            Node node;
            URL uRL = Source.findSourceFile(workspace, project, string, string3);
            if (uRL != null && (node = NodeFactory.findOrCreate((URL)uRL)) != null && Source.showSourceFile(workspace, project, node, n, bl)) {
                boolean bl2 = true;
                return bl2;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (string2 != null) {
            try {
                Node node;
                URL uRL = Source.findURLForClassSource(workspace, project, string2);
                if (uRL != null && (node = NodeFactory.findOrCreate((URL)uRL)) != null && string3.equals(Source.getFilenameFromNode(node)) && Source.packageMatches(string, node, project) && Source.showSourceFile(workspace, project, node, n, bl)) {
                    boolean bl3 = true;
                    return bl3;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            try {
                Node node;
                URL uRL = Source.findOpenSourceStub(workspace, project, string2);
                if (uRL != null && (node = NodeFactory.findOrCreate((URL)uRL)) != null && Source.showSourceFile(workspace, project, node, 0, false)) {
                    boolean bl4 = true;
                    return bl4;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return Source.showSourceNotFoundDialog(workspace, project, string, string3, string2, n, bl, string4);
    }

    public static boolean showSourceFile(Workspace workspace, Project project, URL uRL, int n, boolean bl) {
        try {
            Node node = NodeFactory.findOrCreate((URL)uRL);
            if (node != null) {
                boolean bl2 = Source.showSourceFile(workspace, project, node, n, bl);
                return bl2;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    public static boolean showSourceFile(Workspace workspace, Project project, Node node, int n, boolean bl) {
        Context context = Source.createContext(workspace, project, node);
        if (context != null) {
            try {
                NavigationManager navigationManager = NavigationManager.getNavigationManager();
                LineNavigationPoint lineNavigationPoint = new LineNavigationPoint(context, n, 0, bl);
                if (navigationManager != null) {
                    if (navigationManager.navigateTo((NavigationPoint)lineNavigationPoint) != 0) {
                        boolean bl2 = false;
                        return bl2;
                    }
                } else if (lineNavigationPoint.navigate() != 0) {
                    boolean bl3 = false;
                    return bl3;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    public static CodeEditor showNodeInCodeEditor(Workspace workspace, Project project, Node node) {
        try {
            Context context = Source.createContext(workspace, project, node);
            CodeEditor codeEditor = (CodeEditor)EditorManager.getEditorManager().openEditorInFrame(CodeEditor.class, context);
            return codeEditor;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static Editor showNodeInDefaultEditor(Workspace workspace, Project project, Node node) {
        try {
            Context context = Source.createContext(workspace, project, node);
            Editor editor = EditorManager.getEditorManager().openDefaultEditorInFrame(context);
            return editor;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static Context createContext(Workspace workspace, Project project, Node node) {
        try {
            Context context = Context.newIdeContext((Node)node);
            if (workspace != null && workspace != Ide.getDefaultWorkspace()) {
                context.setWorkspace(workspace);
            }
            if (project != null && project != Ide.getDefaultProject()) {
                context.setProject(project);
            }
            Context context2 = context;
            return context2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static void addSourceFinder(SourceFinder sourceFinder) {
        _sourceFinderList.add(sourceFinder);
    }

    public static void removeSourceFinder(SourceFinder sourceFinder) {
        _sourceFinderList.remove(sourceFinder);
    }

    public static void addSourceFinderManager(SourceFinderManager sourceFinderManager) {
        _sourceFinderManagerList.add(sourceFinderManager);
    }

    public static void removeSourceFinderManager(SourceFinderManager sourceFinderManager) {
        _sourceFinderManagerList.remove(sourceFinderManager);
    }

    public static boolean showUIDesigner(Workspace workspace, Project project, URL uRL) {
        try {
            Node node = NodeFactory.findOrCreate((URL)uRL);
            if (node != null) {
                boolean bl = Source.showUIDesigner(workspace, project, node);
                return bl;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    public static boolean showUIDesigner(Workspace workspace, Project project, Node node) {
        try {
            UIEditorImpl uIEditorImpl;
            Context context = Context.newIdeContext((Node)node);
            if (workspace != null && workspace != Ide.getDefaultWorkspace()) {
                context.setWorkspace(workspace);
            }
            if (project != null && project != Ide.getDefaultProject()) {
                context.setProject(project);
            }
            if ((uIEditorImpl = (UIEditorImpl)EditorManager.getEditorManager().openEditorInFrame(UIEditorImpl.class, context)) != null) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    public static URL findSourceFile(Workspace workspace, Project project, String string, String string2) {
        Node[] nodeArray = Source.getOpenedFiles(workspace, project);
        URL uRL = Source.lookForFile(string, string2, project, nodeArray);
        if (uRL != null) {
            return uRL;
        }
        if (project != null) {
            int n = string2.lastIndexOf(46);
            String string3 = n == -1 ? string2 : string2.substring(0, n);
            if (string != null && string.length() > 0) {
                string3 = string + '.' + string3;
            }
            if ((uRL = Source.findURLForClassSource(workspace, project, string3)) != null) {
                try {
                    Node node = NodeFactory.findOrCreate((URL)uRL);
                    if (node != null && string2.equals(Source.getFilenameFromNode(node)) && Source.packageMatches(string, node, project)) {
                        URL uRL2 = uRL;
                        return uRL2;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return Source.askSourceFinders(workspace, project, string, string2);
    }

    public static URL askSourceFinders(Workspace workspace, Project project, String string, String string2) {
        URL uRL = null;
        Iterator iterator = _sourceFinderList.iterator();
        while (uRL == null && iterator.hasNext()) {
            SourceFinder sourceFinder = (SourceFinder)iterator.next();
            uRL = sourceFinder.findSourceFile(workspace, project, string, string2);
        }
        return uRL;
    }

    public static URL findURLForClass(Workspace workspace, Project project, String string) {
        return Source.findURLForClassSource(workspace, project, string);
    }

    public static URL findURLForClassSource(Workspace workspace, Project project, String string) {
        URL uRL = Source.findURLForClassSource(project, string);
        if (uRL != null) {
            return uRL;
        }
        if (workspace != null) {
            HashSet hashSet = Util.getDependentProjects(workspace, project);
            for (Project project2 : hashSet) {
                if (project2 == project || (uRL = Source.findURLForClassSource(project2, string)) == null) continue;
                return uRL;
            }
        }
        return null;
    }

    public static URL findURLForClassSource(Project project, String string) {
        JavaManager javaManager = JavaManager.getJavaManager(project);
        SourceClass sourceClass = javaManager.getSourceClass(string);
        if (sourceClass != null) {
            return sourceClass.getURL();
        }
        return null;
    }

    public static URL findURLForClassStub(Workspace workspace, Project project, String string) {
        URL uRL = Source.findURLForClassStub(project, string);
        if (uRL != null) {
            return uRL;
        }
        if (workspace != null) {
            HashSet hashSet = Util.getDependentProjects(workspace, project);
            for (Project project2 : hashSet) {
                if (project2 == project || (uRL = Source.findURLForClassStub(project2, string)) == null) continue;
                return uRL;
            }
        }
        return null;
    }

    public static URL findURLForClassStub(Project project, String string) {
        JavaManager javaManager = JavaManager.getJavaManager(project);
        JavaClass javaClass = javaManager.getClass(string);
        if (javaClass != null) {
            return javaClass.getURL();
        }
        return null;
    }

    public static URL findOpenSourceStub(Workspace workspace, Project project, String string) {
        URL uRL = Source.findURLForClassStub(workspace, project, string);
        if (uRL != null) {
            Node[] nodeArray = Source.getOpenedFiles(workspace, project);
            int n = nodeArray.length - 1;
            while (n >= 0) {
                if (uRL.equals(nodeArray[n].getURL())) {
                    return uRL;
                }
                --n;
            }
        }
        return null;
    }

    public static Node[] getProjectFileList(Project project) {
        ArrayList arrayList = new ArrayList();
        if (project != null) {
            Source.recurseFileList((Node)project, arrayList);
        }
        return arrayList.toArray(new Node[arrayList.size()]);
    }

    private static void recurseFileList(Node node, ArrayList arrayList) {
        Iterator iterator = node.getChildren();
        if (iterator != null) {
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof Node)) continue;
                Node node2 = (Node)e;
                if (node2.mayHaveChildren()) {
                    Source.recurseFileList(node2, arrayList);
                    continue;
                }
                arrayList.add(node2);
            }
        }
    }

    private static URL lookForFile(String string, String string2, Project project, Node[] nodeArray) {
        int n = nodeArray.length - 1;
        while (n >= 0) {
            Node node = nodeArray[n];
            if (string2.equals(Source.getFilenameFromNode(node)) && Source.packageMatches(string, node, project)) {
                return node.getURL();
            }
            --n;
        }
        return null;
    }

    public static Node[] getOpenedFiles() {
        if (!SwingUtilities.isEventDispatchThread()) {
            return new Node[0];
        }
        ArrayList<Node> arrayList = new ArrayList<Node>();
        List list = EditorManager.getEditorManager().getAllEditors();
        int n = list.size() - 1;
        while (n >= 0) {
            Node node;
            CodeEditor codeEditor;
            Context context;
            Object e = list.get(n);
            if (e instanceof CodeEditor && (context = (codeEditor = (CodeEditor)e).getContext()) != null && (node = context.getNode()) != null) {
                arrayList.add(node);
            }
            --n;
        }
        return arrayList.toArray(new Node[arrayList.size()]);
    }

    public static Node[] getOpenedFiles(Workspace workspace, Project project) {
        if (!SwingUtilities.isEventDispatchThread()) {
            return new Node[0];
        }
        ArrayList<Node> arrayList = new ArrayList<Node>();
        URL uRL = workspace != null ? workspace.getURL() : null;
        URL uRL2 = project != null ? project.getURL() : null;
        List list = EditorManager.getEditorManager().getAllEditors();
        int n = list.size() - 1;
        while (n >= 0) {
            CodeEditor codeEditor;
            Context context;
            Object e = list.get(n);
            if (e instanceof CodeEditor && (context = (codeEditor = (CodeEditor)e).getContext()) != null) {
                URL uRL3;
                Workspace workspace2 = context.getWorkspace();
                URL uRL4 = uRL3 = workspace2 != null ? workspace2.getURL() : null;
                if (uRL == null || uRL3 == null || URLFileSystem.equals((URL)uRL, (URL)uRL3)) {
                    Node node;
                    URL uRL5;
                    Project project2 = context.getProject();
                    URL uRL6 = uRL5 = project2 != null ? project2.getURL() : null;
                    if ((uRL2 == null || uRL5 == null || URLFileSystem.equals((URL)uRL2, (URL)uRL5)) && (node = context.getNode()) != null) {
                        arrayList.add(node);
                    }
                }
            }
            --n;
        }
        return arrayList.toArray(new Node[arrayList.size()]);
    }

    public static String getFilenameFromNode(Node node) {
        if (node instanceof PackagedSource) {
            String string = ((PackagedSource)node).getSourceFile();
            return string != null ? string : "";
        }
        return URLFileSystem.getFileName((URL)node.getURL());
    }

    public static String getPackageFromNode(Node node, Project project) {
        if (node instanceof PackagedSource) {
            try {
                String string = ((PackagedSource)node).getPackage(project);
                String string2 = string != null ? string : "";
                return string2;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "";
    }

    public static boolean packageMatches(String string, Node node, Project project) {
        String string2 = Source.getPackageFromNode(node, project);
        return Source.packageMatches(string, string2);
    }

    public static boolean packageMatches(String string, String string2) {
        if (string.equals(string2)) {
            return true;
        }
        if (string2 != null && string2.length() > 0 && string2.charAt(0) == '*' && string.endsWith(string2.substring(1))) {
            return true;
        }
        return string.length() > 0 && string.charAt(0) == '*' && string2.endsWith(string.substring(1));
    }

    public static CodeEditor getCodeEditorFromContext(Context context) {
        if (context != null) {
            View view = context.getView();
            if (view instanceof CodeEditor) {
                return (CodeEditor)view;
            }
            if (view instanceof CodeEditorGutter.GutterView) {
                return (CodeEditor)view.owner();
            }
        }
        return null;
    }

    public static Node getNodeFromCodeEditor(Context context) {
        CodeEditor codeEditor = Source.getCodeEditorFromContext(context);
        if (codeEditor != null) {
            return context.getNode();
        }
        return null;
    }

    public static int getLineFromCodeEditor(Context context) {
        View view;
        if (context != null && (view = context.getView()) != null && view instanceof CodeEditorGutter.GutterView) {
            int n = CodeEditorGutter.getLineForContext((Context)context);
            if (n != -1) {
                return n;
            }
            return 0;
        }
        CodeEditor codeEditor = Source.getCodeEditorFromContext(context);
        if (codeEditor != null) {
            return codeEditor.getCaretLine();
        }
        return 0;
    }

    private static boolean showSourceNotFoundDialog(Workspace workspace, Project project, String string, String string2, String string3, int n, boolean bl, String string4) {
        if (Source.getShouldAsk(string, string2)) {
            String string5 = RunMgrArb.getString(9);
            ArrayList<Project> arrayList = new ArrayList<Project>();
            if (project != null) {
                arrayList.add(project);
            }
            boolean bl2 = Source.canGenerateStub(workspace, project, string3, string2);
            block7: while (true) {
                SourceNotFoundPanel sourceNotFoundPanel = new SourceNotFoundPanel(workspace, project, string, string2, string3, string4, arrayList, bl2);
                JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)sourceNotFoundPanel, (Component)SourceNotFoundPanel.mav$getFirstComponent(sourceNotFoundPanel), (String)string5);
                SourceNotFoundPanel.mav$setJEWTDialog(sourceNotFoundPanel, jEWTDialog);
                jEWTDialog.setOKButtonEnabled(SourceNotFoundPanel.mav$canOk(sourceNotFoundPanel));
                HelpSystem.getHelpSystem().registerTopic((JComponent)sourceNotFoundPanel, "f1_run_sourcenotfound_html");
                if (!WizardLauncher.runDialog((JDialog)jEWTDialog)) break;
                switch (SourceNotFoundPanel.mav$getChoice(sourceNotFoundPanel)) {
                    case 1: {
                        Project project2 = sourceNotFoundPanel.getSelectedProject();
                        if (Source.lookInOtherProject(project2, workspace, project, string, string2, n, bl)) {
                            return true;
                        }
                        arrayList.add(project2);
                        break;
                    }
                    case 2: {
                        SourceFinder sourceFinder = sourceNotFoundPanel.getSelectedSourceFinder();
                        if (!Source.lookInSourceFinder(sourceFinder, workspace, project, string, string2, n, bl)) continue block7;
                        return true;
                    }
                    case 3: {
                        if (!Source.showURLChooser(workspace, project, string, string2, n, bl)) continue block7;
                        return true;
                    }
                    case 4: {
                        if (!Source.generateStub(workspace, project, string3)) continue block7;
                        return true;
                    }
                    case 5: {
                        Source.setShouldAsk(string, string2, false);
                        return false;
                    }
                }
            }
            return false;
        }
        return false;
    }

    private static boolean getShouldAsk(String string, String string2) {
        String string3;
        return dontAsk == null || !dontAsk.contains(string3 = string + "." + string2);
    }

    private static void setShouldAsk(String string, String string2, boolean bl) {
        if (dontAsk == null) {
            dontAsk = new ArrayList();
        }
        String string3 = string + "." + string2;
        if (bl) {
            dontAsk.remove(string3);
        } else {
            dontAsk.add(string3);
        }
    }

    private static boolean lookInOtherProject(Project project, Workspace workspace, Project project2, String string, String string2, int n, boolean bl) {
        try {
            Node node;
            URL uRL = Source.findSourceFile(workspace, project, string, string2);
            if (uRL != null && (node = NodeFactory.findOrCreate((URL)uRL)) != null && Source.showSourceFile(workspace, project2, node, n, bl)) {
                boolean bl2 = true;
                return bl2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static boolean lookInSourceFinder(SourceFinder sourceFinder, Workspace workspace, Project project, String string, String string2, int n, boolean bl) {
        try {
            Node node;
            URL uRL = sourceFinder.findSourceFile(workspace, project, string, string2);
            if (uRL != null && (node = NodeFactory.findOrCreate((URL)uRL)) != null && Source.showSourceFile(workspace, project, node, n, bl)) {
                boolean bl2 = true;
                return bl2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static boolean showURLChooser(Workspace workspace, Project project, String string, String string2, int n, boolean bl) {
        URL uRL;
        String string3 = string.length() > 0 ? RunMgrArb.format(18, string, string2) : RunMgrArb.format(19, string2);
        Context context = Context.newIdeContext();
        if (workspace != null) {
            context.setWorkspace(workspace);
        }
        if (project != null) {
            context.setProject(project);
        }
        URLChooser uRLChooser = DialogUtil.newURLChooser((Context)context);
        uRLChooser.setSelectionMode(0);
        if (uRLChooser.showOpenDialog((Component)Ide.getMainWindow(), string3) == 0 && (uRL = uRLChooser.getSelectedURL()) != null) {
            try {
                Node node = NodeFactory.findOrCreate((URL)uRL);
                if (node != null && Source.showSourceFile(workspace, project, node, n, bl)) {
                    boolean bl2 = true;
                    return bl2;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private static boolean canGenerateStub(Workspace workspace, Project project, String string, String string2) {
        URL uRL;
        return project != null && string != null && string2 != null && string2.toUpperCase().endsWith(".JAVA") && (uRL = Source.findURLForClassStub(workspace, project, string)) != null;
    }

    private static boolean generateStub(Workspace workspace, Project project, String string) {
        URL uRL;
        return project != null && string != null && (uRL = Source.findURLForClassStub(workspace, project, string)) != null && Source.showSourceFile(workspace, project, uRL, 0, false);
    }

    static ArrayList ra$_sourceFinderManagerList() {
        return _sourceFinderManagerList;
    }

    private static final class SourceNotFoundPanel
    extends JPanel
    implements ItemListener {
        private JEWTDialog dlg;
        private JRadioButton radioProject;
        private JComboBox comboboxProjects;
        private List sourceFinderManagers;
        private List radioSourceFinders;
        private List comboboxSourceFinders;
        private JRadioButton radioURLChooser;
        private JRadioButton radioGenerateStub;
        private JRadioButton radioDontAskAgain;

        SourceNotFoundPanel(Workspace workspace, Project project, String string, String string2, String string3, String string4, List list, boolean bl) {
            super(new GridBagLayout());
            int n;
            JLabel jLabel = null;
            if (string4 != null) {
                jLabel = new JLabel(string4);
            }
            String string5 = string2.length() > 0 ? (string.length() > 0 ? RunMgrArb.format(10, string, string2) : RunMgrArb.format(11, string2)) : RunMgrArb.format(12, string3);
            JLabel jLabel2 = new JLabel(string5);
            int n2 = list.size();
            JLabel[] jLabelArray = new JLabel[n2];
            int n3 = 0;
            while (n3 < n2) {
                Project project2 = (Project)list.get(n3);
                jLabelArray[n3] = new JLabel(RunMgrArb.format(13, project2.getShortLabel()));
                ++n3;
            }
            Project[] projectArray = SourceNotFoundPanel.getOtherProjects(workspace, list);
            if (projectArray.length > 0) {
                this.radioProject = new JRadioButton();
                this.comboboxProjects = new JComboBox<Project>(projectArray);
            }
            if ((n = Source.ra$_sourceFinderManagerList().size()) > 0) {
                this.sourceFinderManagers = new ArrayList();
                this.radioSourceFinders = new ArrayList();
                this.comboboxSourceFinders = new ArrayList();
                int n4 = 0;
                while (n4 < n) {
                    SourceFinderManager sourceFinderManager = (SourceFinderManager)Source.ra$_sourceFinderManagerList().get(n4);
                    String[] stringArray = sourceFinderManager.getSourceFinderNames();
                    if (stringArray != null && stringArray.length > 0) {
                        JRadioButton jRadioButton = new JRadioButton();
                        ResourceUtils.resButton((AbstractButton)jRadioButton, (String)sourceFinderManager.getRadioLabel());
                        JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
                        this.sourceFinderManagers.add(sourceFinderManager);
                        this.radioSourceFinders.add(jRadioButton);
                        this.comboboxSourceFinders.add(jComboBox);
                    }
                    ++n4;
                }
                if (this.sourceFinderManagers.isEmpty()) {
                    this.sourceFinderManagers = null;
                    this.radioSourceFinders = null;
                    this.comboboxSourceFinders = null;
                }
            }
            this.radioURLChooser = new JRadioButton();
            if (bl) {
                this.radioGenerateStub = new JRadioButton();
            }
            this.radioDontAskAgain = new JRadioButton();
            ButtonGroup buttonGroup = new ButtonGroup();
            if (this.radioProject != null) {
                buttonGroup.add(this.radioProject);
            }
            if (this.radioSourceFinders != null) {
                int n5 = 0;
                while (n5 < this.radioSourceFinders.size()) {
                    buttonGroup.add((JRadioButton)this.radioSourceFinders.get(n5));
                    ++n5;
                }
            }
            buttonGroup.add(this.radioURLChooser);
            if (this.radioGenerateStub != null) {
                buttonGroup.add(this.radioGenerateStub);
            }
            buttonGroup.add(this.radioDontAskAgain);
            this.setResources();
            this.selectRadio(string2);
            int n6 = 0;
            if (jLabel != null) {
                this.add((Component)jLabel, new GridBagConstraints(0, n6++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 10, 5), 0, 0));
            }
            this.add((Component)jLabel2, new GridBagConstraints(0, n6++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 10, 5), 0, 0));
            int n7 = 0;
            while (n7 < jLabelArray.length) {
                this.add((Component)jLabelArray[n7], new GridBagConstraints(0, n6++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
                ++n7;
            }
            if (this.radioProject != null) {
                JPanel jPanel = new JPanel(new FlowLayout(0, 0, 0));
                jPanel.add(this.radioProject);
                jPanel.add(this.comboboxProjects);
                this.add((Component)jPanel, new GridBagConstraints(0, n6++, 0, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 5), 0, 0));
            }
            if (this.radioSourceFinders != null) {
                int n8 = 0;
                while (n8 < this.radioSourceFinders.size()) {
                    JRadioButton jRadioButton = (JRadioButton)this.radioSourceFinders.get(n8);
                    JComboBox jComboBox = (JComboBox)this.comboboxSourceFinders.get(n8);
                    JPanel jPanel = new JPanel(new FlowLayout(0, 0, 0));
                    jPanel.add(jRadioButton);
                    jPanel.add(jComboBox);
                    this.add((Component)jPanel, new GridBagConstraints(0, n6++, 0, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 5), 0, 0));
                    ++n8;
                }
            }
            this.add((Component)this.radioURLChooser, new GridBagConstraints(0, n6++, 0, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 5), 0, 0));
            if (this.radioGenerateStub != null) {
                this.add((Component)this.radioGenerateStub, new GridBagConstraints(0, n6++, 0, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 5), 0, 0));
            }
            this.add((Component)this.radioDontAskAgain, new GridBagConstraints(0, n6++, 0, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 5), 0, 0));
            this.add((Component)new JLabel(), new GridBagConstraints(0, n6, 0, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.addListeners();
        }

        private void setResources() {
            if (this.radioProject != null) {
                ResourceUtils.resButton((AbstractButton)this.radioProject, (String)RunMgrArb.getString(14));
            }
            ResourceUtils.resButton((AbstractButton)this.radioURLChooser, (String)RunMgrArb.getString(15));
            if (this.radioGenerateStub != null) {
                ResourceUtils.resButton((AbstractButton)this.radioGenerateStub, (String)RunMgrArb.getString(16));
            }
            ResourceUtils.resButton((AbstractButton)this.radioDontAskAgain, (String)RunMgrArb.getString(17));
        }

        private void selectRadio(String string) {
            if (this.radioSourceFinders != null && string.toUpperCase().endsWith(".PLS")) {
                ((JRadioButton)this.radioSourceFinders.get(0)).setSelected(true);
            } else if (this.radioProject != null) {
                this.radioProject.setSelected(true);
            } else {
                this.radioURLChooser.setSelected(true);
            }
        }

        private void addListeners() {
            if (this.radioProject != null) {
                this.radioProject.addItemListener(this);
                this.comboboxProjects.addItemListener(this);
                this.comboboxProjects.setEnabled(this.radioProject.isSelected());
            }
            if (this.radioSourceFinders != null) {
                int n = 0;
                while (n < this.radioSourceFinders.size()) {
                    JRadioButton jRadioButton = (JRadioButton)this.radioSourceFinders.get(n);
                    jRadioButton.addItemListener(this);
                    JComboBox jComboBox = (JComboBox)this.comboboxSourceFinders.get(n);
                    jComboBox.addItemListener(this);
                    jComboBox.setEnabled(jRadioButton.isSelected());
                    ++n;
                }
            }
            if (this.radioGenerateStub != null) {
                this.radioGenerateStub.addItemListener(this);
            }
            this.radioURLChooser.addItemListener(this);
        }

        private static Project[] getOtherProjects(Workspace workspace, List list) {
            ArrayList arrayList = new ArrayList();
            if (workspace != null) {
                Iterator iterator = workspace.getChildren();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (!(e instanceof Project) || list.contains(e)) continue;
                    arrayList.add(e);
                }
            }
            return arrayList.toArray(new Project[arrayList.size()]);
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            Object object = itemEvent.getSource();
            if (object instanceof JRadioButton) {
                if (this.radioProject != null) {
                    this.comboboxProjects.setEnabled(this.radioProject.isSelected());
                }
                if (this.radioSourceFinders != null) {
                    int n = 0;
                    while (n < this.radioSourceFinders.size()) {
                        JRadioButton jRadioButton = (JRadioButton)this.radioSourceFinders.get(n);
                        JComboBox jComboBox = (JComboBox)this.comboboxSourceFinders.get(n);
                        jComboBox.setEnabled(jRadioButton.isSelected());
                        ++n;
                    }
                }
                this.dlg.setOKButtonEnabled(this.canOk());
            } else if (object instanceof JComboBox) {
                this.dlg.setOKButtonEnabled(this.canOk());
            }
        }

        private void setJEWTDialog(JEWTDialog jEWTDialog) {
            this.dlg = jEWTDialog;
        }

        private boolean canOk() {
            if (this.radioProject != null && this.radioProject.isSelected() && this.getSelectedProject() == null) {
                return false;
            }
            if (this.radioSourceFinders != null) {
                int n = 0;
                while (n < this.radioSourceFinders.size()) {
                    JRadioButton jRadioButton = (JRadioButton)this.radioSourceFinders.get(n);
                    if (jRadioButton.isSelected() && this.getSelectedSourceFinder() == null) {
                        return false;
                    }
                    ++n;
                }
            }
            return true;
        }

        private Component getFirstComponent() {
            if (this.radioProject != null) {
                return this.radioProject;
            }
            if (this.radioSourceFinders != null) {
                return (JRadioButton)this.radioSourceFinders.get(0);
            }
            return this.radioURLChooser;
        }

        private int getChoice() {
            if (this.radioProject != null && this.radioProject.isSelected()) {
                return 1;
            }
            if (this.radioSourceFinders != null) {
                int n = 0;
                while (n < this.radioSourceFinders.size()) {
                    JRadioButton jRadioButton = (JRadioButton)this.radioSourceFinders.get(n);
                    if (jRadioButton.isSelected()) {
                        return 2;
                    }
                    ++n;
                }
            }
            if (this.radioGenerateStub != null && this.radioGenerateStub.isSelected()) {
                return 4;
            }
            if (this.radioURLChooser.isSelected()) {
                return 3;
            }
            if (this.radioDontAskAgain.isSelected()) {
                return 5;
            }
            return 0;
        }

        Project getSelectedProject() {
            if (this.radioProject != null && this.radioProject.isSelected()) {
                return (Project)this.comboboxProjects.getSelectedItem();
            }
            return null;
        }

        SourceFinder getSelectedSourceFinder() {
            if (this.radioSourceFinders != null) {
                int n = 0;
                while (n < this.radioSourceFinders.size()) {
                    JRadioButton jRadioButton = (JRadioButton)this.radioSourceFinders.get(n);
                    if (jRadioButton.isSelected()) {
                        SourceFinderManager sourceFinderManager = (SourceFinderManager)this.sourceFinderManagers.get(n);
                        JComboBox jComboBox = (JComboBox)this.comboboxSourceFinders.get(n);
                        String string = (String)jComboBox.getSelectedItem();
                        return sourceFinderManager.getSourceFinder(string);
                    }
                    ++n;
                }
            }
            return null;
        }

        static Component mav$getFirstComponent(SourceNotFoundPanel sourceNotFoundPanel) {
            return sourceNotFoundPanel.getFirstComponent();
        }

        static void mav$setJEWTDialog(SourceNotFoundPanel sourceNotFoundPanel, JEWTDialog jEWTDialog) {
            sourceNotFoundPanel.setJEWTDialog(jEWTDialog);
        }

        static boolean mav$canOk(SourceNotFoundPanel sourceNotFoundPanel) {
            return sourceNotFoundPanel.canOk();
        }

        static int mav$getChoice(SourceNotFoundPanel sourceNotFoundPanel) {
            return sourceNotFoundPanel.getChoice();
        }
    }
}

