/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.runner.xslt;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import oracle.bali.xml.addin.XMLSourceNode;
import oracle.ide.model.Project;
import oracle.ide.net.FilePath;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.IdeUtil;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.runner.JRunProcess;
import oracle.jdeveloper.runner.JStarter;
import oracle.jdevimpl.runner.xslt.XSLTConfiguration;
import oracle.jdevimpl.runner.xslt.XSLTPanel;
import oracle.jdevimpl.runner.xslt.XSLTRunnerAddin;

public class XSLTStarter
extends JStarter {
    private XMLSourceNode target;
    private XSLTConfiguration xsltConfiguration;

    public XSLTStarter(JRunProcess jRunProcess, XMLSourceNode xMLSourceNode) {
        super(jRunProcess, null);
        this.jrunProcess = jRunProcess;
        this.target = xMLSourceNode;
        Project project = jRunProcess.getJProject();
        this.xsltConfiguration = XSLTConfiguration.getInstance((PropertyStorage)project);
    }

    public boolean start() {
        if (this.needToShowXSLTSettingsDialog() && !this.showXSLTSettingsDialog()) {
            return false;
        }
        return super.start();
    }

    protected boolean needToShowXSLTSettingsDialog() {
        URL uRL = this.xsltConfiguration.getInputFileURL();
        URL uRL2 = this.xsltConfiguration.getOutputFileURL();
        return uRL == null || uRL2 == null;
    }

    protected boolean showXSLTSettingsDialog() {
        return XSLTPanel.showXSLTDialog(this.jrunProcess.getJProject());
    }

    public File getStartDirectory() {
        URL uRL;
        File file = super.getStartDirectory();
        if (file == null && (uRL = URLFileSystem.getParent((URL)this.target.getURL())) != null) {
            file = new File(uRL.getPath());
        }
        return file;
    }

    public String[] getStartCommand() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!this.addJavaExecutableName(arrayList)) {
            return null;
        }
        if (!this.addJavaVmOption(arrayList)) {
            return null;
        }
        this.addClassPathOption(arrayList);
        this.addBootClassPathOption(arrayList);
        this.addJavaOptions(arrayList);
        this.addFirstXSLTOptions(arrayList);
        arrayList.add("oracle.xml.parser.v2.oraxsl");
        String string = this.xsltConfiguration.getXSLTOptions();
        String[] stringArray = IdeUtil.convertStringToStringArray((String)string, (boolean)true, (boolean)true);
        XSLTStarter.addArrayToList(arrayList, stringArray);
        this.addLastXSLTOptions(arrayList);
        URL uRL = this.xsltConfiguration.getInputFileURL();
        String string2 = URLFileSystem.getPlatformPathName((URL)uRL);
        arrayList.add(string2);
        URL uRL2 = this.target.getURL();
        String string3 = URLFileSystem.getPlatformPathName((URL)uRL2);
        arrayList.add(string3);
        URL uRL3 = this.xsltConfiguration.getOutputFileURL();
        String string4 = URLFileSystem.getPlatformPathName((URL)uRL3);
        arrayList.add(string4);
        return arrayList.toArray(new String[arrayList.size()]);
    }

    protected String getClassPath() {
        String string = super.getClassPath();
        if (string == null) {
            string = "";
        } else if (string.length() > 0) {
            string = string + File.pathSeparator;
        }
        FilePath filePath = new FilePath();
        File file = XSLTRunnerAddin.getXSLTJarForDebugging();
        filePath.addEntry(file);
        string = string + filePath.toString();
        return string;
    }

    private void addFirstXSLTOptions(List list) {
        String[] stringArray = (String[])this.jrunProcess.getValue("XSLT", null, "FirstXSLTCommandOptions");
        if (stringArray != null) {
            XSLTStarter.addArrayToList(list, stringArray);
        }
    }

    private void addLastXSLTOptions(List list) {
        String[] stringArray = (String[])this.jrunProcess.getValue("XSLT", null, "LastXSLTCommandOptions");
        if (stringArray != null) {
            XSLTStarter.addArrayToList(list, stringArray);
        }
    }
}

