/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.runner.xslt;

import java.net.URL;
import java.util.List;
import javax.swing.Icon;
import oracle.bali.xml.addin.XMLSourceNode;
import oracle.ide.Context;
import oracle.ide.model.DefaultDisplayable;
import oracle.ide.model.Displayable;
import oracle.ide.model.Node;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFileSystem;
import oracle.ide.runner.AbstractStarterFactory;
import oracle.ide.runner.RunProcess;
import oracle.ide.runner.Starter;
import oracle.javatools.resource.CommonIconsUtils;
import oracle.jdeveloper.runner.JRunProcess;
import oracle.jdeveloper.runner.JStarterFactory;
import oracle.jdeveloper.runner.xslt.XSLTStarter;
import oracle.jdevimpl.runner.xslt.XSLTArb;
import oracle.jdevimpl.runner.xslt.XSLTRunnerAddin;

public class XSLTStarterFactory
extends AbstractStarterFactory
implements JStarterFactory {
    private static final String XSL_SUFFIX = ".xsl";

    public String getName() {
        return XSLTArb.getString(0);
    }

    public Object canStart(RunProcess runProcess, Node node, List list) {
        Object object;
        if (runProcess instanceof JRunProcess && (object = XSLTStarterFactory.findXSLTTarget(node, list)) != null && runProcess.canRun("XSLT", null, node, list)) {
            return object;
        }
        return null;
    }

    public Starter createStarter(RunProcess runProcess, Node node, Object object) {
        XMLSourceNode xMLSourceNode = (XMLSourceNode)object;
        return new XSLTStarter((JRunProcess)runProcess, xMLSourceNode);
    }

    public boolean enableRunDebugActions(Context context) {
        Node node = RunProcess.getContextNodeForRun((Context)context);
        if (node instanceof XMLSourceNode) {
            XMLSourceNode xMLSourceNode = (XMLSourceNode)node;
            URL uRL = xMLSourceNode.getURL();
            if (!uRL.getProtocol().equalsIgnoreCase("file")) {
                return false;
            }
            if (!XSLTRunnerAddin.isXSLT(xMLSourceNode)) {
                return false;
            }
        }
        return super.enableRunDebugActions(context);
    }

    public Displayable getDisplayable(RunProcess runProcess, Context context, Node node, Object object) {
        return new 1();
    }

    private static Object findXSLTTarget(Node node, List list) {
        try {
            if (node instanceof XMLSourceNode) {
                XMLSourceNode xMLSourceNode = (XMLSourceNode)node;
                String string = null;
                URL uRL = xMLSourceNode.getURL();
                if (uRL.getProtocol().equalsIgnoreCase("file")) {
                    if (XSLTRunnerAddin.isXSLT(xMLSourceNode)) {
                        XMLSourceNode xMLSourceNode2 = xMLSourceNode;
                        return xMLSourceNode2;
                    }
                    string = XSLTArb.format(3, xMLSourceNode.getShortLabel());
                } else {
                    string = JarUtil.isJarURL((URL)uRL) ? XSLTArb.format(2, xMLSourceNode.getShortLabel()) : XSLTArb.format(1, xMLSourceNode.getShortLabel());
                }
                if (string != null && URLFileSystem.hasSuffix((URL)uRL, (String)XSL_SUFFIX)) {
                    list.add(string);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public final class 1
    extends DefaultDisplayable {
        public String getShortLabel() {
            return XSLTArb.getString(4);
        }

        public Icon getIcon() {
            return CommonIconsUtils.getXMLIcon();
        }
    }
}

