/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.sourcecolors;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Collections;
import javax.accessibility.AccessibleContext;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import oracle.ide.util.Pair;
import oracle.javatools.util.SwingUtils;
import oracle.jdeveloper.sourcecolors.SourceColorizer;

public class CodeTreeCellRenderer
extends DefaultTreeCellRenderer {
    private AttributedString _attributedString;
    private boolean _sel;
    private boolean _hasFocus;
    private Font _font = new Font(Collections.singletonMap(TextAttribute.FAMILY, "DialogInput"));
    private Color _inactiveBackgroundSelectionColor = UIManager.getColor("oracle.ide.explorer.TreeExplorer.inactiveSelectionBackground");

    public CodeTreeCellRenderer() {
        if (this._inactiveBackgroundSelectionColor == null) {
            this._inactiveBackgroundSelectionColor = this.backgroundSelectionColor;
        }
    }

    public static AttributedString[] getCodeTreeNodes(String string, int[] nArray, int[] nArray2, String string2) {
        return SourceColorizer.toAttributedString(string2, string, nArray, nArray2);
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        this._attributedString = null;
        if (object instanceof DefaultMutableTreeNode) {
            Pair pair;
            Object object2;
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            Object object3 = defaultMutableTreeNode.getUserObject();
            if (object3 instanceof AttributedString) {
                this._attributedString = (AttributedString)object3;
            } else if (object3 instanceof Pair && (object2 = (pair = (Pair)object3).getFirst()) instanceof AttributedString) {
                this._attributedString = (AttributedString)object2;
            }
        } else if (object instanceof AttributedString) {
            this._attributedString = (AttributedString)object;
        }
        if (this._attributedString != null) {
            this._sel = bl;
            this._hasFocus = bl4;
            AttributedCharacterIterator attributedCharacterIterator = this._attributedString.getIterator();
            FontRenderContext fontRenderContext = new FontRenderContext(null, false, false);
            TextLayout textLayout = new TextLayout(attributedCharacterIterator, fontRenderContext);
            Rectangle2D rectangle2D = textLayout.getBounds();
            int n2 = (int)(rectangle2D.getX() + rectangle2D.getWidth());
            int n3 = (int)(rectangle2D.getHeight() - rectangle2D.getY());
            Dimension dimension = new Dimension(n2, n3);
            this.setPreferredSize(dimension);
            AccessibleContext accessibleContext = this.getAccessibleContext();
            if (accessibleContext != null) {
                AttributedCharacterIterator attributedCharacterIterator2 = this._attributedString.getIterator();
                StringBuffer stringBuffer = new StringBuffer();
                char c = attributedCharacterIterator2.first();
                while (c != '\uffff') {
                    stringBuffer.append(c);
                    c = attributedCharacterIterator2.next();
                }
                accessibleContext.setAccessibleName(stringBuffer.toString());
            }
            return this;
        }
        this.setPreferredSize(null);
        return super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
    }

    public void paint(Graphics graphics) {
        if (this._attributedString == null) {
            super.paint(graphics);
        } else {
            Color color;
            Color color2;
            Color color3 = null;
            Color color4 = null;
            if (this._sel) {
                if (this._hasFocus) {
                    color4 = this.getTextSelectionColor();
                    color3 = this.getBackgroundSelectionColor();
                } else {
                    color3 = this._inactiveBackgroundSelectionColor;
                }
                color2 = color3;
            } else {
                color2 = this.getBackgroundNonSelectionColor();
            }
            graphics.setColor(color2);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            if (this._attributedString != SourceColorizer.EMPTY_ATTRIBUTE_STRING) {
                AttributedString attributedString;
                if (color3 != null || color4 != null) {
                    attributedString = new AttributedString(this._attributedString.getIterator());
                    if (color3 != null) {
                        attributedString.addAttribute(TextAttribute.BACKGROUND, color3);
                    }
                    if (color4 != null) {
                        attributedString.addAttribute(TextAttribute.FOREGROUND, color4);
                    }
                } else {
                    attributedString = this._attributedString;
                }
                graphics.setColor(Color.BLACK);
                FontMetrics fontMetrics = graphics.getFontMetrics();
                int n = fontMetrics.getAscent();
                AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
                SwingUtils.drawString((Graphics)graphics, (AttributedCharacterIterator)attributedCharacterIterator, (int)0, (int)n);
            }
            if (this._hasFocus && (color = this.getBorderSelectionColor()) != null) {
                graphics.setColor(color);
                graphics.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            }
        }
    }
}

