/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.sourcecolors;

import java.awt.font.TextAttribute;
import java.net.URL;
import java.text.AttributedString;
import oracle.jdeveloper.sourcecolors.parser.CPPParser;
import oracle.jdeveloper.sourcecolors.parser.HTMLProducer;
import oracle.jdeveloper.sourcecolors.parser.JavaParser;
import oracle.jdeveloper.sourcecolors.parser.LinkInfo;
import oracle.jdeveloper.sourcecolors.parser.NullParser;
import oracle.jdeveloper.sourcecolors.parser.Parser;
import oracle.jdeveloper.sourcecolors.parser.TextAttributeProducer;

public class SourceColorizer {
    public static final String LANGUAGE_JAVA = "java";
    public static final String LANGUAGE_CPP = "cpp";
    public static final AttributedString EMPTY_ATTRIBUTE_STRING = new AttributedString("X");

    public static String getLanguage(URL uRL) {
        String string = uRL.getFile().toLowerCase();
        if (string.endsWith(".java")) {
            return LANGUAGE_JAVA;
        }
        if (string.endsWith(".cpp")) {
            return LANGUAGE_CPP;
        }
        return null;
    }

    public static AttributedString[] toAttributedString(String string, String string2, int[] nArray, int[] nArray2) {
        Parser parser = SourceColorizer.getParser(string);
        int n = nArray.length;
        int n2 = 0;
        AttributedString[] attributedStringArray = new AttributedString[n];
        int n3 = 0;
        while (n3 < n) {
            int n4 = nArray[n3];
            int n5 = nArray2[n3];
            try {
                String string3 = string2.substring(n2, n4);
                parser.toAttributedString(string3, n4 - n2, null);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.out.println("error in SourceColorizer.toAttributedString");
            }
            if (n4 < n5) {
                String string4 = string2.substring(n4, n5);
                TextAttributeProducer textAttributeProducer = new TextAttributeProducer(string4);
                parser.toAttributedString(string4, n5 - n4, textAttributeProducer);
                attributedStringArray[n3] = textAttributeProducer.getAttributedString();
                attributedStringArray[n3].addAttribute(TextAttribute.FAMILY, "DialogInput");
            } else {
                attributedStringArray[n3] = EMPTY_ATTRIBUTE_STRING;
            }
            n2 = n5;
            ++n3;
        }
        return attributedStringArray;
    }

    public static AttributedString toAttributedString(String string, String string2, int n, int n2) {
        AttributedString[] attributedStringArray = SourceColorizer.toAttributedString(string, string2, new int[]{n}, new int[]{n2});
        return attributedStringArray[0];
    }

    private static Parser getParser(String string) {
        Parser parser = NullParser.NULL_PARSER;
        if (string != null) {
            if (string.equals(LANGUAGE_JAVA)) {
                parser = new JavaParser();
            } else if (string.equals(LANGUAGE_CPP)) {
                parser = new CPPParser();
            }
        }
        return parser;
    }

    public static AttributedString toAttributedString(String string, String string2) {
        Parser parser = SourceColorizer.getParser(string);
        TextAttributeProducer textAttributeProducer = new TextAttributeProducer(string2);
        parser.toAttributedString(string2, string2.length(), textAttributeProducer);
        return textAttributeProducer.getAttributedString();
    }

    public static String toHTML(String string, boolean bl, String string2, LinkInfo[] linkInfoArray) {
        Parser parser = SourceColorizer.getParser(string);
        HTMLProducer hTMLProducer = new HTMLProducer(string2);
        if (linkInfoArray != null) {
            hTMLProducer.setLinkInfos(linkInfoArray);
        }
        hTMLProducer.setIncludeLineNumbers(bl);
        hTMLProducer.init();
        parser.toAttributedString(string2, string2.length(), hTMLProducer);
        return hTMLProducer.getHTML();
    }
}

