/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.sourcecolors.addin;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.TextNode;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.util.Pair;
import oracle.ide.view.View;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.clipboard.ClipboardStack;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceHasName;
import oracle.javatools.parser.java.v2.model.SourceMember;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.doc.SourceDocComment;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceNewClassExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceSimpleNameExpression;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.java.util.SourceElementAsList;
import oracle.jdeveloper.model.JavaSourceNode;
import oracle.jdeveloper.sourcecolors.SourceColorizer;
import oracle.jdeveloper.sourcecolors.addin.ExportDialog;
import oracle.jdeveloper.sourcecolors.parser.LinkInfo;

public class ExportToHTMLAddin
implements Controller,
Addin {
    private int _exportActionID;

    public void initialize() {
        this.createActions();
    }

    private void createActions() {
        this._exportActionID = Ide.findOrCreateCmdID((String)"ExportToHTML");
        IdeAction ideAction = IdeAction.get((int)this._exportActionID, null, (String)"Export to HTML...", (String)IdeMainWindow.ACTION_CATEGORY_FILE, null, null, null, (boolean)true);
        ideAction.addController((Controller)this);
        Menubar menubar = Ide.getMenubar();
        JMenuItem jMenuItem = menubar.createMenuItem((ToggleAction)ideAction, MenuConstants.WEIGHT_FILE_IMPORT + 0.001f);
        menubar.add((Component)jMenuItem, MenuManager.getJMenu((String)"File"), MenuConstants.SECTION_FILE_IMPORT_EXPORT);
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        if (ideAction.getCommandId() == this._exportActionID) {
            this.whenExport(context);
            return true;
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        if (ideAction.getCommandId() == this._exportActionID) {
            boolean bl = this.canExport(context);
            ideAction.setEnabled(bl);
            return true;
        }
        return false;
    }

    private void whenExport(Context context) {
        View view = context.getView();
        Element[] elementArray = context.getSelection();
        if (elementArray != null) {
            int n = elementArray.length;
            if (n == 1 && elementArray[0] instanceof TextNode) {
                String string = null;
                if (view instanceof CodeEditor) {
                    CodeEditor codeEditor = (CodeEditor)view;
                    string = codeEditor.getSelectedText();
                }
                if (string != null && string.length() > 0) {
                    this.whenExportNodeOrSelection(context, (TextNode)elementArray[0], string);
                } else {
                    this.whenExportNode(context, (TextNode)elementArray[0]);
                }
            } else {
                ArrayList arrayList = new ArrayList();
                int n2 = 0;
                while (n2 < elementArray.length) {
                    Element element = elementArray[n2];
                    ExportToHTMLAddin.collectTextNodes(element, arrayList);
                    ++n2;
                }
                TextNode[] textNodeArray = arrayList.toArray(new TextNode[arrayList.size()]);
                this.whenExportNodes(context, textNodeArray);
            }
        }
    }

    private static void collectTextNodes(Element element, ArrayList arrayList) {
        if (element instanceof Folder) {
            Folder folder = (Folder)element;
            Iterator iterator = folder.getChildren();
            while (iterator.hasNext()) {
                Element element2 = (Element)iterator.next();
                ExportToHTMLAddin.collectTextNodes(element2, arrayList);
            }
        } else if (element instanceof TextNode) {
            arrayList.add(element);
        }
    }

    private void export(String string, String string2, int n) {
        if (string2 == null) {
            StringSelection stringSelection = new StringSelection(string);
            ClipboardStack.pushCurrentClipboard();
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, null);
        } else {
            File file = new File(string2);
            try {
                File file2 = file.getParentFile();
                file2.mkdirs();
                FileWriter fileWriter = new FileWriter(file);
                fileWriter.write("<HTML>");
                if (n >= 0) {
                    fileWriter.write("<HEAD>");
                    fileWriter.write("<LINK REL=\"stylesheet\" TYPE=\"text/css\" HREF=\"");
                    int n2 = 0;
                    while (n2 < n) {
                        fileWriter.write("../");
                        ++n2;
                    }
                    fileWriter.write("style.css\">");
                    fileWriter.write("</HEAD>");
                }
                fileWriter.write("<BODY>");
                fileWriter.write(string);
                fileWriter.write("</BODY></HTML>");
                fileWriter.close();
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), iOException.getLocalizedMessage(), "Export to HTML", 0);
            }
        }
    }

    private LinkInfo[] getLinkInfos(Context context, TextNode textNode, HashMap hashMap, HashSet hashSet) {
        ArrayList<LinkInfo> arrayList = new ArrayList<LinkInfo>();
        if (textNode instanceof JavaSourceNode) {
            URL uRL;
            JavaSourceNode javaSourceNode = (JavaSourceNode)textNode;
            JavaManager javaManager = JavaManager.getJavaManager(context.getProject());
            SourceFile sourceFile = javaManager.getSourceFile(uRL = javaSourceNode.getURL());
            if (sourceFile != null) {
                System.out.println(URLFileSystem.getPlatformPathName((URL)uRL));
                sourceFile.compile();
                List list = SourceElementAsList.asList((SourceElement)sourceFile);
                int n = 0;
                while (n < list.size()) {
                    SourceElement sourceElement = (SourceElement)list.get(n);
                    switch (sourceElement.getSymbolKind()) {
                        case 54: {
                            SourceMethod sourceMethod;
                            JavaClass javaClass;
                            JavaMethod javaMethod;
                            SourceMethodCallExpression sourceMethodCallExpression = (SourceMethodCallExpression)sourceElement;
                            SourceName sourceName = sourceMethodCallExpression.getNameElement();
                            if (sourceName == null || (javaMethod = sourceMethodCallExpression.getResolvedMethod()) == null || hashSet.contains(javaClass = javaMethod.getOwningClass()) || (sourceMethod = (SourceMethod)javaMethod.getSourceElement()) == null) break;
                            String string = ExportToHTMLAddin.getTooltip((SourceElement)sourceMethod);
                            LinkInfo linkInfo = ExportToHTMLAddin.createLinkInfo(sourceName, (SourceElement)sourceMethod, hashMap, string);
                            if (linkInfo != null) {
                                arrayList.add(linkInfo);
                                break;
                            }
                            hashSet.add(javaClass);
                            break;
                        }
                        case 28: {
                            SourceName sourceName;
                            SourceHasName sourceHasName;
                            JavaClass javaClass;
                            SourceName sourceName2;
                            SourceTypeReference sourceTypeReference = (SourceTypeReference)sourceElement;
                            if (sourceTypeReference == null || (sourceName2 = sourceTypeReference.getNameElement()) == null) break;
                            SourceElement sourceElement2 = sourceTypeReference.getParent();
                            if (sourceElement2.getSymbolKind() == 56) {
                                SourceMethod sourceMethod;
                                JavaClass javaClass2;
                                SourceNewClassExpression sourceNewClassExpression = (SourceNewClassExpression)sourceElement2;
                                JavaMethod javaMethod = sourceNewClassExpression.getResolvedMethod();
                                if (javaMethod == null || hashSet.contains(javaClass2 = javaMethod.getOwningClass()) || (sourceMethod = (SourceMethod)javaMethod.getSourceElement()) == null) break;
                                String string = ExportToHTMLAddin.getTooltip((SourceElement)sourceMethod);
                                LinkInfo linkInfo = ExportToHTMLAddin.createLinkInfo(sourceName2, (SourceElement)sourceMethod, hashMap, string);
                                if (linkInfo != null) {
                                    arrayList.add(linkInfo);
                                    break;
                                }
                                hashSet.add(javaClass2);
                                break;
                            }
                            JavaType javaType = sourceTypeReference.getResolvedType();
                            if (javaType == null || hashSet.contains(javaClass = javaType.getOwningClass()) || (sourceHasName = (SourceHasName)javaType.getSourceElement()) == null || (sourceName = sourceHasName.getNameElement()) == null) break;
                            String string = ExportToHTMLAddin.getTooltip((SourceElement)sourceHasName);
                            LinkInfo linkInfo = ExportToHTMLAddin.createLinkInfo(sourceName2, (SourceElement)sourceName, hashMap, string);
                            if (linkInfo != null) {
                                arrayList.add(linkInfo);
                                break;
                            }
                            hashSet.add(javaClass);
                            break;
                        }
                        case 58: {
                            SourceElement sourceElement3;
                            JavaElement javaElement;
                            SourceSimpleNameExpression sourceSimpleNameExpression = (SourceSimpleNameExpression)sourceElement;
                            JavaHasType javaHasType = sourceSimpleNameExpression.getResolvedObject();
                            if (javaHasType == null || hashSet.contains(javaElement = javaHasType.getOwner()) || (sourceElement3 = javaHasType.getSourceElement()) == null) break;
                            String string = ExportToHTMLAddin.getTooltip(sourceElement3);
                            LinkInfo linkInfo = ExportToHTMLAddin.createLinkInfo(sourceSimpleNameExpression.getNameElement(), sourceElement3, hashMap, string);
                            if (linkInfo != null) {
                                arrayList.add(linkInfo);
                                break;
                            }
                            if (!(javaElement instanceof JavaClass)) break;
                            JavaClass javaClass = (JavaClass)javaElement;
                            hashSet.add(javaClass);
                        }
                    }
                    ++n;
                }
            }
        }
        return arrayList.toArray(new LinkInfo[arrayList.size()]);
    }

    private static String getTooltip(SourceElement sourceElement) {
        SourceMember sourceMember;
        SourceDocComment sourceDocComment;
        if (sourceElement instanceof SourceMember && (sourceDocComment = (sourceMember = (SourceMember)sourceElement).getDocComment()) != null) {
            String string = sourceDocComment.getDocText();
            return string.trim();
        }
        return null;
    }

    private void whenExportNodeOrSelection(Context context, TextNode textNode, String string) {
        ExportDialog exportDialog = new ExportDialog();
        if (exportDialog.runDialog(true, false)) {
            LinkInfo[] linkInfoArray;
            String string2;
            if (exportDialog.isExportSelection()) {
                string2 = string;
            } else {
                TextBuffer textBuffer = textNode.acquireTextBuffer();
                string2 = textBuffer.getString(0, textBuffer.getLength());
            }
            boolean bl = exportDialog.isLineNumberSelected();
            boolean bl2 = exportDialog.isLinksSelected();
            URL uRL = textNode.getURL();
            if (bl2) {
                HashMap<URL, Pair> hashMap = new HashMap<URL, Pair>();
                hashMap.put(uRL, new Pair((Object)"", (Object)new Integer(0)));
                linkInfoArray = this.getLinkInfos(context, textNode, hashMap, new HashSet());
            } else {
                linkInfoArray = null;
            }
            String string3 = SourceColorizer.getLanguage(uRL);
            String string4 = SourceColorizer.toHTML(string3, bl, string2, linkInfoArray);
            if (exportDialog.isExportToClipboard()) {
                this.export(string4, null, -1);
            } else {
                this.export(string4, exportDialog.getOutputFileName(), 0);
            }
        }
    }

    private void whenExportNode(Context context, TextNode textNode) {
        ExportDialog exportDialog = new ExportDialog();
        if (exportDialog.runDialog(false, false)) {
            LinkInfo[] linkInfoArray;
            TextBuffer textBuffer = textNode.acquireTextBuffer();
            String string = textBuffer.getString(0, textBuffer.getLength());
            boolean bl = exportDialog.isLineNumberSelected();
            boolean bl2 = exportDialog.isLinksSelected();
            URL uRL = textNode.getURL();
            if (bl2) {
                HashMap<URL, Pair> hashMap = new HashMap<URL, Pair>();
                hashMap.put(uRL, new Pair((Object)"", (Object)new Integer(0)));
                linkInfoArray = this.getLinkInfos(context, textNode, hashMap, new HashSet());
            } else {
                linkInfoArray = null;
            }
            String string2 = SourceColorizer.getLanguage(uRL);
            String string3 = SourceColorizer.toHTML(string2, bl, string, linkInfoArray);
            if (exportDialog.isExportToClipboard()) {
                this.export(string3, null, -1);
            } else {
                this.export(string3, exportDialog.getOutputFileName(), 0);
            }
        }
    }

    private void whenExportNodes(Context context, TextNode[] textNodeArray) {
        ExportDialog exportDialog = new ExportDialog();
        if (exportDialog.runDialog(false, true)) {
            String string = exportDialog.getOutputDirectoryName();
            URL uRL = URLFactory.newDirURL((String)string);
            ProjectContent projectContent = ProjectContent.getInstance((PropertyStorage)context.getProject());
            URLPath uRLPath = projectContent.getAllContents().getAllRootDirs();
            boolean bl = exportDialog.isLineNumberSelected();
            boolean bl2 = exportDialog.isLinksSelected();
            HashMap<URL, Pair> hashMap = new HashMap<URL, Pair>();
            HashMap<URL, URL> hashMap2 = new HashMap<URL, URL>();
            int n = 0;
            while (n < textNodeArray.length) {
                String string2;
                TextNode textNode = textNodeArray[n];
                URL uRL2 = textNode.getURL();
                URL uRL3 = uRLPath.getLongestMatchingEntry(uRL2);
                if (uRL3 != null) {
                    String string3 = URLFileSystem.getPath((URL)uRL2);
                    String string4 = URLFileSystem.getPath((URL)uRL3);
                    string2 = string3.substring(string4.length()) + ".html";
                } else {
                    string2 = URLFileSystem.getFileName((URL)uRL2) + ".html";
                }
                if (bl2) {
                    int n2 = 0;
                    int n3 = string2.length();
                    int n4 = 0;
                    while (n4 < n3) {
                        if (string2.charAt(n4) == '/') {
                            ++n2;
                        }
                        ++n4;
                    }
                    hashMap.put(uRL2, new Pair((Object)string2, (Object)new Integer(n2)));
                }
                URL uRL4 = URLFactory.newURL((URL)uRL, (String)string2);
                hashMap2.put(uRL2, uRL4);
                ++n;
            }
            HashSet hashSet = new HashSet();
            int n5 = 0;
            while (n5 < textNodeArray.length) {
                TextNode textNode = textNodeArray[n5];
                URL uRL5 = textNode.getURL();
                URL uRL6 = (URL)hashMap2.get(uRL5);
                LinkInfo[] linkInfoArray = bl2 ? this.getLinkInfos(context, textNode, hashMap, hashSet) : null;
                TextBuffer textBuffer = textNode.acquireTextBuffer();
                String string5 = textBuffer.getString(0, textBuffer.getLength());
                URL uRL7 = textNode.getURL();
                String string6 = SourceColorizer.getLanguage(uRL7);
                String string7 = SourceColorizer.toHTML(string6, bl, string5, linkInfoArray);
                int n6 = -1;
                if (bl2) {
                    Pair pair = (Pair)hashMap.get(uRL5);
                    n6 = (Integer)pair.second;
                }
                this.export(string7, URLFileSystem.getPlatformPathName((URL)uRL6), n6);
                ++n5;
            }
        }
    }

    private boolean canExport(Context context) {
        if (context == null) {
            return false;
        }
        Element[] elementArray = context.getSelection();
        if (elementArray != null) {
            int n = 0;
            while (n < elementArray.length) {
                Element element = elementArray[n];
                if (!ExportToHTMLAddin.canExport(element)) {
                    return false;
                }
                ++n;
            }
        }
        return true;
    }

    private static boolean canExport(Element element) {
        if (!(element instanceof TextNode)) {
            if (element instanceof Folder) {
                Folder folder = (Folder)element;
                Iterator iterator = folder.getChildren();
                while (iterator.hasNext()) {
                    Element element2 = (Element)iterator.next();
                    if (ExportToHTMLAddin.canExport(element2)) continue;
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    public static LinkInfo createLinkInfo(SourceName sourceName, SourceElement sourceElement, HashMap hashMap, String string) {
        SourceFile sourceFile = sourceElement.getOwningSourceFile();
        URL uRL = sourceFile.getURL();
        Pair pair = (Pair)hashMap.get(uRL);
        if (pair != null) {
            String string2 = (String)pair.first;
            SourceFile sourceFile2 = sourceName.getOwningSourceFile();
            URL uRL2 = sourceFile2.getURL();
            Pair pair2 = (Pair)hashMap.get(uRL2);
            if (pair2 != null) {
                int n = (Integer)pair2.second;
                StringBuffer stringBuffer = new StringBuffer();
                int n2 = 0;
                while (n2 < n) {
                    stringBuffer.append("../");
                    ++n2;
                }
                stringBuffer.append(string2);
                TextBuffer textBuffer = sourceFile.getTextBuffer();
                LineMap lineMap = textBuffer.getLineMap();
                int n3 = sourceElement.getStartOffset();
                int n4 = lineMap.getLineFromOffset(n3) + 1;
                return new LinkInfo(sourceName.getStartOffset(), sourceName.getEndOffset(), stringBuffer.toString(), n4, string);
            }
        }
        return null;
    }
}

