/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.sourcecolors.parser;

import oracle.jdeveloper.sourcecolors.parser.Parser;
import oracle.jdeveloper.sourcecolors.parser.Producer;

abstract class GenericParser
implements Parser {
    private static final int STATE_NORMAL = 0;
    private static final int STATE_STRING = 1;
    private static final int STATE_WORD = 2;
    private static final int STATE_SLASH = 3;
    private static final int STATE_SINGLE_LINE_COMMENT = 4;
    private static final int STATE_COMMENT_1 = 5;
    private static final int STATE_COMMENT = 6;
    private static final int STATE_JAVADOC = 7;
    private static final int STATE_CHAR = 8;
    private int _state;

    protected abstract boolean isLitteral(String var1);

    protected abstract boolean isReservedWord(String var1);

    protected abstract boolean isOperator(char var1);

    protected abstract boolean isBrace(char var1);

    protected abstract boolean isStringDelimiter(char var1);

    protected abstract boolean isCharDelimiter(char var1);

    protected abstract boolean isStartComment(char var1);

    protected abstract boolean isEscapeChar(char var1);

    protected abstract boolean isIdentifierStart(char var1);

    protected abstract boolean isIdentifierPart(char var1);

    protected abstract boolean isComment2(char var1);

    protected abstract boolean isSpecialComment3(char var1);

    protected abstract boolean isSingleLineComment2(char var1);

    protected abstract boolean isEndComment1(char var1);

    protected abstract boolean isEndComment2(char var1);

    protected abstract boolean isCommentRecursive();

    public void toAttributedString(String string, int n, Producer producer) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            char c = string.charAt(n3);
            switch (this._state) {
                case 0: {
                    n2 = n3;
                    if (this.isIdentifierStart(c)) {
                        this._state = 2;
                        break;
                    }
                    if (this.isOperator(c)) {
                        this.addAttributes(producer, Producer.ATTRIBUTES_OPERATOR, n3, n3 + 1);
                        break;
                    }
                    if (this.isBrace(c)) {
                        this.addAttributes(producer, Producer.ATTRIBUTES_BRACE, n3, n3 + 1);
                        break;
                    }
                    if (this.isStringDelimiter(c)) {
                        this._state = 1;
                        break;
                    }
                    if (this.isCharDelimiter(c)) {
                        this._state = 8;
                        break;
                    }
                    if (!this.isStartComment(c)) break;
                    this._state = 3;
                    break;
                }
                case 1: {
                    if (this.isStringDelimiter(c)) {
                        this.addAttributes(producer, Producer.ATTRIBUTES_STRING, n2, n3 + 1);
                        this._state = 0;
                        break;
                    }
                    if (!this.isEscapeChar(c) || n3 + 1 >= n) break;
                    ++n3;
                    break;
                }
                case 2: {
                    if (this.isIdentifierPart(c)) break;
                    if (producer != null) {
                        String string2 = string.substring(n2, n3);
                        if (this.isReservedWord(string2)) {
                            this.addAttributes(producer, Producer.ATTRIBUTES_RESERVED_WORD, n2, n3);
                        } else if (this.isLitteral(string2)) {
                            this.addAttributes(producer, Producer.ATTRIBUTES_CONSTANT, n2, n3);
                        } else {
                            this.addAttributes(producer, Producer.ATTRIBUTES_IDENTIFIER, n2, n3);
                        }
                    }
                    --n3;
                    this._state = 0;
                    break;
                }
                case 3: {
                    if (this.isSingleLineComment2(c)) {
                        this._state = 4;
                        break;
                    }
                    if (this.isComment2(c)) {
                        this._state = 5;
                        break;
                    }
                    if (n3 > 0) {
                        this.addAttributes(producer, Producer.ATTRIBUTES_OPERATOR, n2, n3 - 1);
                    }
                    this._state = 0;
                    break;
                }
                case 4: {
                    if (c != '\r' && c != '\n') break;
                    this.addAttributes(producer, Producer.ATTRIBUTES_SINGLE_LINE_COMMENT, n2, n3);
                    --n3;
                    this._state = 0;
                    break;
                }
                case 5: {
                    if (this.isSpecialComment3(c)) {
                        this._state = 7;
                        break;
                    }
                    if (c == '\n') {
                        this.addAttributes(producer, Producer.ATTRIBUTES_COMMENT, n2, n3);
                        this.addAttributes(producer, Producer.ATTRIBUTES_NORMAL, n3, n3);
                        n2 = n3 + 1;
                    }
                    this._state = 6;
                    break;
                }
                case 6: {
                    if (this.isEndComment1(c)) {
                        if (n3 + 1 >= n || !this.isEndComment2(string.charAt(n3 + 1))) break;
                        this.addAttributes(producer, Producer.ATTRIBUTES_COMMENT, n2, ++n3 + 1);
                        this._state = 0;
                        break;
                    }
                    if (c != '\n') break;
                    this.addAttributes(producer, Producer.ATTRIBUTES_COMMENT, n2, n3);
                    this.addAttributes(producer, Producer.ATTRIBUTES_NORMAL, n3, n3);
                    n2 = n3 + 1;
                    break;
                }
                case 7: {
                    if (this.isEndComment1(c)) {
                        if (n3 + 1 >= n || !this.isEndComment2(string.charAt(n3 + 1))) break;
                        this.addAttributes(producer, Producer.ATTRIBUTES_JAVADOC, n2, ++n3 + 1);
                        this._state = 0;
                        break;
                    }
                    if (c != '\n') break;
                    this.addAttributes(producer, Producer.ATTRIBUTES_JAVADOC, n2, n3);
                    this.addAttributes(producer, Producer.ATTRIBUTES_NORMAL, n3, n3);
                    n2 = n3 + 1;
                    break;
                }
                case 8: {
                    if (this.isCharDelimiter(c)) {
                        this.addAttributes(producer, Producer.ATTRIBUTES_CHAR, n2, n3 + 1);
                        this._state = 0;
                        break;
                    }
                    if (!this.isEscapeChar(c) || n3 + 1 >= n) break;
                    ++n3;
                }
            }
            ++n3;
        }
        if (n2 < n) {
            switch (this._state) {
                case 1: {
                    this.addAttributes(producer, Producer.ATTRIBUTES_STRING, n2, n);
                    break;
                }
                case 4: {
                    this.addAttributes(producer, Producer.ATTRIBUTES_SINGLE_LINE_COMMENT, n2, n);
                    break;
                }
                case 5: 
                case 6: {
                    this.addAttributes(producer, Producer.ATTRIBUTES_COMMENT, n2, n);
                    break;
                }
                case 7: {
                    this.addAttributes(producer, Producer.ATTRIBUTES_JAVADOC, n2, n);
                    break;
                }
                case 8: {
                    this.addAttributes(producer, Producer.ATTRIBUTES_CHAR, n2, n);
                    break;
                }
                case 2: {
                    String string3 = string.substring(n2, n);
                    if (this.isReservedWord(string3)) {
                        this.addAttributes(producer, Producer.ATTRIBUTES_RESERVED_WORD, n2, n);
                        break;
                    }
                    if (this.isLitteral(string3)) {
                        this.addAttributes(producer, Producer.ATTRIBUTES_CONSTANT, n2, n);
                        break;
                    }
                    this.addAttributes(producer, Producer.ATTRIBUTES_IDENTIFIER, n2, n);
                }
            }
        }
    }

    private void addAttributes(Producer producer, Object object, int n, int n2) {
        if (producer != null) {
            producer.addAttributes(object, n, n2);
        }
    }

    GenericParser() {
    }
}

