/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.sourcecolors.parser;

import java.util.ArrayList;
import java.util.Collections;
import oracle.jdeveloper.sourcecolors.parser.LinkInfo;
import oracle.jdeveloper.sourcecolors.parser.Producer;

public class HTMLProducer
extends Producer {
    private static final String END_FONT = "</font>";
    private static final String START_STRING = "<font color=\"#0030CE\">";
    private static final String END_STRING = "</font>";
    private static final String START_CHAR = "<font color=\"#0030CE\">";
    private static final String END_CHAR = "</font>";
    private static final String START_RESERVED_WORD = "<font color=\"#31659C\"><B>";
    private static final String END_RESERVED_WORD = "</B></font>";
    private static final String START_CONSTANT = "<font color=\"#9C6500\">";
    private static final String END_CONSTANT = "</font>";
    private static final String START_COMMENT = "<font color=\"#848284\">";
    private static final String END_COMMENT = "</font>";
    private static final String START_SLC = "<font color=\"#848284\">";
    private static final String END_SLC = "</font>";
    private static final String START_JAVADOC_COMMENT = "<font color=\"#0030CE\">";
    private static final String END_JAVADOC_COMMENT = "</font>";
    private static final String START_BRACE = null;
    private static final String END_BRACE = null;
    private static final String START_IDENTIFIER = null;
    private static final String END_IDENTIFIER = null;
    private static final String START_OPERATOR = null;
    private static final String END_OPERATOR = null;
    private static final String START_TAGNAME = null;
    private static final String END_TAGNAME = null;
    private String _code;
    private StringBuffer _stringBuffer;
    private int _lastPos;
    private boolean _lineNumbers;
    private ArrayList _inserts;
    private int _insertPos;
    private LinkInfo[] _linkInfos;

    void $init$() {
        this._insertPos = 0;
    }

    public HTMLProducer(String string) {
        this.$init$();
        this._stringBuffer = new StringBuffer(string.length() * 2);
        this._code = string;
    }

    public void addAttributes(Object object, int n, int n2) {
        if (object == Producer.ATTRIBUTES_NORMAL) {
            this.add(n, n2);
        } else if (object == Producer.ATTRIBUTES_STRING) {
            this.add("<font color=\"#0030CE\">", "</font>", n, n2);
        } else if (object == Producer.ATTRIBUTES_RESERVED_WORD) {
            this.add(START_RESERVED_WORD, END_RESERVED_WORD, n, n2);
        } else if (object == Producer.ATTRIBUTES_CONSTANT) {
            this.add(START_CONSTANT, "</font>", n, n2);
        } else if (object == Producer.ATTRIBUTES_SINGLE_LINE_COMMENT) {
            this.add("<font color=\"#848284\">", "</font>", n, n2);
        } else if (object == Producer.ATTRIBUTES_COMMENT) {
            this.add("<font color=\"#848284\">", "</font>", n, n2);
        } else if (object == Producer.ATTRIBUTES_JAVADOC) {
            this.add("<font color=\"#0030CE\">", "</font>", n, n2);
        } else if (object == Producer.ATTRIBUTES_CHAR) {
            this.add("<font color=\"#0030CE\">", "</font>", n, n2);
        } else if (object == Producer.ATTRIBUTES_BRACE) {
            this.add(START_BRACE, END_BRACE, n, n2);
        } else if (object == Producer.ATTRIBUTES_IDENTIFIER) {
            this.add(START_IDENTIFIER, END_IDENTIFIER, n, n2);
        } else if (object == Producer.ATTRIBUTES_OPERATOR) {
            this.add(START_OPERATOR, END_OPERATOR, n, n2);
        } else if (object == Producer.ATTRIBUTES_TAGNAME) {
            this.add(START_TAGNAME, END_TAGNAME, n, n2);
        } else {
            this.add(n, n2);
        }
    }

    private void add(String string, String string2, int n, int n2) {
        if (this._lastPos < n) {
            this.add(this._lastPos, n);
        }
        this.doInserts(n);
        if (string != null) {
            this._stringBuffer.append(string);
        }
        this.add(n, n2);
        if (string2 != null) {
            this._stringBuffer.append(string2);
        }
        this._lastPos = n2;
    }

    private void add(int n, int n2) {
        while (n < n2) {
            int n3 = this.doInserts(n);
            int n4 = Math.min(n3, n2);
            this._stringBuffer.append(this._code.substring(n, n4));
            n = n4;
        }
    }

    private int doInserts(int n) {
        while (true) {
            Insert insert = (Insert)this._inserts.get(this._insertPos);
            int n2 = insert._pos;
            if (n < n2) {
                return n2;
            }
            this._stringBuffer.append(insert._insert);
            ++this._insertPos;
        }
    }

    public String getHTML() {
        return "<PRE>" + this._stringBuffer.toString() + "</PRE>";
    }

    public void init() {
        this._inserts = new ArrayList();
        if (this._lineNumbers || this._linkInfos != null) {
            this._inserts.add(new Insert(0, this.getLineAnchor(1)));
            int n = 2;
            int n2 = 0;
            while (n2 < this._code.length()) {
                if (this._code.charAt(n2) == '\n') {
                    String string = this.getLineAnchor(n);
                    this._inserts.add(new Insert(n2 + 1, string));
                    ++n;
                }
                ++n2;
            }
        }
        if (this._linkInfos != null) {
            int n = 0;
            while (n < this._linkInfos.length) {
                LinkInfo linkInfo = this._linkInfos[n];
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("<A HREF=\"");
                stringBuffer.append(linkInfo.getToLink());
                stringBuffer.append('#');
                stringBuffer.append(linkInfo.getToLine());
                stringBuffer.append('\"');
                String string = linkInfo.getTooltip();
                if (string != null) {
                    stringBuffer.append(" TITLE=\"");
                    stringBuffer.append(string.replace('\"', '\''));
                    stringBuffer.append('\"');
                }
                stringBuffer.append('>');
                this._inserts.add(new Insert(linkInfo.getFromOffsetStart(), stringBuffer.toString()));
                this._inserts.add(new Insert(linkInfo.getFromOffsetEnd(), "</A>"));
                ++n;
            }
        }
        this._inserts.add(new Insert(Integer.MAX_VALUE, ""));
        Collections.sort(this._inserts);
    }

    private String getLineAnchor(int n) {
        String string = Integer.toString(n);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<A NAME=\"");
        stringBuffer.append(string);
        stringBuffer.append("\">");
        if (this._lineNumbers) {
            stringBuffer.append(n);
            String string2 = "       ".substring(string.length());
            stringBuffer.append(string2);
        }
        stringBuffer.append("</A>");
        return stringBuffer.toString();
    }

    public void setIncludeLineNumbers(boolean bl) {
        this._lineNumbers = bl;
    }

    public void setLinkInfos(LinkInfo[] linkInfoArray) {
        this._linkInfos = linkInfoArray;
    }

    private static class Insert
    implements Comparable {
        int _pos;
        String _insert;

        public Insert(int n, String string) {
            this._insert = string;
            this._pos = n;
        }

        public int compareTo(Object object) {
            Insert insert = (Insert)object;
            return this._pos - insert._pos;
        }
    }
}

