/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.sourcecolors.parser;

import java.util.HashSet;
import oracle.jdeveloper.sourcecolors.parser.GenericParser;

public class JavaParser
extends GenericParser {
    private static final int CHAR_OPERATOR = 1;
    private static final int CHAR_BRACE = 2;
    private static final HashSet RESERVED_WORDS = new HashSet();
    private static final HashSet CONSTANTS = new HashSet();
    private static final char[] OPERATORS = new char[127];

    static {
        RESERVED_WORDS.add("abstract");
        RESERVED_WORDS.add("assert");
        RESERVED_WORDS.add("boolean");
        RESERVED_WORDS.add("break");
        RESERVED_WORDS.add("byte");
        RESERVED_WORDS.add("case");
        RESERVED_WORDS.add("catch");
        RESERVED_WORDS.add("char");
        RESERVED_WORDS.add("class");
        RESERVED_WORDS.add("const");
        RESERVED_WORDS.add("continue");
        RESERVED_WORDS.add("default");
        RESERVED_WORDS.add("do");
        RESERVED_WORDS.add("double");
        RESERVED_WORDS.add("else");
        RESERVED_WORDS.add("extends");
        RESERVED_WORDS.add("final");
        RESERVED_WORDS.add("finally");
        RESERVED_WORDS.add("float");
        RESERVED_WORDS.add("for");
        RESERVED_WORDS.add("goto");
        RESERVED_WORDS.add("if");
        RESERVED_WORDS.add("implements");
        RESERVED_WORDS.add("import");
        RESERVED_WORDS.add("instanceof");
        RESERVED_WORDS.add("int");
        RESERVED_WORDS.add("interface");
        RESERVED_WORDS.add("long");
        RESERVED_WORDS.add("native");
        RESERVED_WORDS.add("new");
        RESERVED_WORDS.add("package");
        RESERVED_WORDS.add("private");
        RESERVED_WORDS.add("protected");
        RESERVED_WORDS.add("public");
        RESERVED_WORDS.add("return");
        RESERVED_WORDS.add("short");
        RESERVED_WORDS.add("static");
        RESERVED_WORDS.add("strictfp");
        RESERVED_WORDS.add("super");
        RESERVED_WORDS.add("switch");
        RESERVED_WORDS.add("synchronized");
        RESERVED_WORDS.add("this");
        RESERVED_WORDS.add("throw");
        RESERVED_WORDS.add("throws");
        RESERVED_WORDS.add("transient");
        RESERVED_WORDS.add("try");
        RESERVED_WORDS.add("void");
        RESERVED_WORDS.add("volatile");
        RESERVED_WORDS.add("while");
        CONSTANTS.add("false");
        CONSTANTS.add("null");
        CONSTANTS.add("true");
        JavaParser.OPERATORS[59] = '\u0001';
        JavaParser.OPERATORS[44] = '\u0001';
        JavaParser.OPERATORS[46] = '\u0001';
        JavaParser.OPERATORS[61] = '\u0001';
        JavaParser.OPERATORS[60] = '\u0001';
        JavaParser.OPERATORS[62] = '\u0001';
        JavaParser.OPERATORS[33] = '\u0001';
        JavaParser.OPERATORS[126] = '\u0001';
        JavaParser.OPERATORS[63] = '\u0001';
        JavaParser.OPERATORS[58] = '\u0001';
        JavaParser.OPERATORS[43] = '\u0001';
        JavaParser.OPERATORS[45] = '\u0001';
        JavaParser.OPERATORS[42] = '\u0001';
        JavaParser.OPERATORS[38] = '\u0001';
        JavaParser.OPERATORS[124] = '\u0001';
        JavaParser.OPERATORS[37] = '\u0001';
        JavaParser.OPERATORS[123] = 2;
        JavaParser.OPERATORS[125] = 2;
        JavaParser.OPERATORS[91] = 2;
        JavaParser.OPERATORS[93] = 2;
        JavaParser.OPERATORS[123] = 2;
        JavaParser.OPERATORS[125] = 2;
    }

    protected boolean isLitteral(String string) {
        return CONSTANTS.contains(string);
    }

    protected boolean isReservedWord(String string) {
        return RESERVED_WORDS.contains(string);
    }

    protected boolean isOperator(char c) {
        return c < OPERATORS.length && (OPERATORS[c] & '\u0001') == 1;
    }

    protected boolean isBrace(char c) {
        return c < OPERATORS.length && (OPERATORS[c] & 2) == 2;
    }

    protected boolean isStringDelimiter(char c) {
        return c == '\"';
    }

    protected boolean isCharDelimiter(char c) {
        return c == '\'';
    }

    protected boolean isStartComment(char c) {
        return c == '/';
    }

    protected boolean isEscapeChar(char c) {
        return c == '\\';
    }

    protected boolean isIdentifierStart(char c) {
        return Character.isJavaIdentifierStart(c);
    }

    protected boolean isIdentifierPart(char c) {
        return Character.isJavaIdentifierPart(c);
    }

    protected boolean isComment2(char c) {
        return c == '*';
    }

    protected boolean isSpecialComment3(char c) {
        return c == '*';
    }

    protected boolean isSingleLineComment2(char c) {
        return c == '/';
    }

    protected boolean isEndComment1(char c) {
        return c == '*';
    }

    protected boolean isEndComment2(char c) {
        return c == '/';
    }

    protected boolean isCommentRecursive() {
        return false;
    }
}

