/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.tree;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import oracle.jdeveloper.tree.TreeMouseClickHandler;

public class TreeMouseAdapter
extends MouseAdapter {
    JTree myTree;
    int pressedRow;
    long pressedTime;
    static final int BOUNCE_TIME = 150;

    public TreeMouseAdapter(JTree jTree) {
        this.myTree = jTree;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.pressedTime = mouseEvent.getWhen();
        this.pressedRow = this.myTree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        TreePath treePath;
        Object object;
        if (this.pressedRow == -1) {
            this.pressedTime = -1;
            return;
        }
        long l = mouseEvent.getWhen();
        int n = this.myTree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
        long l2 = l - this.pressedTime;
        if ((this.pressedRow == n || l2 <= 150L) && (object = (treePath = this.myTree.getPathForRow(this.pressedRow)).getLastPathComponent()) instanceof TreeMouseClickHandler) {
            ((TreeMouseClickHandler)object).handleMouseClick();
            this.myTree.revalidate();
            this.myTree.repaint();
        }
    }
}

