/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.usage;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLComparator;
import oracle.ide.net.URLPath;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.util.AsyncScheduler;
import oracle.javatools.parser.util.AsyncTask;
import oracle.jdeveloper.java.CacheSupport;
import oracle.jdeveloper.java.JavaFileProvider;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.model.JavaSourceNode;
import oracle.jdeveloper.usage.UsageArb;
import oracle.jdeveloper.usage.UsageManager;
import oracle.jdeveloper.usage.UsageQueryTask;
import oracle.jdeveloper.usage.event.UsageEvent;
import oracle.jdeveloper.usage.event.UsageListener;
import oracle.jdeveloper.usage.keyword.JavaLocator;
import oracle.jdeveloper.usage.keyword.JavaScanner;
import oracle.jdeveloper.usage.keyword.KeywordIndex;
import oracle.jdeveloper.usage.keyword.KeywordQueryTask;
import oracle.jdeveloper.usage.util.AbstractBackgroundTask;
import oracle.jdeveloper.usage.util.NodeUtilities;
import oracle.jdevimpl.java.Bug4598932Fix;

abstract class BaseQueryTaskImpl
extends AbstractBackgroundTask
implements UsageQueryTask {
    protected UsageManager _usageManager;
    protected UsageListener _listener;
    protected URL[] _urlsToSearch;
    protected static final String FINISHED_RESULT = "finished";
    protected SourceFile _sourceFile;

    BaseQueryTaskImpl(UsageManager usageManager, UsageListener usageListener, URL[] uRLArray) {
        this.$init$();
        this._usageManager = usageManager;
        this._listener = usageListener;
        this._urlsToSearch = uRLArray;
    }

    protected UsageManager getUsageManager() {
        return this._usageManager;
    }

    protected JavaFileProvider getJavaProvider() {
        return this._usageManager.getJavaProvider();
    }

    protected URLPath getSourcePath() {
        return this._usageManager.getSourcePath();
    }

    protected AsyncScheduler getSchedulerImpl() {
        return UsageManager.USAGE_SCHEDULER;
    }

    protected final Object runTaskImpl() {
        try {
            Object object = this.runQueryImpl();
            boolean bl = object == "cancelled";
            int n = bl ? 1 : 0;
            this.notifyFinished(n);
            Object object2 = object;
            return object2;
        }
        catch (AsyncTask.CancelledException cancelledException) {
            this.notifyFinished(1);
            String string = "cancelled";
            return string;
        }
        catch (RuntimeException runtimeException) {
            this.notifyFinished(2);
            throw runtimeException;
        }
    }

    private void notifyFinished(int n) {
        UsageEvent usageEvent = new UsageEvent(this, n);
        this._listener.notifyFinished(usageEvent);
    }

    private void notifySkipped(URL uRL) {
        UsageEvent usageEvent = new UsageEvent(this, 3, uRL);
        this._listener.notifySkipped(usageEvent);
    }

    private void notifySkipped(URL uRL, int n, int n2) {
        UsageEvent usageEvent = new UsageEvent(this, 4, uRL, n, n2);
        this._listener.notifySkipped(usageEvent);
    }

    protected abstract boolean isStartingDataValid();

    protected abstract String getSearchKeyword();

    protected abstract void performUsages(SourceFile var1, int[] var2, int[] var3);

    protected URL[] getURLsToSearch(int n, int n2) throws AsyncTask.CancelledException {
        URL[] uRLArray = this._urlsToSearch != null ? this._urlsToSearch : this.getURLsFromKeywordIndex(n, n2);
        URL[] uRLArray2 = this.getJavaURLsFromURLs(uRLArray);
        this.setProgressFromSubTask(100, 0, 10);
        return uRLArray2;
    }

    protected URL[] getJavaURLsFromURLs(URL[] uRLArray) throws AsyncTask.CancelledException {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        int n = uRLArray.length;
        int n2 = 0;
        while (n2 < n) {
            this.bailIfCancelled();
            URL uRL = uRLArray[n2];
            try {
                if (uRL != null) {
                    Node node = NodeFactory.findOrCreate((URL)uRL);
                    if (node != null && node instanceof JavaSourceNode) {
                        arrayList.add(uRL);
                    } else {
                        this.notifySkipped(uRL);
                    }
                }
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            ++n2;
        }
        Collections.sort(arrayList, new URLComparator());
        n = arrayList.size();
        URL[] uRLArray2 = new URL[n];
        return arrayList.toArray(uRLArray2);
    }

    protected URL[] getURLsFromKeywordIndex(int n, int n2) throws AsyncTask.CancelledException {
        String string = this.getSearchKeyword();
        ArrayList<URL> arrayList = new ArrayList<URL>();
        this.setProgressText(UsageArb.getString(0));
        URLPath uRLPath = this.getSourcePath();
        URL[] uRLArray = uRLPath.getEntries();
        int n3 = uRLArray == null ? 0 : uRLArray.length;
        int n4 = 0;
        while (n4 < n3) {
            int n5;
            this.bailIfCancelled();
            URL uRL = uRLArray[n4];
            KeywordIndex keywordIndex = KeywordIndex.getKeywordIndex(uRL);
            KeywordQueryTask keywordQueryTask = keywordIndex.getQueryTask(string);
            while (!keywordQueryTask.isFinished()) {
                if (this.isCancelledImpl()) {
                    keywordQueryTask.cancel();
                    this.bailIfCancelled();
                }
                this.setProgressFromSubTask(keywordQueryTask, 0, 10);
                this.setProgressText(keywordQueryTask.getProgressText());
                BaseQueryTaskImpl.sleep((int)100);
            }
            URL[] uRLArray2 = keywordQueryTask.getQueryResult();
            int n6 = n5 = uRLArray2 == null ? 0 : uRLArray2.length;
            if (n5 > 0) {
                arrayList.addAll(Arrays.asList(uRLArray2));
            }
            ++n4;
        }
        int n7 = arrayList.size();
        URL[] uRLArray3 = new URL[n7];
        return arrayList.toArray(uRLArray3);
    }

    protected int[][] getKeywordLocations(ReadTextBuffer readTextBuffer) {
        char[] cArray = this.getSearchKeyword().toCharArray();
        JavaLocator javaLocator = new JavaLocator();
        JavaScanner javaScanner = new JavaScanner(readTextBuffer, javaLocator);
        javaScanner.scan(cArray, -1);
        int[] nArray = javaLocator.getStartLocations();
        int[] nArray2 = javaLocator.getEndLocations();
        int[] nArray3 = javaLocator.getOtherStartLocations();
        int[] nArray4 = javaLocator.getOtherEndLocations();
        return new int[][]{nArray, nArray2, nArray3, nArray4};
    }

    protected void notifySkippedOccurrences(URL uRL, int[] nArray, int[] nArray2) {
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray[n2];
            int n4 = nArray2[n2];
            this.notifySkipped(uRL, n3, n4);
            ++n2;
        }
    }

    protected int[] addIntToArray(int[] nArray, int n, int n2) {
        if (n >= nArray.length) {
            int n3 = 2 * Math.max(nArray.length, 10);
            int[] nArray2 = new int[n3];
            System.arraycopy(nArray, 0, nArray2, 0, n);
            nArray = nArray2;
        }
        nArray[n] = n2;
        return nArray;
    }

    protected int[] trimArrayToSize(int[] nArray, int n) {
        int n2 = nArray.length;
        if (n2 == n) {
            return nArray;
        }
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, 0, n);
        return nArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancelTaskImpl() {
        BaseQueryTaskImpl baseQueryTaskImpl = this;
        synchronized (baseQueryTaskImpl) {
            if (this._sourceFile != null) {
                this._sourceFile.cancelCompile();
            }
        }
    }

    void $init$() {
        this._sourceFile = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object runQueryImpl() throws AsyncTask.CancelledException {
        this.bailIfCancelled();
        if (!this.isStartingDataValid()) {
            return FINISHED_RESULT;
        }
        URL[] uRLArray = this.getURLsToSearch(0, 10);
        int n = uRLArray.length;
        long l = System.currentTimeMillis();
        long l2 = 0L;
        int n2 = 0;
        int n3 = 0;
        JavaFileProvider javaFileProvider = this.getJavaProvider();
        CacheSupport cacheSupport = null;
        if (javaFileProvider instanceof JavaManager) {
            cacheSupport = ((JavaManager)javaFileProvider).getCacheSupport();
        }
        try {
            if (cacheSupport != null) {
                cacheSupport.beginCacheUse();
            }
            int n4 = uRLArray.length;
            int n5 = 0;
            int n6 = 0;
            while (n6 < n4) {
                this.bailIfCancelled();
                int n7 = (int)((double)n6 * 100.0 / (double)n4);
                this.setProgressFromSubTask(n7, 10, 100);
                String string = Integer.toString(n4 - n6);
                this.setProgressText(UsageArb.format(1, string));
                URL uRL = uRLArray[n6];
                TextBuffer textBuffer = NodeUtilities.getTextBufferFor(uRL);
                boolean bl = true;
                if (Bug4598932Fix.getPreventDeadlock()) {
                    bl = textBuffer.tryReadLock();
                } else {
                    textBuffer.readLock();
                }
                int[][] nArray = this.getKeywordLocations((ReadTextBuffer)textBuffer);
                int[] nArray2 = nArray[0];
                int[] nArray3 = nArray[1];
                int[] nArray4 = nArray[2];
                int[] nArray5 = nArray[3];
                SourceFile sourceFile = javaFileProvider.getSourceFile(uRL);
                this.bailIfCancelled();
                try {
                    BaseQueryTaskImpl baseQueryTaskImpl = this;
                    synchronized (baseQueryTaskImpl) {
                        this._sourceFile = sourceFile;
                    }
                    if (this.isCancelledImpl()) {
                        String string2 = "cancelled";
                        if (bl) {
                            textBuffer.readUnlock();
                        }
                        if (cacheSupport != null) {
                            cacheSupport.endCacheUse();
                        }
                        return string2;
                    }
                    try {
                        this.performUsages(sourceFile, nArray2, nArray3);
                    }
                    catch (RuntimeException runtimeException) {
                        System.out.println("failing for url: " + uRL.toString());
                    }
                    ++n3;
                    l2 += (long)textBuffer.getLength();
                    n2 += nArray2.length;
                    if (++n5 > 25) {
                        n5 = 0;
                        if (cacheSupport != null) {
                            cacheSupport.flushCache();
                        }
                        BaseQueryTaskImpl.sleep((int)50);
                    }
                    this.notifySkippedOccurrences(uRL, nArray4, nArray5);
                }
                finally {
                    if (bl) {
                        textBuffer.readUnlock();
                    }
                }
                ++n6;
            }
        }
        finally {
            if (cacheSupport != null) {
                cacheSupport.endCacheUse();
            }
        }
        this.setProgress(100);
        this.setProgressText("");
        long l3 = System.currentTimeMillis() - l;
        return FINISHED_RESULT;
    }

    protected static String getClassName(String string) {
        int n = string.lastIndexOf(46);
        return n == -1 ? string : string.substring(n + 1);
    }
}

