/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.usage;

import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.java.v2.model.JavaLocalVariable;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.scanner.JavaLexer;
import oracle.jdeveloper.usage.BaseQueryTaskImpl;
import oracle.jdeveloper.usage.UsageManager;
import oracle.jdeveloper.usage.event.MethodUsageListener;
import oracle.jdevimpl.java.usage.BaseUsageQuery;

final class MethodQueryTaskImpl
extends BaseQueryTaskImpl {
    private String _fqClassName;
    private String[] _fqParameterTypes;
    private String _methodName;
    private JavaMethod _javaMethod;

    MethodQueryTaskImpl(UsageManager usageManager, String string, String string2, String[] stringArray, MethodUsageListener methodUsageListener, URL[] uRLArray) {
        super(usageManager, methodUsageListener, uRLArray);
        this._fqClassName = string;
        this._methodName = string2;
        this._fqParameterTypes = stringArray;
    }

    MethodQueryTaskImpl(UsageManager usageManager, JavaMethod javaMethod, MethodUsageListener methodUsageListener, URL[] uRLArray) {
        super(usageManager, methodUsageListener, uRLArray);
        this._javaMethod = javaMethod;
        this._fqClassName = javaMethod.getOwningClass().getRawName();
        this._methodName = javaMethod.getName();
        Collection collection = javaMethod.getParameters();
        int n = collection.size();
        this._fqParameterTypes = new String[n];
        Iterator iterator = collection.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            JavaLocalVariable javaLocalVariable = (JavaLocalVariable)iterator.next();
            JavaType javaType = javaLocalVariable.getResolvedType();
            String string = "";
            if (javaType != null) {
                string = javaType.getRawName();
            }
            this._fqParameterTypes[n2++] = string;
        }
    }

    protected boolean isStartingDataValid() {
        if (this._fqClassName.length() >= 0 && this._methodName.length() >= 0 && this._fqParameterTypes != null) {
            int n = this._fqParameterTypes.length;
            int n2 = 0;
            while (n2 < n) {
                String string = this._fqParameterTypes[n2];
                if (string == null || string.length() == 0) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    protected String getSearchKeyword() {
        return this._methodName;
    }

    protected int[][] getKeywordLocations(ReadTextBuffer readTextBuffer) {
        JavaLexer javaLexer = new JavaLexer();
        javaLexer.setTextBuffer(readTextBuffer);
        javaLexer.setRecognizeSQLJ(true);
        javaLexer.setSkipComments(true);
        LexerToken lexerToken = javaLexer.createLexerToken();
        int[] nArray = new int[10];
        int[] nArray2 = new int[10];
        int n = 0;
        int[][] nArray3 = super.getKeywordLocations(readTextBuffer);
        int[] nArray4 = nArray3[0];
        int[] nArray5 = nArray3[1];
        int n2 = nArray4.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = nArray4[n3];
            javaLexer.setPosition(n4);
            javaLexer.lex(lexerToken);
            int n5 = javaLexer.lex(lexerToken);
            if (n5 == 55) {
                int n6 = nArray5[n3];
                nArray = this.addIntToArray(nArray, n, n4);
                nArray2 = this.addIntToArray(nArray2, n, n6);
                ++n;
            }
            ++n3;
        }
        nArray = this.trimArrayToSize(nArray, n);
        nArray2 = this.trimArrayToSize(nArray2, n);
        Arrays.sort(nArray);
        Arrays.sort(nArray2);
        return new int[][]{nArray, nArray2, nArray3[2], nArray3[3]};
    }

    protected void performUsages(SourceFile sourceFile, int[] nArray, int[] nArray2) {
        BaseUsageQuery.findMethodUsages(sourceFile, this._listener, nArray, nArray2, this._fqClassName, this._methodName, this._fqParameterTypes);
    }
}

