/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.usage;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.EventHandler;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.AbstractListModel;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.ide.model.Recognizer;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicEditorPane;
import oracle.jdeveloper.model.JavaSourceNode;
import oracle.jdeveloper.usage.UsageManager;
import oracle.jdeveloper.usage.UsageQueryTask;
import oracle.jdeveloper.usage.event.ClassUsageEvent;
import oracle.jdeveloper.usage.event.ClassUsageListener;
import oracle.jdeveloper.usage.event.ConstructorUsageEvent;
import oracle.jdeveloper.usage.event.ConstructorUsageListener;
import oracle.jdeveloper.usage.event.FieldUsageEvent;
import oracle.jdeveloper.usage.event.FieldUsageListener;
import oracle.jdeveloper.usage.event.MethodUsageEvent;
import oracle.jdeveloper.usage.event.MethodUsageListener;
import oracle.jdeveloper.usage.event.UsageEvent;
import oracle.jdeveloper.usage.util.NodeUtilities;

public class UsageFrame
extends JFrame {
    private static final String VIEW_ROOT = "/home/acyu/m/";
    private static String jdkJar = "/home/acyu/m/oracle/jdk/jre/lib/rt.jar";
    private static String clsDir = "/home/acyu/m/classes";
    private static final String SRC_ROOT = "/home/acyu/m/jdev/src/";
    private static String[] jdevSrcDirs = new String[]{"/home/acyu/m/jdev/src/common"};
    private static String srcPath = UsageFrame.strsToPath(jdevSrcDirs);
    private static String queryClassText = "oracle.javatools.data.HashStructure";
    private static String queryFieldText = "java.awt.Point int x";
    private static String queryConstructorText = "java.lang.String java.lang.String";
    private static String queryMethodText = "java.lang.String substring int";
    private JTextArea _srcRootField;
    private JTextArea _clsRootField;
    private JTextArea _jdkField;
    private JTextField _queryClassField;
    private JTextField _queryFieldField;
    private JTextField _queryConstructorField;
    private JTextField _queryMethodField;
    private JTextArea _buildFeedback;
    private static final GridBagConstraints _gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 4, 4, 4), 0, 0);
    private static final byte[] EMPTY_BUFFER = new byte[0];
    private static final boolean USE_LIST = false;

    public UsageFrame() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this._jdkField = UsageFrame.newJTextArea(jdkJar);
        this._srcRootField = UsageFrame.newJTextArea(srcPath);
        this._clsRootField = UsageFrame.newJTextArea(clsDir);
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.addTab("Sourcepath", new JScrollPane(this._srcRootField));
        jTabbedPane.addTab("Classpath", new JScrollPane(this._clsRootField));
        jTabbedPane.addTab("Library Path", new JScrollPane(this._jdkField));
        jPanel.add((Component)jTabbedPane, UsageFrame.gbc(0, 0, 3, 1, 1.0, 1.0, 17, 1));
        this._queryClassField = new JTextField(queryClassText);
        JButton jButton = new JButton("Run Class Query");
        jButton.addActionListener(UsageFrame.createActionListener(this, "startClassQuery"));
        jPanel.add((Component)new JLabel("Class Usage Search: "), UsageFrame.gbc(0, 3, 1, 1, 0.0, 0.0, 17, 0));
        jPanel.add((Component)this._queryClassField, UsageFrame.gbc(1, 3, 1, 1, 1.0, 0.0, 17, 2));
        jPanel.add((Component)jButton, UsageFrame.gbc(2, 3, 1, 1, 0.0, 0.0, 17, 0));
        this._queryFieldField = new JTextField(queryFieldText);
        JButton jButton2 = new JButton("Run Field Query");
        jButton2.addActionListener(UsageFrame.createActionListener(this, "startFieldQuery"));
        jPanel.add((Component)new JLabel("Field Usage Search: "), UsageFrame.gbc(0, 4, 1, 1, 0.0, 0.0, 17, 0));
        jPanel.add((Component)this._queryFieldField, UsageFrame.gbc(1, 4, 1, 1, 1.0, 0.0, 17, 2));
        jPanel.add((Component)jButton2, UsageFrame.gbc(2, 4, 1, 1, 0.0, 0.0, 17, 0));
        this._queryConstructorField = new JTextField(queryConstructorText);
        JButton jButton3 = new JButton("Run Constructor Query");
        jButton3.addActionListener(UsageFrame.createActionListener(this, "startConstructorQuery"));
        jPanel.add((Component)new JLabel("Constructor Usage Search: "), UsageFrame.gbc(0, 5, 1, 1, 0.0, 0.0, 17, 0));
        jPanel.add((Component)this._queryConstructorField, UsageFrame.gbc(1, 5, 1, 1, 1.0, 0.0, 17, 2));
        jPanel.add((Component)jButton3, UsageFrame.gbc(2, 5, 1, 1, 0.0, 0.0, 17, 0));
        this._queryMethodField = new JTextField(queryMethodText);
        JButton jButton4 = new JButton("Run Method Query");
        jButton4.addActionListener(UsageFrame.createActionListener(this, "startMethodQuery"));
        jPanel.add((Component)new JLabel("Method Usage Search: "), UsageFrame.gbc(0, 6, 1, 1, 0.0, 0.0, 17, 0));
        jPanel.add((Component)this._queryMethodField, UsageFrame.gbc(1, 6, 1, 1, 1.0, 0.0, 17, 2));
        jPanel.add((Component)jButton4, UsageFrame.gbc(2, 6, 1, 1, 0.0, 0.0, 17, 0));
        this._buildFeedback = new JTextArea();
        this._buildFeedback.setFont(new Font("DialogInput", 0, 12));
        JScrollPane jScrollPane = new JScrollPane(this._buildFeedback);
        jScrollPane.setVerticalScrollBarPolicy(22);
        this.startFeedbackThread();
        jPanel.add(Box.createVerticalStrut(10), UsageFrame.gbc(0, 9, 3, 1, 1.0, 0.0, 17, 0));
        jPanel.add((Component)new JLabel("Build Output:"), UsageFrame.gbc(0, 10, 3, 1, 1.0, 0.0, 17, 0));
        jPanel.add((Component)jScrollPane, UsageFrame.gbc(0, 11, 3, 1, 1.0, 1.0, 17, 1));
        this.getContentPane().add(jPanel);
    }

    private void startFeedbackThread() {
        try {
            PipedInputStream pipedInputStream = new PipedInputStream();
            PipedOutputStream pipedOutputStream = new PipedOutputStream(pipedInputStream);
            CollaterOutputStream collaterOutputStream = new CollaterOutputStream();
            PrintStream printStream = new PrintStream(collaterOutputStream, true);
            System.setOut(printStream);
            System.setErr(printStream);
            2 var5_5 = new 2(this, collaterOutputStream, pipedOutputStream);
            new Thread((Runnable)var5_5, "Collater").start();
            1 var6_6 = new 1(this, pipedInputStream);
            new Thread((Runnable)var6_6, "Pipe Redirector").start();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static String strsToPath(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(stringArray[n]).append("\n");
            ++n;
        }
        return stringBuffer.toString();
    }

    private static ActionListener createActionListener(Object object, String string) {
        return EventHandler.create(ActionListener.class, object, string);
    }

    private static GridBagConstraints gbc(int n, int n2, int n3, int n4, double d, double d2, int n5, int n6) {
        UsageFrame._gbc.gridx = n;
        UsageFrame._gbc.gridy = n2;
        UsageFrame._gbc.gridwidth = n3;
        UsageFrame._gbc.gridheight = n4;
        UsageFrame._gbc.weightx = d;
        UsageFrame._gbc.weighty = d2;
        UsageFrame._gbc.anchor = n5;
        UsageFrame._gbc.fill = n6;
        return _gbc;
    }

    private static JTextArea newJTextArea(String string) {
        JTextArea jTextArea = new JTextArea(string);
        jTextArea.setFont(new Font("Monospaced", 0, 12));
        return jTextArea;
    }

    private static URLPath extractURLPath(JTextComponent jTextComponent) {
        String string = jTextComponent.getText();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\r\n" + File.pathSeparatorChar);
        URLPath uRLPath = new URLPath();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            URL uRL = string2.endsWith(".jar") || string2.endsWith(".zip") ? URLFactory.newJarURL((File)new File(string2), (String)"") : URLFactory.newURL((String)string2);
            uRLPath.add(uRL);
        }
        return uRLPath;
    }

    public UsageManager getUsageManager() {
        URLPath uRLPath = UsageFrame.extractURLPath(this._srcRootField);
        URLPath uRLPath2 = UsageFrame.extractURLPath(this._jdkField);
        URLPath uRLPath3 = UsageFrame.extractURLPath(this._clsRootField);
        UsageManager.ProjectPath projectPath = new UsageManager.ProjectPath(uRLPath, uRLPath2, uRLPath3);
        UsageManager usageManager = new UsageManager(projectPath);
        return usageManager;
    }

    public void spawnResultFrame(ResultFrame resultFrame) {
        resultFrame.setSize(1000, 600);
        resultFrame.setDefaultCloseOperation(2);
        resultFrame.setResizable(true);
        resultFrame.setLocation(200, 200);
        resultFrame.setVisible(true);
        resultFrame.performQuery();
    }

    public void startClassQuery() {
        UsageManager usageManager = this.getUsageManager();
        String string = this._queryClassField.getText().trim();
        ResultFrame resultFrame = new ResultFrame(usageManager, string);
        resultFrame.setTitle("Class Usage Query Tester");
        this.spawnResultFrame(resultFrame);
    }

    public void startFieldQuery() {
        UsageManager usageManager = this.getUsageManager();
        String string = this._queryFieldField.getText().trim();
        int n = string.indexOf(32);
        if (n != -1) {
            String string2 = string.substring(0, n).trim();
            String string3 = string.substring(n).trim();
            if ((n = string3.indexOf(32)) != -1) {
                String string4 = string3.substring(n).trim();
                string3 = string3.substring(0, n).trim();
                ResultFrame resultFrame = new ResultFrame(usageManager, string2, string3, string4);
                resultFrame.setTitle("Field Usage Query Tester");
                this.spawnResultFrame(resultFrame);
            }
        }
    }

    public void startConstructorQuery() {
        String string;
        UsageManager usageManager = this.getUsageManager();
        String string2 = this._queryConstructorField.getText().trim();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = string2.indexOf(32);
        if (n == -1) {
            string = string2;
        } else {
            string = string2.substring(0, n).trim();
            String string3 = string2.substring(n).trim();
            while (string3.length() > 0) {
                String string4;
                String string5;
                n = string3.indexOf(32);
                if (n == -1) {
                    string5 = string3;
                    string4 = "";
                } else {
                    string5 = string3.substring(0, n).trim();
                    string4 = string3.substring(n).trim();
                }
                arrayList.add(string5);
                string3 = string4;
            }
        }
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        ResultFrame resultFrame = new ResultFrame(usageManager, string, stringArray);
        resultFrame.setTitle("Constructor Usage Query Tester");
        this.spawnResultFrame(resultFrame);
    }

    public void startMethodQuery() {
        UsageManager usageManager = this.getUsageManager();
        String string = this._queryMethodField.getText().trim();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = string.indexOf(32);
        if (n != -1) {
            String string2;
            String string3 = string.substring(0, n).trim();
            String string4 = string.substring(n).trim();
            if ((n = string4.indexOf(32)) == -1) {
                string2 = string4;
            } else {
                string2 = string4.substring(0, n).trim();
                String string5 = string4.substring(n).trim();
                while (string5.length() > 0) {
                    String string6;
                    String string7;
                    n = string5.indexOf(32);
                    if (n == -1) {
                        string7 = string5;
                        string6 = "";
                    } else {
                        string7 = string5.substring(0, n).trim();
                        string6 = string5.substring(n).trim();
                    }
                    arrayList.add(string7);
                    string5 = string6;
                }
            }
            String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
            ResultFrame resultFrame = new ResultFrame(usageManager, string3, string2, stringArray);
            resultFrame.setTitle("Method Usage Query Tester");
            this.spawnResultFrame(resultFrame);
        }
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (Exception exception) {
            System.err.println("Could not load system look-and-feel: " + exception);
        }
        System.setProperty("ENABLE_BFLIBRARIAN", Boolean.toString(true));
        Recognizer.mapExtensionToClass((String)".java", JavaSourceNode.class);
        Recognizer.mapExtensionToClass((String)".sqlj", JavaSourceNode.class);
        UsageFrame usageFrame = new UsageFrame();
        usageFrame.setSize(800, 600);
        usageFrame.setDefaultCloseOperation(3);
        usageFrame.setResizable(true);
        usageFrame.setTitle("Usage Engine Tester");
        usageFrame.setLocation(100, 100);
        usageFrame.setVisible(true);
        usageFrame._queryClassField.requestFocus();
        usageFrame._queryClassField.selectAll();
    }

    private static void sleep(long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    private static String usageCodeToString(int n) {
        switch (n) {
            case 101: {
                return "import";
            }
            case 102: {
                return "class decl";
            }
            case 103: {
                return "extends";
            }
            case 104: {
                return "implements";
            }
            case 105: {
                return "return type";
            }
            case 106: {
                return "param type";
            }
            case 107: {
                return "throws type";
            }
            case 108: {
                return "field type";
            }
            case 109: {
                return "local variable type";
            }
            case 110: {
                return "static type";
            }
            case 111: {
                return "typecast";
            }
            case 112: {
                return "new";
            }
            case 113: {
                return "instanceof";
            }
            case 301: {
                return "ctor decl";
            }
            case 302: {
                return "ctor this";
            }
            case 303: {
                return "ctor super";
            }
            case 304: {
                return "ctor new";
            }
            case 201: {
                return "field decl";
            }
            case 202: {
                return "field access";
            }
            case 401: {
                return "method decl";
            }
            case 402: {
                return "method call";
            }
        }
        return "unknown (" + n + ")";
    }

    static void maS$sleep(long l) {
        UsageFrame.sleep(l);
    }

    static JTextArea ra$_buildFeedback(UsageFrame usageFrame) {
        return usageFrame._buildFeedback;
    }

    static byte[] ra$EMPTY_BUFFER() {
        return EMPTY_BUFFER;
    }

    static ActionListener maS$createActionListener(Object object, String string) {
        return UsageFrame.createActionListener(object, string);
    }

    static GridBagConstraints maS$gbc(int n, int n2, int n3, int n4, double d, double d2, int n5, int n6) {
        return UsageFrame.gbc(n, n2, n3, n4, d, d2, n5, n6);
    }

    static String maS$usageCodeToString(int n) {
        return UsageFrame.usageCodeToString(n);
    }

    public final class 2
    implements Runnable {
        private final /* synthetic */ CollaterOutputStream v$collaterOS;
        private final /* synthetic */ PipedOutputStream v$outPipe;
        final /* synthetic */ UsageFrame this$0;

        public void run() {
            while (true) {
                UsageFrame.maS$sleep(100);
                byte[] byArray = this.v$collaterOS.getFlushedData();
                if (byArray.length <= 0) continue;
                try {
                    this.v$outPipe.write(byArray);
                    continue;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    continue;
                }
                break;
            }
        }

        public 2(UsageFrame usageFrame, CollaterOutputStream collaterOutputStream, PipedOutputStream pipedOutputStream) {
            this.v$outPipe = pipedOutputStream;
            this.v$collaterOS = collaterOutputStream;
            this.this$0 = usageFrame;
        }
    }

    public final class 1
    implements Runnable {
        private final /* synthetic */ PipedInputStream v$inPipe;
        final /* synthetic */ UsageFrame this$0;

        public void run() {
            InputStreamReader inputStreamReader = new InputStreamReader(this.v$inPipe);
            char[] cArray = new char[1024];
            while (true) {
                try {
                    int n = inputStreamReader.read(cArray, 0, 1024);
                    if (n == -1) break;
                    String string = new String(cArray, 0, n);
                    UsageFrame.ra$_buildFeedback(this.this$0).append(string);
                    int n2 = UsageFrame.ra$_buildFeedback(this.this$0).getLineCount();
                    int n3 = UsageFrame.ra$_buildFeedback(this.this$0).getLineStartOffset(n2 - 1);
                    UsageFrame.ra$_buildFeedback(this.this$0).setCaretPosition(n3);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }
        }

        public 1(UsageFrame usageFrame, PipedInputStream pipedInputStream) {
            this.v$inPipe = pipedInputStream;
            this.this$0 = usageFrame;
        }
    }

    private static final class CollaterOutputStream
    extends OutputStream {
        private ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        private ByteArrayOutputStream unflushed = new ByteArrayOutputStream();

        public synchronized void write(int n) {
            this.unflushed.write(n);
        }

        public synchronized void flush() throws IOException {
            byte[] byArray = this.unflushed.toByteArray();
            this.unflushed.reset();
            this.buffer.write(byArray);
        }

        public synchronized byte[] getFlushedData() {
            if (this.buffer.size() > 0) {
                byte[] byArray = this.buffer.toByteArray();
                this.buffer.reset();
                return byArray;
            }
            return UsageFrame.ra$EMPTY_BUFFER();
        }

        public void close() throws IOException {
        }
    }

    private static class ResultObject {
        protected UsageEvent _event;

        public ResultObject(UsageEvent usageEvent) {
            this._event = usageEvent;
        }

        public String toString() {
            URL uRL = this._event.getURL();
            String string = URLFileSystem.getFileName((URL)uRL);
            int n = this._event.getStartOffset();
            int n2 = this._event.getEndOffset();
            return string + " " + n + "/" + n2 + " " + this._event.toString();
        }
    }

    private static class ResultFrame
    extends JFrame
    implements TreeSelectionListener,
    ListSelectionListener {
        private JButton _cancelButton;
        private JProgressBar _queryProgress;
        private JLabel _queryProgressLabel;
        private int[] _usageCounters;
        private CategoryList _categoryList;
        private UsageCounter[] _lastSelectedCategories;
        private final ResultGUI _resultGUI;
        private JLabel _lblUsageResults;
        private JTextArea _lblFileContents;
        private BasicEditorPane _resultPane;
        private Timer _queryTimer;
        private boolean _cancelRequested;
        private UsageManager _usageManager;
        private String _queryClassText;
        private String _queryFieldClassText;
        private String _queryFieldTypeText;
        private String _queryFieldNameText;
        private String _queryConstructorClassText;
        private String[] _queryConstructorParameterTypesText;
        private String _queryMethodClassText;
        private String _queryMethodNameText;
        private String[] _queryMethodParameterTypesText;

        void $init$() {
            this._categoryList = new CategoryList();
            this._cancelRequested = false;
        }

        public ResultFrame(UsageManager usageManager, String string) {
            this(usageManager);
            this._queryClassText = string;
        }

        public ResultFrame(UsageManager usageManager, String string, String string2, String string3) {
            this(usageManager);
            this._queryFieldClassText = string;
            this._queryFieldTypeText = string2;
            this._queryFieldNameText = string3;
        }

        public ResultFrame(UsageManager usageManager, String string, String[] stringArray) {
            this(usageManager);
            this._queryConstructorClassText = string;
            this._queryConstructorParameterTypesText = stringArray;
        }

        public ResultFrame(UsageManager usageManager, String string, String string2, String[] stringArray) {
            this(usageManager);
            this._queryMethodClassText = string;
            this._queryMethodNameText = string2;
            this._queryMethodParameterTypesText = stringArray;
        }

        public ResultFrame(UsageManager usageManager) {
            this.$init$();
            this._usageManager = usageManager;
            8 var2_2 = new 8();
            this._queryTimer = new Timer(200, var2_2);
            this._queryTimer.setRepeats(false);
            this._queryTimer.setCoalesce(true);
            JPanel jPanel = new JPanel(new GridBagLayout());
            this._cancelButton = new JButton("Cancel Query");
            this._cancelButton.setEnabled(false);
            this._cancelButton.addActionListener(UsageFrame.maS$createActionListener(this, "cancelQuery"));
            this._queryProgress = new JProgressBar(0, 0, 100);
            this._queryProgress.setValue(0);
            this._queryProgressLabel = new JLabel("Initializing...");
            jPanel.add((Component)this._cancelButton, UsageFrame.maS$gbc(0, 0, 1, 1, 0.0, 0.0, 17, 0));
            jPanel.add((Component)this._queryProgress, UsageFrame.maS$gbc(1, 0, 1, 1, 1.0, 0.0, 17, 2));
            jPanel.add((Component)this._queryProgressLabel, UsageFrame.maS$gbc(1, 1, 1, 1, 1.0, 0.0, 17, 2));
            JPanel jPanel2 = new JPanel(new GridBagLayout());
            this._categoryList.addListSelectionListener(this);
            jPanel2.add((Component)new JLabel("Usage Categories:"), UsageFrame.maS$gbc(0, 0, 1, 1, 0.0, 0.0, 17, 0));
            jPanel2.add((Component)new JScrollPane(this._categoryList), UsageFrame.maS$gbc(0, 1, 1, 1, 1.0, 1.0, 17, 1));
            JPanel jPanel3 = new JPanel(new GridBagLayout());
            ResultTree resultTree = new ResultTree();
            JTree jTree = resultTree.getGUI();
            jTree.addTreeSelectionListener(this);
            JTree jTree2 = jTree;
            this._resultGUI = resultTree;
            this._lblUsageResults = new JLabel();
            jPanel3.add((Component)this._lblUsageResults, UsageFrame.maS$gbc(0, 0, 1, 1, 1.0, 0.0, 17, 0));
            jPanel3.add((Component)new JScrollPane(jTree2), UsageFrame.maS$gbc(0, 1, 1, 1, 1.0, 1.0, 17, 1));
            JSplitPane jSplitPane = new JSplitPane();
            jSplitPane.setOrientation(1);
            jSplitPane.setLeftComponent(jPanel2);
            jSplitPane.setRightComponent(jPanel3);
            jSplitPane.setResizeWeight(0.0);
            jSplitPane.setDividerLocation(160);
            jSplitPane.setDividerSize(5);
            JSplitPane jSplitPane2 = jSplitPane;
            JPanel jPanel4 = new JPanel(new GridBagLayout());
            this._resultPane = new BasicEditorPane();
            this._resultPane.setProtected(true);
            this._resultPane.setLanguageSupport("foo.java");
            JScrollPane jScrollPane = new JScrollPane((Component)this._resultPane);
            jScrollPane.setVerticalScrollBarPolicy(22);
            jScrollPane.setHorizontalScrollBarPolicy(32);
            this._lblFileContents = new JTextArea("File Contents");
            this._lblFileContents.setFont(new JLabel().getFont());
            this._lblFileContents.setEditable(false);
            this._lblFileContents.setBackground(jPanel4.getBackground());
            jPanel4.add((Component)this._lblFileContents, UsageFrame.maS$gbc(0, 0, 1, 1, 1.0, 0.0, 17, 0));
            jPanel4.add((Component)jScrollPane, UsageFrame.maS$gbc(0, 1, 1, 1, 1.0, 1.0, 17, 1));
            JSplitPane jSplitPane3 = new JSplitPane();
            jSplitPane3.setLeftComponent(jSplitPane2);
            jSplitPane3.setRightComponent(jPanel4);
            jSplitPane3.setResizeWeight(0.0);
            jSplitPane3.setDividerLocation(400);
            jSplitPane3.setDividerSize(10);
            jPanel.add(Box.createVerticalStrut(5), UsageFrame.maS$gbc(0, 2, 1, 1, 0.0, 0.0, 17, 0));
            jPanel.add((Component)jSplitPane3, UsageFrame.maS$gbc(0, 5, 2, 1, 1.0, 1.0, 17, 1));
            this.getContentPane().add(jPanel);
        }

        private void timerFired() {
            ResultObject resultObject = this._resultGUI.getSelectedResultObject();
            if (resultObject != null) {
                boolean bl;
                UsageEvent usageEvent = resultObject._event;
                this._lblFileContents.setText(URLFileSystem.getPlatformPathName((URL)usageEvent.getURL()));
                URL uRL = usageEvent.getURL();
                URL uRL2 = (URL)this._resultPane.getClientProperty((Object)"URL");
                boolean bl2 = bl = uRL2 == null || !uRL2.equals(uRL);
                if (bl) {
                    this._resultPane.setProtected(false);
                    this._resultPane.setText("// Loading file...");
                    this._resultPane.setProtected(true);
                    this._resultPane.putClientProperty((Object)"URL", (Object)uRL);
                }
                int n = usageEvent.getStartOffset();
                int n2 = usageEvent.getEndOffset();
                int n3 = n;
                int n4 = n2 - n;
                7 var10_10 = new 7(this, usageEvent, bl, n3, n4);
                Thread thread = new Thread(var10_10);
                thread.start();
            } else {
                this._resultPane.setText("");
            }
        }

        private void cancelQuery() {
            this._cancelRequested = true;
        }

        public void performQuery() {
            this._queryTimer.stop();
            this.clearResults();
            this._queryProgress.setValue(0);
            this._cancelRequested = false;
            this._cancelButton.setEnabled(true);
            long l = System.currentTimeMillis();
            6 var3_2 = new 6(this, l);
            5 var4_3 = new 5(this, var3_2);
            4 var5_4 = new 4(this, var3_2);
            3 var6_5 = new 3(this, var3_2);
            2 var7_6 = new 2(this, var3_2);
            this._queryProgress.setValue(0);
            UsageQueryTask usageQueryTask = this._queryClassText != null ? this._usageManager.findClassUsages(this._queryClassText, var4_3) : (this._queryFieldClassText != null ? this._usageManager.findFieldUsages(this._queryFieldClassText, this._queryFieldTypeText, this._queryFieldNameText, var5_4) : (this._queryConstructorClassText != null ? this._usageManager.findConstructorUsages(this._queryConstructorClassText, this._queryConstructorParameterTypesText, var6_5) : (this._queryMethodClassText != null ? this._usageManager.findMethodUsages(this._queryMethodClassText, this._queryMethodNameText, this._queryMethodParameterTypesText, var7_6) : null)));
            if (usageQueryTask != null) {
                1 var9_8 = new 1(this, usageQueryTask);
                Thread thread = new Thread(var9_8);
                thread.setPriority(1);
                thread.start();
            }
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            Object object = listSelectionEvent.getSource();
            if (object == this._categoryList) {
                int n;
                Object[] objectArray = this._categoryList.getSelectedValues();
                int n2 = n = objectArray != null ? objectArray.length : 0;
                if (this._lastSelectedCategories != null && this._lastSelectedCategories.length == n) {
                    boolean bl = true;
                    List<Object> list = Arrays.asList(objectArray);
                    int n3 = 0;
                    while (n3 < n) {
                        if (!list.contains(this._lastSelectedCategories[n3])) {
                            bl = false;
                            break;
                        }
                        ++n3;
                    }
                    if (bl) {
                        return;
                    }
                }
                UsageCounter[] usageCounterArray = new UsageCounter[n];
                System.arraycopy(objectArray, 0, usageCounterArray, 0, n);
                this._lastSelectedCategories = usageCounterArray;
                this._resultGUI.updateSelectedCategories(usageCounterArray);
            } else {
                this._queryTimer.restart();
            }
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            this._queryTimer.restart();
        }

        private void reportResult(UsageEvent usageEvent) {
            this.reportResult(new ResultObject(usageEvent));
        }

        private void reportResult(ResultObject resultObject) {
            UsageEvent usageEvent = resultObject._event;
            this._resultGUI.reportResult(resultObject);
            this.incUsageCounter(usageEvent.getUsageCode());
        }

        private void incUsageCounter(int n) {
            if (this._usageCounters != null) {
                int n2 = this._usageCounters.length;
                int n3 = 0;
                while (n3 < n2) {
                    if (n == this._usageCounters[n3]) {
                        int n4 = n3 + 1;
                        this._usageCounters[n4] = this._usageCounters[n4] + 1;
                        return;
                    }
                    n3 += 2;
                }
                int[] nArray = new int[n2 + 2];
                System.arraycopy(this._usageCounters, 0, nArray, 0, n2);
                nArray[n2] = n;
                nArray[n2 + 1] = 1;
                this._usageCounters = nArray;
            } else {
                this._usageCounters = new int[]{n, 1};
            }
        }

        private void clearResults() {
            this._lblUsageResults.setText("Usage Results:");
            this._categoryList.clearResults();
            this._resultGUI.clearResults();
        }

        private int numResults() {
            return this._resultGUI.numResults();
        }

        static void mav$timerFired(ResultFrame resultFrame) {
            resultFrame.timerFired();
        }

        static BasicEditorPane ra$_resultPane(ResultFrame resultFrame) {
            return resultFrame._resultPane;
        }

        static JProgressBar ra$_queryProgress(ResultFrame resultFrame) {
            return resultFrame._queryProgress;
        }

        static JButton ra$_cancelButton(ResultFrame resultFrame) {
            return resultFrame._cancelButton;
        }

        static boolean ra$_cancelRequested(ResultFrame resultFrame) {
            return resultFrame._cancelRequested;
        }

        static int mav$numResults(ResultFrame resultFrame) {
            return resultFrame.numResults();
        }

        static JLabel ra$_lblUsageResults(ResultFrame resultFrame) {
            return resultFrame._lblUsageResults;
        }

        static CategoryList ra$_categoryList(ResultFrame resultFrame) {
            return resultFrame._categoryList;
        }

        static int[] ra$_usageCounters(ResultFrame resultFrame) {
            return resultFrame._usageCounters;
        }

        static void mav$reportResult(ResultFrame resultFrame, UsageEvent usageEvent) {
            resultFrame.reportResult(usageEvent);
        }

        static JLabel ra$_queryProgressLabel(ResultFrame resultFrame) {
            return resultFrame._queryProgressLabel;
        }

        public final class 8
        implements ActionListener {
            public void actionPerformed(ActionEvent actionEvent) {
                ResultFrame.mav$timerFired(ResultFrame.this);
            }
        }

        public final class 7
        implements Runnable {
            private final /* synthetic */ UsageEvent v$event;
            private final /* synthetic */ boolean v$mustRefreshContents;
            private final /* synthetic */ int v$offset;
            private final /* synthetic */ int v$length;
            final /* synthetic */ ResultFrame this$0;

            public void run() {
                TextBuffer textBuffer = NodeUtilities.getTextBufferFor(this.v$event.getURL());
                1 var2_2 = new 1(this, textBuffer);
                SwingUtilities.invokeLater(var2_2);
            }

            public 7(ResultFrame resultFrame, UsageEvent usageEvent, boolean bl, int n, int n2) {
                this.v$length = n2;
                this.v$offset = n;
                this.v$mustRefreshContents = bl;
                this.v$event = usageEvent;
                this.this$0 = resultFrame;
            }

            static boolean ra$v$mustRefreshContents(7 var0) {
                return var0.v$mustRefreshContents;
            }

            static int ra$v$offset(7 var0) {
                return var0.v$offset;
            }

            static int ra$v$length(7 var0) {
                return var0.v$length;
            }

            public final class 1
            implements Runnable {
                private final /* synthetic */ TextBuffer v$textBuffer;
                final /* synthetic */ 7 this$0;

                public void run() {
                    if (7.ra$v$mustRefreshContents(this.this$0)) {
                        String string = this.v$textBuffer.getString(0, this.v$textBuffer.getLength());
                        ResultFrame.ra$_resultPane(this.this$0.this$0).setProtected(false);
                        ResultFrame.ra$_resultPane(this.this$0.this$0).setText(string);
                        ResultFrame.ra$_resultPane(this.this$0.this$0).setProtected(true);
                    }
                    ResultFrame.ra$_resultPane(this.this$0.this$0).setCaretPositionCenter(7.ra$v$offset(this.this$0));
                    ResultFrame.ra$_resultPane(this.this$0.this$0).moveCaretPositionCenter(7.ra$v$offset(this.this$0) + 7.ra$v$length(this.this$0));
                }

                public 1(7 var1_1, TextBuffer textBuffer) {
                    this.v$textBuffer = textBuffer;
                    this.this$0 = var1_1;
                }
            }
        }

        public final class 6
        implements Runnable {
            private final /* synthetic */ long v$startTime;
            final /* synthetic */ ResultFrame this$0;

            public void run() {
                ResultFrame.ra$_queryProgress(this.this$0).setValue(0);
                ResultFrame.ra$_cancelButton(this.this$0).setEnabled(false);
                if (ResultFrame.ra$_cancelRequested(this.this$0)) {
                    System.out.println("Query was canceled");
                } else {
                    int n = ResultFrame.mav$numResults(this.this$0);
                    ResultFrame.ra$_lblUsageResults(this.this$0).setText("Usage Results (" + n + "):");
                    ResultFrame.ra$_categoryList(this.this$0).reportCategories(ResultFrame.ra$_usageCounters(this.this$0));
                    long l = System.currentTimeMillis() - this.v$startTime;
                    System.out.println("Query time (ms): " + l);
                    System.out.println("Query occurrences found: " + n);
                }
                System.out.println();
            }

            public 6(ResultFrame resultFrame, long l) {
                this.v$startTime = l;
                this.this$0 = resultFrame;
            }
        }

        public final class 5
        implements ClassUsageListener {
            private final /* synthetic */ Runnable v$finishedRunnable;
            final /* synthetic */ ResultFrame this$0;

            public void notifyClassUsage(ClassUsageEvent classUsageEvent) {
                ResultFrame.mav$reportResult(this.this$0, classUsageEvent);
            }

            public void notifyFinished(UsageEvent usageEvent) {
                SwingUtilities.invokeLater(this.v$finishedRunnable);
            }

            public void notifySkipped(UsageEvent usageEvent) {
            }

            public 5(ResultFrame resultFrame, Runnable runnable) {
                this.v$finishedRunnable = runnable;
                this.this$0 = resultFrame;
            }
        }

        public final class 4
        implements FieldUsageListener {
            private final /* synthetic */ Runnable v$finishedRunnable;
            final /* synthetic */ ResultFrame this$0;

            public void notifyFieldUsage(FieldUsageEvent fieldUsageEvent) {
                ResultFrame.mav$reportResult(this.this$0, fieldUsageEvent);
            }

            public void notifyFinished(UsageEvent usageEvent) {
                SwingUtilities.invokeLater(this.v$finishedRunnable);
            }

            public void notifySkipped(UsageEvent usageEvent) {
            }

            public 4(ResultFrame resultFrame, Runnable runnable) {
                this.v$finishedRunnable = runnable;
                this.this$0 = resultFrame;
            }
        }

        public final class 3
        implements ConstructorUsageListener {
            private final /* synthetic */ Runnable v$finishedRunnable;
            final /* synthetic */ ResultFrame this$0;

            public void notifyConstructorUsage(ConstructorUsageEvent constructorUsageEvent) {
                ResultFrame.mav$reportResult(this.this$0, constructorUsageEvent);
            }

            public void notifyFinished(UsageEvent usageEvent) {
                SwingUtilities.invokeLater(this.v$finishedRunnable);
            }

            public void notifySkipped(UsageEvent usageEvent) {
            }

            public 3(ResultFrame resultFrame, Runnable runnable) {
                this.v$finishedRunnable = runnable;
                this.this$0 = resultFrame;
            }
        }

        public final class 2
        implements MethodUsageListener {
            private final /* synthetic */ Runnable v$finishedRunnable;
            final /* synthetic */ ResultFrame this$0;

            public void notifyMethodUsage(MethodUsageEvent methodUsageEvent) {
                ResultFrame.mav$reportResult(this.this$0, methodUsageEvent);
            }

            public void notifyFinished(UsageEvent usageEvent) {
                SwingUtilities.invokeLater(this.v$finishedRunnable);
            }

            public void notifySkipped(UsageEvent usageEvent) {
            }

            public 2(ResultFrame resultFrame, Runnable runnable) {
                this.v$finishedRunnable = runnable;
                this.this$0 = resultFrame;
            }
        }

        public final class 1
        implements Runnable {
            private final /* synthetic */ UsageQueryTask v$queryTask;
            final /* synthetic */ ResultFrame this$0;

            public void run() {
                while (!this.v$queryTask.isFinished()) {
                    UsageFrame.maS$sleep(100);
                    int n = this.v$queryTask.getProgress();
                    String string = this.v$queryTask.getProgressText();
                    ResultFrame.ra$_queryProgress(this.this$0).setValue(n);
                    ResultFrame.ra$_queryProgressLabel(this.this$0).setText(string);
                    if (!ResultFrame.ra$_cancelRequested(this.this$0)) continue;
                    this.v$queryTask.cancel();
                }
            }

            public 1(ResultFrame resultFrame, UsageQueryTask usageQueryTask) {
                this.v$queryTask = usageQueryTask;
                this.this$0 = resultFrame;
            }
        }
    }

    private static final class UsageCounter {
        private final int _usageCode;
        private final int _count;

        UsageCounter(int n, int n2) {
            this._usageCode = n;
            this._count = n2;
        }

        int getUsageCode() {
            return this._usageCode;
        }

        int getCount() {
            return this._count;
        }

        public String toString() {
            return this._count + " " + UsageFrame.maS$usageCodeToString(this._usageCode);
        }
    }

    private static final class CategoryList
    extends JList {
        private final DefaultListModel _model;

        void $init$() {
            this._model = new DefaultListModel();
        }

        CategoryList() {
            this.$init$();
            this.setModel(this._model);
            this.setSelectionMode(2);
        }

        void clearResults() {
            this._model.clear();
        }

        void reportCategories(int[] nArray) {
            this.setValueIsAdjusting(true);
            try {
                if (nArray != null) {
                    int n = nArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int n3 = nArray[n2++];
                        int n4 = nArray[n2];
                        this._model.addElement(new UsageCounter(n3, n4));
                        ++n2;
                    }
                }
            }
            finally {
                this.setValueIsAdjusting(false);
            }
        }
    }

    private static abstract class ResultGUI {
        private UsageCounter[] _selectedCategories;

        abstract void reportResult(ResultObject var1);

        abstract int numResults();

        abstract void clearResults();

        abstract ResultObject getSelectedResultObject();

        void updateSelectedCategories(UsageCounter[] usageCounterArray) {
            this._selectedCategories = usageCounterArray;
        }

        final boolean isSelectedCategory(ResultObject resultObject) {
            if (this._selectedCategories == null || this._selectedCategories.length == 0) {
                return true;
            }
            int n = resultObject._event.getUsageCode();
            int n2 = this._selectedCategories.length;
            int n3 = 0;
            while (n3 < n2) {
                UsageCounter usageCounter = this._selectedCategories[n3];
                if (usageCounter.getUsageCode() == n) {
                    return true;
                }
                ++n3;
            }
            return false;
        }

        private ResultGUI() {
        }

        ResultGUI(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static final class ResultList
    extends ResultGUI {
        private final ArrayList _dataItems;
        private final ArrayList _listItems;
        private final ResultListModel _model;
        private final JList _jlist;

        void $init$() {
            this._dataItems = new ArrayList();
            this._listItems = new ArrayList();
            this._model = new ResultListModel(this._listItems);
            this._jlist = new JList(this._model);
        }

        JList getGUI() {
            return this._jlist;
        }

        void reportResult(ResultObject resultObject) {
            this._dataItems.add(resultObject);
            int n = this._listItems.size();
            this._listItems.add(resultObject);
            this._model.fireIntervalAdded(this, n, n);
        }

        int numResults() {
            return this._model.getSize();
        }

        void clearResults() {
            int n = this._model.getSize();
            this._dataItems.clear();
            this._listItems.clear();
            if (n > 0) {
                this._model.fireIntervalRemoved(this, 0, n - 1);
            }
        }

        ResultObject getSelectedResultObject() {
            Object e = this._jlist.getSelectedValue();
            return e instanceof ResultObject ? (ResultObject)e : null;
        }

        void updateSelectedCategories(UsageCounter[] usageCounterArray) {
            super.updateSelectedCategories(usageCounterArray);
            int n = this._model.getSize();
            this._listItems.clear();
            if (n > 0) {
                this._model.fireIntervalRemoved(this, 0, n - 1);
            }
            for (ResultObject resultObject : this._dataItems) {
                if (!this.isSelectedCategory(resultObject)) continue;
                this._listItems.add(resultObject);
            }
            int n2 = this._listItems.size();
            if (n2 > 0) {
                this._model.fireIntervalAdded(this, 0, n2 - 1);
            }
        }

        private ResultList() {
            super(null);
            this.$init$();
        }

        private static final class ResultListModel
        extends AbstractListModel {
            private final ArrayList _storage;

            ResultListModel(ArrayList arrayList) {
                this._storage = arrayList;
            }

            public int getSize() {
                return this._storage.size();
            }

            public Object getElementAt(int n) {
                return this._storage.get(n);
            }

            protected void fireIntervalAdded(Object object, int n, int n2) {
                super.fireIntervalAdded(object, n, n2);
            }

            protected void fireContentsChanged(Object object, int n, int n2) {
                super.fireContentsChanged(object, n, n2);
            }

            protected void fireIntervalRemoved(Object object, int n, int n2) {
                super.fireIntervalRemoved(object, n, n2);
            }
        }
    }

    private static final class ResultTree
    extends ResultGUI {
        private final DMTNRoot _root;
        private final DefaultTreeModel _model;
        private final JTree _jtree;

        void $init$() {
            this._root = new DMTNRoot();
            this._model = new DefaultTreeModel(this._root);
            this._jtree = new JTree(this._model);
        }

        ResultTree() {
            super(null);
            this.$init$();
            ToolTipManager.sharedInstance().registerComponent(this._jtree);
            this._jtree.setCellRenderer(new TCR(null));
            DefaultTreeSelectionModel defaultTreeSelectionModel = new DefaultTreeSelectionModel();
            defaultTreeSelectionModel.setSelectionMode(1);
            this._jtree.setSelectionModel(defaultTreeSelectionModel);
            this._jtree.setRootVisible(false);
            this._jtree.setShowsRootHandles(true);
        }

        JTree getGUI() {
            return this._jtree;
        }

        void reportResult(ResultObject resultObject) {
            this._root.reportResult(resultObject);
        }

        int numResults() {
            Enumeration enumeration = this._root.children();
            int n = 0;
            while (enumeration.hasMoreElements()) {
                DMTNFile dMTNFile = (DMTNFile)enumeration.nextElement();
                n += dMTNFile.getChildCount();
            }
            return n;
        }

        void clearResults() {
            this._root.clearResults();
            this._model.nodeStructureChanged(this._root);
        }

        ResultObject getSelectedResultObject() {
            TreePath treePath = this._jtree.getSelectionPath();
            if (treePath != null) {
                Object object = treePath.getLastPathComponent();
                if (object instanceof DMTNFile) {
                    DMTNFile dMTNFile = (DMTNFile)object;
                    return new ResultObject(new UsageEvent(null, 0, dMTNFile.getURL(), 0, 0));
                }
                if (object instanceof DMTNUsage) {
                    DMTNUsage dMTNUsage = (DMTNUsage)object;
                    return dMTNUsage.getResultObject();
                }
            }
            return null;
        }

        void updateSelectedCategories(UsageCounter[] usageCounterArray) {
            super.updateSelectedCategories(usageCounterArray);
            this._root.refreshChildNodes();
            this._model.nodeStructureChanged(this._root);
        }

        static DefaultTreeModel ra$_model(ResultTree resultTree) {
            return resultTree._model;
        }

        static JTree ra$_jtree(ResultTree resultTree) {
            return resultTree._jtree;
        }

        static DMTNRoot ra$_root(ResultTree resultTree) {
            return resultTree._root;
        }

        private abstract class ReportNode
        implements TreeNode {
            final ReportNode _parent;
            final ArrayList _dataChildren;
            final ArrayList _nodeChildren;

            void $init$() {
                this._dataChildren = new ArrayList();
                this._nodeChildren = new ArrayList();
            }

            ReportNode(ReportNode reportNode) {
                this.$init$();
                this._parent = reportNode;
            }

            abstract void reportResult(ResultObject var1);

            abstract void refreshChildNodes();

            public Enumeration children() {
                return Collections.enumeration(this._nodeChildren);
            }

            public boolean getAllowsChildren() {
                return true;
            }

            public TreeNode getChildAt(int n) {
                return (TreeNode)this._nodeChildren.get(n);
            }

            public int getChildCount() {
                return this._nodeChildren.size();
            }

            public int getIndex(TreeNode treeNode) {
                return this._nodeChildren.indexOf(treeNode);
            }

            public TreeNode getParent() {
                return this._parent;
            }

            public boolean isLeaf() {
                return this.getChildCount() <= 0;
            }
        }

        private final class DMTNRoot
        extends ReportNode {
            DMTNRoot() {
                super(null);
            }

            void clearResults() {
                this._dataChildren.clear();
                this._nodeChildren.clear();
            }

            void refreshChildNodes() {
                this._nodeChildren.clear();
                for (DMTNFile dMTNFile : this._dataChildren) {
                    dMTNFile.refreshChildNodes();
                    if (dMTNFile.isLeaf()) continue;
                    this._nodeChildren.add(dMTNFile);
                }
            }

            void reportResult(ResultObject resultObject) {
                UsageEvent usageEvent = resultObject._event;
                URL uRL = usageEvent.getURL();
                DMTNFile dMTNFile = this.findOrCreateFileNode(uRL);
                dMTNFile.reportResult(resultObject);
            }

            private DMTNFile findOrCreateFileNode(URL uRL) {
                DMTNFile dMTNFile = this.findFileNode(uRL);
                return dMTNFile != null ? dMTNFile : this.createFileNode(uRL);
            }

            private DMTNFile findFileNode(URL uRL) {
                Enumeration enumeration = this.children();
                while (enumeration.hasMoreElements()) {
                    DMTNFile dMTNFile = (DMTNFile)enumeration.nextElement();
                    if (!dMTNFile.getURL().equals(uRL)) continue;
                    return dMTNFile;
                }
                return null;
            }

            private DMTNFile createFileNode(URL uRL) {
                int n = this.getChildCount();
                DMTNFile dMTNFile = new DMTNFile(uRL);
                this._dataChildren.add(dMTNFile);
                this._nodeChildren.add(dMTNFile);
                ResultTree.ra$_model(ResultTree.this).nodesWereInserted(this, new int[]{n});
                if (n == 0) {
                    TreePath treePath = new TreePath(this);
                    ResultTree.ra$_jtree(ResultTree.this).expandPath(treePath);
                }
                return dMTNFile;
            }
        }

        private final class DMTNFile
        extends ReportNode {
            private final URL _url;
            private final String _displayName;

            DMTNFile(URL uRL) {
                super(ResultTree.ra$_root(ResultTree.this));
                this._url = uRL;
                this._displayName = URLFileSystem.getFileName((URL)uRL);
            }

            URL getURL() {
                return this._url;
            }

            void reportResult(ResultObject resultObject) {
                int n = this.getChildCount();
                DMTNUsage dMTNUsage = new DMTNUsage(this, resultObject);
                this._dataChildren.add(dMTNUsage);
                this._nodeChildren.add(dMTNUsage);
                ResultTree.ra$_model(ResultTree.this).nodesWereInserted(this, new int[]{n});
                ResultTree.ra$_model(ResultTree.this).nodeChanged(this);
            }

            void refreshChildNodes() {
                this._nodeChildren.clear();
                for (DMTNUsage dMTNUsage : this._dataChildren) {
                    if (!ResultTree.this.isSelectedCategory(dMTNUsage.getResultObject())) continue;
                    this._nodeChildren.add(dMTNUsage);
                }
            }

            public String toString() {
                return this._displayName + " (" + this.getChildCount() + ")";
            }
        }

        private final class DMTNUsage
        extends ReportNode {
            private final ResultObject _usageInfo;
            private final String _displayName;

            DMTNUsage(DMTNFile dMTNFile, ResultObject resultObject) {
                super(dMTNFile);
                this._usageInfo = resultObject;
                UsageEvent usageEvent = resultObject._event;
                this._displayName = usageEvent.getStartOffset() + "-" + usageEvent.getEndOffset() + ": " + UsageFrame.maS$usageCodeToString(usageEvent.getUsageCode());
            }

            void reportResult(ResultObject resultObject) {
            }

            void refreshChildNodes() {
            }

            ResultObject getResultObject() {
                return this._usageInfo;
            }

            public String toString() {
                return this._displayName;
            }

            public boolean getAllowsChildren() {
                return false;
            }

            public boolean isLeaf() {
                return true;
            }
        }

        private static final class TCR
        extends DefaultTreeCellRenderer {
            public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
                JLabel jLabel = (JLabel)super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
                if (object instanceof DMTNFile) {
                    DMTNFile dMTNFile = (DMTNFile)object;
                    URL uRL = dMTNFile.getURL();
                    jLabel.setToolTipText(URLFileSystem.getPlatformPathName((URL)uRL));
                } else {
                    jLabel.setToolTipText(null);
                }
                return jLabel;
            }

            private TCR() {
            }

            TCR(1 var1_1) {
                this();
            }

            public final class 1 {
            }
        }
    }
}

