/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.usage;

import java.net.URL;
import oracle.ide.model.Project;
import oracle.ide.net.URLPath;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.util.AsyncScheduler;
import oracle.javatools.parser.util.AsyncTask;
import oracle.jdeveloper.java.JavaFileProvider;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.java.provider.PathFileProvider;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdeveloper.usage.ClassQueryTaskImpl;
import oracle.jdeveloper.usage.ConstructorQueryTaskImpl;
import oracle.jdeveloper.usage.FieldQueryTaskImpl;
import oracle.jdeveloper.usage.MethodQueryTaskImpl;
import oracle.jdeveloper.usage.UsageQueryTask;
import oracle.jdeveloper.usage.event.ClassUsageListener;
import oracle.jdeveloper.usage.event.ConstructorUsageListener;
import oracle.jdeveloper.usage.event.FieldUsageListener;
import oracle.jdeveloper.usage.event.MethodUsageListener;
import oracle.jdevimpl.java.Bug4598932Fix;

public class UsageManager {
    private Project _project;
    protected ProjectPath _projectPath;
    static AsyncScheduler USAGE_SCHEDULER = new AsyncScheduler("UsageQuery", 30, 2);

    public UsageManager(Project project) {
        this._project = project;
    }

    public UsageManager(ProjectPath projectPath) {
        this._projectPath = projectPath;
    }

    protected JavaFileProvider getJavaProvider() {
        if (this._project != null) {
            return JavaManager.getJavaManager(this._project);
        }
        URLPath uRLPath = new URLPath();
        uRLPath.add(this._projectPath._classPath);
        uRLPath.add(this._projectPath._libPath);
        URLPath uRLPath2 = this._projectPath._sourcePath;
        return new PathFileProvider(uRLPath2, uRLPath);
    }

    protected URLPath getSourcePath() {
        if (this._project != null) {
            return PathsConfiguration.getInstance(this._project).getSourcePath();
        }
        return this._projectPath._sourcePath;
    }

    public UsageQueryTask findClassUsages(String string, ClassUsageListener classUsageListener) {
        return this.findClassUsages(string, classUsageListener, null);
    }

    public UsageQueryTask findClassUsages(String string, ClassUsageListener classUsageListener, URL[] uRLArray) {
        ClassQueryTaskImpl classQueryTaskImpl = new ClassQueryTaskImpl(this, string, classUsageListener, uRLArray);
        boolean bl = Bug4598932Fix.getPreventDeadlock();
        if (bl) {
            try {
                classQueryTaskImpl.run();
            }
            catch (Error error) {}
        } else {
            USAGE_SCHEDULER.scheduleTask((AsyncTask)classQueryTaskImpl);
        }
        return classQueryTaskImpl;
    }

    private UsageQueryTask findClassUsage(JavaClass javaClass, ClassUsageListener classUsageListener) {
        return this.findClassUsage(javaClass, classUsageListener, null);
    }

    private UsageQueryTask findClassUsage(JavaClass javaClass, ClassUsageListener classUsageListener, URL[] uRLArray) {
        ClassQueryTaskImpl classQueryTaskImpl = new ClassQueryTaskImpl(this, javaClass, classUsageListener, uRLArray);
        boolean bl = Bug4598932Fix.getPreventDeadlock();
        if (bl) {
            try {
                classQueryTaskImpl.run();
            }
            catch (Error error) {}
        } else {
            USAGE_SCHEDULER.scheduleTask((AsyncTask)classQueryTaskImpl);
        }
        return classQueryTaskImpl;
    }

    public UsageQueryTask findFieldUsages(String string, String string2, String string3, FieldUsageListener fieldUsageListener) {
        return this.findFieldUsages(string, string2, string3, fieldUsageListener, null);
    }

    public UsageQueryTask findFieldUsages(String string, String string2, FieldUsageListener fieldUsageListener) {
        return this.findFieldUsages(string, null, string2, fieldUsageListener, null);
    }

    public UsageQueryTask findFieldUsages(String string, String string2, String string3, FieldUsageListener fieldUsageListener, URL[] uRLArray) {
        FieldQueryTaskImpl fieldQueryTaskImpl = new FieldQueryTaskImpl(this, string, string2, string3, fieldUsageListener, uRLArray);
        boolean bl = Bug4598932Fix.getPreventDeadlock();
        if (bl) {
            try {
                fieldQueryTaskImpl.run();
            }
            catch (Error error) {}
        } else {
            USAGE_SCHEDULER.scheduleTask((AsyncTask)fieldQueryTaskImpl);
        }
        return fieldQueryTaskImpl;
    }

    public UsageQueryTask findFieldUsages(String string, String string2, FieldUsageListener fieldUsageListener, URL[] uRLArray) {
        return this.findFieldUsages(string, null, string2, fieldUsageListener, uRLArray);
    }

    public UsageQueryTask findConstructorUsages(String string, String[] stringArray, ConstructorUsageListener constructorUsageListener) {
        return this.findConstructorUsages(string, stringArray, constructorUsageListener, null);
    }

    public UsageQueryTask findConstructorUsages(String string, String[] stringArray, ConstructorUsageListener constructorUsageListener, URL[] uRLArray) {
        ConstructorQueryTaskImpl constructorQueryTaskImpl = new ConstructorQueryTaskImpl(this, string, stringArray, constructorUsageListener, uRLArray);
        boolean bl = Bug4598932Fix.getPreventDeadlock();
        if (bl) {
            try {
                constructorQueryTaskImpl.run();
            }
            catch (Error error) {}
        } else {
            USAGE_SCHEDULER.scheduleTask((AsyncTask)constructorQueryTaskImpl);
        }
        return constructorQueryTaskImpl;
    }

    public UsageQueryTask findMethodUsages(String string, String string2, String[] stringArray, MethodUsageListener methodUsageListener) {
        return this.findMethodUsages(string, string2, stringArray, methodUsageListener, null);
    }

    public UsageQueryTask findMethodUsages(String string, String string2, String[] stringArray, MethodUsageListener methodUsageListener, URL[] uRLArray) {
        MethodQueryTaskImpl methodQueryTaskImpl = new MethodQueryTaskImpl(this, string, string2, stringArray, methodUsageListener, uRLArray);
        boolean bl = Bug4598932Fix.getPreventDeadlock();
        if (bl) {
            try {
                methodQueryTaskImpl.run();
            }
            catch (Error error) {}
        } else {
            USAGE_SCHEDULER.scheduleTask((AsyncTask)methodQueryTaskImpl);
        }
        return methodQueryTaskImpl;
    }

    public JavaClass getClass(String string) {
        JavaFileProvider javaFileProvider = this.getJavaProvider();
        JavaClass javaClass = javaFileProvider.getClass(string);
        return javaClass;
    }

    static void cancelQuery(AsyncTask asyncTask) {
        USAGE_SCHEDULER.cancelTask(asyncTask);
    }

    public static class ProjectPath {
        public URLPath _sourcePath;
        public URLPath _libPath;
        public URLPath _classPath;

        public ProjectPath(URLPath uRLPath, URLPath uRLPath2, URLPath uRLPath3) {
            this._sourcePath = uRLPath;
            this._libPath = uRLPath2;
            this._classPath = uRLPath3;
        }

        public ProjectPath(URL uRL, URL uRL2, URL uRL3) {
            this._sourcePath = new URLPath(uRL);
            this._libPath = new URLPath(uRL2);
            this._classPath = new URLPath(uRL3);
        }
    }
}

