/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.usage.file;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.JarIndex;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.parser.util.AsyncTask;
import oracle.jdeveloper.usage.file.FileListQueryTask;
import oracle.jdeveloper.usage.file.FileRecord;
import oracle.jdeveloper.usage.file.FileTable;

final class BFFileTable
extends FileTable {
    BFFileTable(URL uRL) {
        super(uRL);
    }

    protected FileListQueryTask createFileListQueryTask() {
        return new BFFileListQueryTask(null);
    }

    private final class BFFileListQueryTask
    extends FileTable.AbstractFileListQueryTask {
        protected FileRecord[] fetchFileInfo() throws AsyncTask.CancelledException {
            int n = BFFileTable.this._fileSetByName.size() + 100;
            ArrayList arrayList = new ArrayList(n);
            if (JarUtil.isJarURL((URL)BFFileTable.this._rootURL)) {
                this._fetchJarFileInfo(BFFileTable.this._rootURL, arrayList);
            } else {
                this._fetchDirFileInfo(BFFileTable.this._rootURL, "", arrayList);
            }
            int n2 = arrayList.size();
            FileRecord[] fileRecordArray = new FileRecord[n2];
            return arrayList.toArray(fileRecordArray);
        }

        private void _fetchJarFileInfo(URL uRL, List list) throws AsyncTask.CancelledException {
            try {
                this.bailIfCancelled();
                JarIndex jarIndex = JarUtil.getJarIndex((URL)uRL);
                String[] stringArray = jarIndex.getEntries();
                int n = stringArray.length;
                this.bailIfCancelled();
                String string = JarUtil.getJarEntry((URL)uRL);
                int n2 = string != null ? string.length() : 0;
                this.bailIfCancelled();
                URL uRL2 = JarUtil.getJarFileURL((URL)uRL);
                long l = URLFileSystem.lastModified((URL)uRL2);
                int n3 = 0;
                while (n3 < n) {
                    block11: {
                        String string2;
                        block10: {
                            this.bailIfCancelled();
                            string2 = stringArray[n3];
                            if (n2 <= 0) break block10;
                            if (!string2.startsWith(string)) break block11;
                            string2 = string2.substring(n2);
                        }
                        if (string2.length() != 0) {
                            char[] cArray;
                            char[] cArray2;
                            int n4 = string2.lastIndexOf(47);
                            if (n4 == -1) {
                                cArray2 = FileTable.EMPTY_CHARS;
                                cArray = string2.toCharArray();
                            } else {
                                cArray2 = BFFileTable.this._nameDirectoryPool.add(string2.substring(0, n4 + 1));
                                cArray = BFFileTable.this._nameDirectoryPool.add(string2.substring(n4 + 1));
                            }
                            if (cArray.length != 0 && cArray[0] != '.') {
                                FileRecord fileRecord = new FileRecord(cArray, cArray2, l, -1, -1);
                                list.add(fileRecord);
                            }
                        }
                    }
                    ++n3;
                }
            }
            catch (IOException iOException) {
                list.clear();
            }
        }

        private void _fetchDirFileInfo(URL uRL, String string, List list) throws AsyncTask.CancelledException {
            this.bailIfCancelled();
            URL uRL2 = URLFactory.newDirURL((URL)uRL, (String)string);
            URLFileSystem.FileInfo[] fileInfoArray = URLFileSystem.ls((URL)uRL2);
            int n = fileInfoArray != null ? fileInfoArray.length : 0;
            char[] cArray = string.toCharArray();
            int n2 = 0;
            while (n2 < n) {
                this.bailIfCancelled();
                URLFileSystem.FileInfo fileInfo = fileInfoArray[n2];
                URL uRL3 = fileInfo.getURL();
                String string2 = URLFileSystem.getFileName((URL)uRL3);
                if (!fileInfo.isHidden() && !string2.startsWith(".")) {
                    if (fileInfo.isDirectory()) {
                        String string3 = string + string2 + "/";
                        this._fetchDirFileInfo(uRL, string3, list);
                    } else {
                        Node node = NodeFactory.find((URL)uRL3);
                        long l = node != null && node.isOpen() ? node.getTimestamp() : fileInfo.lastModified();
                        FileRecord fileRecord = new FileRecord(string2.toCharArray(), cArray, l, -1, -1);
                        list.add(fileRecord);
                    }
                }
                ++n2;
            }
        }

        private BFFileListQueryTask() {
            super(BFFileTable.this);
        }

        BFFileListQueryTask(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

