/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.usage.file;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import oracle.jdeveloper.usage.file.BFFileTable;
import oracle.jdeveloper.usage.file.FileList;
import oracle.jdeveloper.usage.file.FileListQueryTask;
import oracle.jdeveloper.usage.file.FileTable;
import oracle.jdeveloper.usage.util.BackgroundTask;
import oracle.jdeveloper.usage.util.TaskMultiplexer;

public final class FileManager {
    private static Map _tableMap = new HashMap(10);
    private static final TaskMultiplexer MULTIPLEXER = new TaskMultiplexer("UsageFileManagerQueue");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static FileTable lookupFileTable(URL uRL) {
        Map map = _tableMap;
        synchronized (map) {
            FileTable fileTable = (FileTable)_tableMap.get(uRL);
            if (fileTable == null) {
                fileTable = new BFFileTable(uRL);
                _tableMap.put(uRL, fileTable);
            }
            FileTable fileTable2 = fileTable;
            return fileTable2;
        }
    }

    public static FileList getFileList(URL uRL) {
        FileListQueryTask fileListQueryTask = FileManager.getFileListQueryTask(uRL);
        fileListQueryTask.waitUntilFinished();
        FileList fileList = fileListQueryTask.getQueryResult();
        return fileList;
    }

    public static FileListQueryTask getFileListQueryTask(URL uRL) {
        FileTable fileTable = FileManager.lookupFileTable(uRL);
        return new QueryWrapper(fileTable, MULTIPLEXER, null);
    }

    private FileManager() {
    }

    private static final class QueryWrapper
    extends TaskMultiplexer.TaskWrapper
    implements FileListQueryTask {
        private FileTable _fileTable;
        private FileList _fileListResult;

        private QueryWrapper(FileTable fileTable, TaskMultiplexer taskMultiplexer) {
            super(taskMultiplexer);
            this.$init$();
            this._fileTable = fileTable;
            this.initializeComplete();
        }

        protected BackgroundTask getSharedBackgroundTask() {
            return this._fileTable.getFileListQueryTask();
        }

        protected void saveResults(BackgroundTask backgroundTask) {
            FileListQueryTask fileListQueryTask = (FileListQueryTask)backgroundTask;
            FileList fileList = fileListQueryTask.getQueryResult();
            if (fileList != null) {
                this.setQueryResult(fileList);
            }
        }

        void $init$() {
            this._fileListResult = null;
        }

        private void setQueryResult(FileList fileList) {
            this._fileListResult = fileList;
        }

        public FileList getQueryResult() {
            return this._fileListResult;
        }

        QueryWrapper(FileTable fileTable, TaskMultiplexer taskMultiplexer, 1 var3_3) {
            this(fileTable, taskMultiplexer);
        }

        public final class 1 {
        }
    }
}

