/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.usage.file;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.javatools.assembly.AssemblyException;
import oracle.javatools.assembly.AssemblyFactory;
import oracle.javatools.assembly.CharArrayFactory;
import oracle.javatools.assembly.ObjectFactory;
import oracle.jdeveloper.usage.util.CharArrayPool;

class FileRecord {
    char[] filename;
    char[] directory;
    long modified;
    int fileid;
    long versionid;

    FileRecord(char[] cArray, char[] cArray2, long l, int n, long l2) {
        this.filename = cArray;
        this.directory = cArray2;
        this.modified = l;
        this.fileid = n;
        this.versionid = l2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.filename);
        stringBuffer.append('(');
        stringBuffer.append(this.directory);
        stringBuffer.append(')');
        stringBuffer.append(" mod(");
        stringBuffer.append(this.modified);
        stringBuffer.append(") fid(");
        stringBuffer.append(this.fileid);
        stringBuffer.append(") vid(");
        stringBuffer.append(this.versionid);
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    static final class PooledCharArrayFactory
    extends CharArrayFactory {
        private CharArrayPool _caPool;

        PooledCharArrayFactory(CharArrayPool charArrayPool) {
            this.$init$();
            this._caPool = charArrayPool;
        }

        void $init$() {
            this._caPool = null;
        }

        public Object assembleImpl(DataInput dataInput) throws IOException, AssemblyException {
            char[] cArray = (char[])super.assembleImpl(dataInput);
            return this._caPool.add(cArray);
        }
    }

    static final class FileRecordFactory
    extends ObjectFactory {
        private final AssemblyFactory _pooledFactory;
        public static final byte FILE_RECORD_CODE = -6;

        FileRecordFactory(CharArrayPool charArrayPool) {
            this._pooledFactory = new PooledCharArrayFactory(charArrayPool);
        }

        public byte getObjectCode() {
            return -6;
        }

        public Object assembleImpl(DataInput dataInput) throws IOException, AssemblyException {
            char[] cArray = (char[])this._pooledFactory.assemble(dataInput);
            char[] cArray2 = (char[])this._pooledFactory.assemble(dataInput);
            long l = dataInput.readLong();
            int n = dataInput.readInt();
            long l2 = dataInput.readLong();
            return new FileRecord(cArray, cArray2, l, n, l2);
        }

        public void disassembleImpl(Object object, DataOutput dataOutput) throws IOException, ClassCastException, AssemblyException {
            FileRecord fileRecord = (FileRecord)object;
            CharArrayFactory charArrayFactory = CharArrayFactory.CHAR_ARRAY_FACTORY;
            charArrayFactory.disassemble((Object)fileRecord.filename, dataOutput);
            charArrayFactory.disassemble((Object)fileRecord.directory, dataOutput);
            dataOutput.writeLong(fileRecord.modified);
            dataOutput.writeInt(fileRecord.fileid);
            dataOutput.writeLong(fileRecord.versionid);
        }
    }
}

