/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.usage.file;

import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFactory;
import oracle.ide.util.ArraySortedSet;
import oracle.jdeveloper.usage.file.FileList;
import oracle.jdeveloper.usage.file.FileRecord;
import oracle.jdeveloper.usage.file.FileTable;

final class FileRecordList
implements FileList {
    private ArraySortedSet _fileSetById;
    private long _versionid;
    private URL _rootURL;
    private FileRecord _tempRecord;

    FileRecordList(URL uRL, ArraySortedSet arraySortedSet, long l) {
        this.$init$();
        this._rootURL = uRL;
        this._fileSetById = arraySortedSet;
        this._versionid = l;
    }

    public URL getRootURL() {
        return this._rootURL;
    }

    public URL getFileURL(int n) {
        FileRecord fileRecord = this.lookupRecord(n);
        return this.getFileURL(fileRecord);
    }

    private URL getFileURL(FileRecord fileRecord) {
        if (fileRecord != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(fileRecord.directory);
            stringBuffer.append(fileRecord.filename);
            String string = stringBuffer.toString();
            URL uRL = JarUtil.isJarURL((URL)this._rootURL) ? URLFactory.newJarURL((URL)this._rootURL, (String)string) : URLFactory.newURL((URL)this._rootURL, (String)string);
            return uRL;
        }
        return null;
    }

    public boolean isFileExist(int n) {
        return this.lookupRecord(n) != null;
    }

    void $init$() {
        this._tempRecord = new FileRecord(null, null, 0L, 0, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileRecord lookupRecord(int n) {
        FileRecord fileRecord = null;
        FileRecord fileRecord2 = this._tempRecord;
        synchronized (fileRecord2) {
            this._tempRecord.fileid = n;
            fileRecord = (FileRecord)this._fileSetById.lookup((Object)this._tempRecord);
        }
        return fileRecord;
    }

    public long getVersionId() {
        return this._versionid;
    }

    public int[] getFilesSince(long l) {
        ArraySortedSet arraySortedSet = new ArraySortedSet(FileTable.DIRNAME_COMPARATOR);
        for (FileRecord fileRecord : this._fileSetById) {
            if (fileRecord.versionid <= l) continue;
            arraySortedSet.add((Object)fileRecord);
        }
        return this.getFileIdsFromFileSet(arraySortedSet);
    }

    public int[] getAllFiles() {
        ArraySortedSet arraySortedSet = new ArraySortedSet((Collection)this._fileSetById, FileTable.DIRNAME_COMPARATOR);
        return this.getFileIdsFromFileSet(arraySortedSet);
    }

    public URL[] getAllURLs() {
        ArraySortedSet arraySortedSet = new ArraySortedSet((Collection)this._fileSetById, FileTable.DIRNAME_COMPARATOR);
        int n = arraySortedSet.size();
        URL[] uRLArray = new URL[n];
        Iterator iterator = arraySortedSet.iterator();
        int n2 = 0;
        while (n2 < n) {
            FileRecord fileRecord = (FileRecord)iterator.next();
            uRLArray[n2] = this.getFileURL(fileRecord);
            ++n2;
        }
        return uRLArray;
    }

    private int[] getFileIdsFromFileSet(ArraySortedSet arraySortedSet) {
        int n = arraySortedSet.size();
        int[] nArray = new int[n];
        Iterator iterator = arraySortedSet.iterator();
        int n2 = 0;
        while (n2 < n) {
            FileRecord fileRecord = (FileRecord)iterator.next();
            nArray[n2] = fileRecord.fileid;
            ++n2;
        }
        return nArray;
    }

    protected Object[] getAllRecords() {
        return this._fileSetById.toArray();
    }

    public String toString() {
        int n = this._fileSetById.size();
        return "count(" + n + ") vid(" + this._versionid + ")";
    }
}

