/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.usage.file;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import oracle.ide.util.ArraySortedSet;
import oracle.javatools.assembly.AssemblyException;
import oracle.javatools.assembly.AssemblyFactory;
import oracle.javatools.assembly.ObjectArrayFactory;
import oracle.javatools.assembly.ObjectFactory;
import oracle.javatools.parser.util.AsyncScheduler;
import oracle.javatools.parser.util.AsyncTask;
import oracle.jdeveloper.usage.file.DirNameComparator;
import oracle.jdeveloper.usage.file.FileIdComparator;
import oracle.jdeveloper.usage.file.FileList;
import oracle.jdeveloper.usage.file.FileListQueryTask;
import oracle.jdeveloper.usage.file.FileNameComparator;
import oracle.jdeveloper.usage.file.FileRecord;
import oracle.jdeveloper.usage.file.FileRecordList;
import oracle.jdeveloper.usage.lib.Librarian;
import oracle.jdeveloper.usage.lib.ReservedStack;
import oracle.jdeveloper.usage.util.AbstractBackgroundTask;
import oracle.jdeveloper.usage.util.CharArrayPool;

abstract class FileTable {
    protected URL _rootURL;
    private static final String KEY_PREFIX = "*ojuf.FT*:";
    private String _stackKey;
    protected ArraySortedSet _fileSetByName;
    protected long _versionid;
    protected int _nextFileid;
    protected boolean _loaded;
    private static final AsyncScheduler BF_SCHEDULER = new AsyncScheduler("UsageFileTableUpdater", 10000);
    private FileListQueryTask _runningTask;
    protected static final Comparator FILEID_COMPARATOR = new FileIdComparator();
    protected static final Comparator FILENAME_COMPARATOR = new FileNameComparator();
    protected static final Comparator DIRNAME_COMPARATOR = new DirNameComparator();
    protected static final char[] EMPTY_CHARS = new char[0];
    protected final CharArrayPool _nameDirectoryPool;
    protected final AssemblyFactory FILE_RECORD_FACTORY;
    private final AssemblyFactory FILE_TABLE_FACTORY;

    FileTable(URL uRL) {
        this.$init$();
        this._rootURL = uRL;
        this._stackKey = KEY_PREFIX + this._rootURL.toString();
    }

    void $init$() {
        this._fileSetByName = new ArraySortedSet(100, FILENAME_COMPARATOR);
        this._versionid = 0;
        this._nextFileid = 1;
        this._loaded = false;
        this._runningTask = null;
        this._nameDirectoryPool = new CharArrayPool(100);
        this.FILE_RECORD_FACTORY = new FileRecord.FileRecordFactory(this._nameDirectoryPool);
        this.FILE_TABLE_FACTORY = new FileTableFactory(null);
    }

    public FileList getFileList() {
        FileListQueryTask fileListQueryTask = this.getFileListQueryTask();
        fileListQueryTask.waitUntilFinished();
        FileList fileList = fileListQueryTask.getQueryResult();
        return fileList;
    }

    protected abstract FileListQueryTask createFileListQueryTask();

    public synchronized FileListQueryTask getFileListQueryTask() {
        if (this._runningTask == null || this._runningTask.isFinished()) {
            this._runningTask = this.createFileListQueryTask();
            AsyncTask asyncTask = (AsyncTask)this._runningTask;
            BF_SCHEDULER.scheduleTask(asyncTask);
        }
        return this._runningTask;
    }

    static String ra$_stackKey(FileTable fileTable) {
        return fileTable._stackKey;
    }

    static AssemblyFactory ra$FILE_TABLE_FACTORY(FileTable fileTable) {
        return fileTable.FILE_TABLE_FACTORY;
    }

    static AsyncScheduler ra$BF_SCHEDULER() {
        return BF_SCHEDULER;
    }

    protected abstract class AbstractFileListQueryTask
    extends AbstractBackgroundTask
    implements FileListQueryTask {
        private FileList _fileListResult;

        protected final AsyncScheduler getSchedulerImpl() {
            return FileTable.ra$BF_SCHEDULER();
        }

        void $init$() {
            this._fileListResult = null;
        }

        private void setQueryResult(FileList fileList) {
            this._fileListResult = fileList;
        }

        public FileList getQueryResult() {
            return this._fileListResult;
        }

        protected Object runTaskImpl() throws AsyncTask.CancelledException {
            this.setProgress(0);
            this.setProgressText("Updating file list");
            this.loadFileTable();
            this.setProgress(10);
            FileRecord[] fileRecordArray = this.fetchFileInfo();
            this.setProgress(80);
            long l = FileTable.this._versionid;
            FileList fileList = this.updateFileTable(fileRecordArray);
            this.setQueryResult(fileList);
            this.setProgress(90);
            long l2 = FileTable.this._versionid;
            if (l != l2) {
                this.saveFileTable();
            }
            this.setProgress(100);
            return fileList;
        }

        private FileList updateFileTable(FileRecord[] fileRecordArray) {
            ArraySortedSet arraySortedSet = new ArraySortedSet((Object[])fileRecordArray, FILENAME_COMPARATOR);
            Iterator iterator = FileTable.this._fileSetByName.iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                FileRecord fileRecord = (FileRecord)iterator.next();
                if (fileRecord == null) continue;
                FileRecord fileRecord2 = (FileRecord)arraySortedSet.lookup((Object)fileRecord);
                if (fileRecord2 == null) {
                    iterator.remove();
                    bl = true;
                    continue;
                }
                if (fileRecord2.modified != fileRecord.modified) {
                    iterator.remove();
                    bl = true;
                    continue;
                }
                arraySortedSet.remove((Object)fileRecord2);
            }
            if (bl || arraySortedSet.size() > 0) {
                ++FileTable.this._versionid;
                if (FileTable.this._versionid == 0L) {
                    ++FileTable.this._versionid;
                }
            }
            FileRecord fileRecord = new FileRecord(null, null, 0L, 0, 0L);
            ArraySortedSet arraySortedSet2 = new ArraySortedSet((Collection)FileTable.this._fileSetByName, FILEID_COMPARATOR);
            for (FileRecord fileRecord3 : arraySortedSet) {
                if (fileRecord3 == null) continue;
                do {
                    ++FileTable.this._nextFileid;
                    fileRecord.fileid = fileRecord.fileid;
                } while (arraySortedSet2.contains((Object)fileRecord));
                fileRecord3.fileid = fileRecord.fileid;
                fileRecord3.versionid = FileTable.this._versionid;
                FileTable.this._fileSetByName.add((Object)fileRecord3);
                arraySortedSet2.add((Object)fileRecord3);
            }
            return new FileRecordList(FileTable.this._rootURL, arraySortedSet2, FileTable.this._versionid);
        }

        protected abstract FileRecord[] fetchFileInfo() throws AsyncTask.CancelledException;

        /*
         * Unable to fully structure code
         */
        protected void loadFileTable() throws AsyncTask.CancelledException {
            if (!FileTable.this._loaded) {
                var1_1 = Librarian.getLibrarian();
                var2_2 = var1_1.browseStack(FileTable.ra$_stackKey(FileTable.this));
                if (var2_2 != null) {
                    try {
                        try {
                            var3_3 = (FileTableObject)var2_2.lookupStackInfo(FileTable.ra$FILE_TABLE_FACTORY(FileTable.this));
                            if (var3_3 == null) ** GOTO lbl20
                            FileTable.this._fileSetByName.addAll(FileTableObject.ra$fileRecords(var3_3));
                            FileTable.this._versionid = FileTableObject.ra$versionid(var3_3);
                            FileTable.this._nextFileid = FileTableObject.ra$nextid(var3_3);
                        }
                        catch (AssemblyException var4_4) {}
                    }
                    finally {
                        var2_2.releaseStack();
                    }
                } else {
                    var1_1.createStack(FileTable.ra$_stackKey(FileTable.this));
                }
lbl20:
                // 4 sources

                FileTable.this._loaded = true;
            }
        }

        protected void saveFileTable() {
            Librarian librarian = Librarian.getLibrarian();
            ReservedStack reservedStack = librarian.reserveStack(FileTable.ra$_stackKey(FileTable.this));
            if (reservedStack == null) {
                librarian.createStack(FileTable.ra$_stackKey(FileTable.this));
                reservedStack = librarian.reserveStack(FileTable.ra$_stackKey(FileTable.this));
                if (reservedStack == null) {
                    return;
                }
            }
            try {
                try {
                    Object[] objectArray = FileTable.this._fileSetByName.toArray();
                    long l = FileTable.this._versionid;
                    int n = FileTable.this._nextFileid;
                    FileTableObject fileTableObject = new FileTableObject(objectArray, l, n, null);
                    reservedStack.replaceStackInfo(fileTableObject, FileTable.ra$FILE_TABLE_FACTORY(FileTable.this));
                }
                catch (AssemblyException assemblyException) {}
            }
            finally {
                reservedStack.releaseStack();
            }
        }

        protected AbstractFileListQueryTask() {
            this.$init$();
        }
    }

    private static final class FileTableObject {
        private Object[] fileRecords;
        private long versionid;
        private int nextid;

        private FileTableObject(Object[] objectArray, long l, int n) {
            this.fileRecords = objectArray;
            this.versionid = l;
            this.nextid = n;
        }

        FileTableObject(Object[] objectArray, long l, int n, 1 var5_4) {
            this(objectArray, l, n);
        }

        static Object[] ra$fileRecords(FileTableObject fileTableObject) {
            return fileTableObject.fileRecords;
        }

        static long ra$versionid(FileTableObject fileTableObject) {
            return fileTableObject.versionid;
        }

        static int ra$nextid(FileTableObject fileTableObject) {
            return fileTableObject.nextid;
        }

        public final class 1 {
        }
    }

    private final class FileTableFactory
    extends ObjectFactory {
        private AssemblyFactory frArrayFactory;
        public static final byte FILE_TABLE_CODE = -9;

        void $init$() {
            this.frArrayFactory = new ObjectArrayFactory(FileTable.this.FILE_RECORD_FACTORY);
        }

        public byte getObjectCode() {
            return -9;
        }

        public Object assembleImpl(DataInput dataInput) throws IOException, AssemblyException {
            Object[] objectArray = (Object[])this.frArrayFactory.assemble(dataInput);
            long l = dataInput.readLong();
            int n = dataInput.readInt();
            return new FileTableObject(objectArray, l, n, null);
        }

        public void disassembleImpl(Object object, DataOutput dataOutput) throws IOException, ClassCastException, AssemblyException {
            FileTableObject fileTableObject = (FileTableObject)object;
            this.frArrayFactory.disassemble((Object)FileTableObject.ra$fileRecords(fileTableObject), dataOutput);
            dataOutput.writeLong(FileTableObject.ra$versionid(fileTableObject));
            dataOutput.writeInt(FileTableObject.ra$nextid(fileTableObject));
        }

        private FileTableFactory() {
            this.$init$();
        }

        FileTableFactory(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

