/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.usage.io;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.javatools.parser.util.AsyncScheduler;
import oracle.javatools.parser.util.AsyncTask;
import oracle.jdeveloper.usage.io.IOQueue;
import oracle.jdeveloper.usage.io.IORequest;
import oracle.jdeveloper.usage.io.IOWorker;

final class IOCoordinator
implements Runnable {
    private static boolean USE_COORDINATOR_THREAD = true;
    private static Map _coordinatorMap = new HashMap(10);
    private Object _clientKey;
    private List _queueList;
    private List _activeList;
    private List _requestList;
    private List _completedList;
    private AsyncScheduler _scheduler;
    private static final int IDLE_TIMEOUT = 10000;
    private static int MAX_PENDING = 4;
    private static int MAX_COMPLETED_BACKLOG = 10;
    private static final int NON_THREADED_MAX_PENDING = 3;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static IOCoordinator attachToCoordinator(IOQueue iOQueue) {
        Map map = _coordinatorMap;
        synchronized (map) {
            Object object = iOQueue.getClientKey();
            IOCoordinator iOCoordinator = (IOCoordinator)_coordinatorMap.get(object);
            boolean bl = false;
            if (iOCoordinator == null) {
                bl = true;
                iOCoordinator = new IOCoordinator(object);
                _coordinatorMap.put(object, iOCoordinator);
            }
            iOCoordinator.attachQueue(iOQueue);
            if (USE_COORDINATOR_THREAD && bl) {
                String string = "Background I/O coordinator (" + object.toString() + ")";
                Thread thread = new Thread((Runnable)iOCoordinator, string);
                thread.setPriority(1);
                thread.start();
            }
            IOCoordinator iOCoordinator2 = iOCoordinator;
            return iOCoordinator2;
        }
    }

    private IOCoordinator(Object object) {
        this.$init$();
        this._clientKey = object;
        String string = "Background I/O Reader (" + object.toString() + ")";
        this._scheduler = new AsyncScheduler(string, 10000, 2);
    }

    void $init$() {
        this._queueList = new ArrayList(5);
        this._activeList = new ArrayList(5);
        this._requestList = new ArrayList(5);
        this._completedList = new ArrayList(5);
    }

    protected static void setMaxPending(int n) {
        MAX_PENDING = n;
    }

    protected static void setMaxBacklog(int n) {
        MAX_COMPLETED_BACKLOG = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (!USE_COORDINATOR_THREAD) {
            throw new IllegalStateException("Non-threaded mode enabled");
        }
        while (true) {
            IOCoordinator iOCoordinator = this;
            synchronized (iOCoordinator) {
                block13: while (true) {
                    this.deliverAllMail();
                    while (this._requestList.size() < MAX_PENDING) {
                        URL uRL = this.pickupMail();
                        if (uRL != null) {
                            this.requestProduct(uRL);
                            continue;
                        }
                        if (this._queueList.size() != 0) break;
                        break block13;
                    }
                    this.waitIgnoreInterrupt(200);
                }
            }
            IOCoordinator iOCoordinator2 = this;
            synchronized (iOCoordinator2) {
                this.waitIgnoreInterrupt(10000);
            }
            Map map = _coordinatorMap;
            synchronized (map) {
                IOCoordinator iOCoordinator3 = this;
                synchronized (iOCoordinator3) {
                    if (this._queueList.size() == 0) {
                        _coordinatorMap.remove(this._clientKey);
                        break;
                    }
                }
            }
        }
    }

    private void waitIgnoreInterrupt(int n) {
        try {
            this.wait(n);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private synchronized void deliverAllMail() {
        if (!USE_COORDINATOR_THREAD) {
            throw new IllegalStateException("Improper multi-delivery");
        }
        Iterator iterator = this._completedList.iterator();
        while (iterator.hasNext()) {
            IORequest iORequest = (IORequest)iterator.next();
            iterator.remove();
            this._requestList.remove(iORequest.getURL());
            this.deliverMail(iORequest);
        }
    }

    private synchronized void deliverMail(IORequest iORequest) {
        int n = this._queueList.size();
        int n2 = 0;
        while (n2 < n) {
            IOQueue iOQueue = (IOQueue)this._queueList.get(n2);
            iOQueue.deliverMail(iORequest);
            ++n2;
        }
    }

    private synchronized URL pickupMail(IOQueue iOQueue) {
        if (USE_COORDINATOR_THREAD) {
            throw new IllegalStateException("Improper single-queue pickup");
        }
        int n = iOQueue.getWaitBacklogCount();
        if (n < 3) {
            URL uRL = iOQueue.pickupMail();
            return uRL;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private synchronized URL pickupMail() {
        if (IOCoordinator.USE_COORDINATOR_THREAD) ** GOTO lbl23
        throw new IllegalStateException("Improper multi-queue pickup");
lbl-1000:
        // 1 sources

        {
            var1_1 = 0;
            var2_2 = null;
            var3_3 = this._activeList.size();
            var4_4 = 0;
            while (var4_4 < var3_3) {
                var5_5 = (IOQueue)this._activeList.get(var4_4);
                var6_6 = var5_5.getMailBacklogCount();
                if (var6_6 < IOCoordinator.MAX_COMPLETED_BACKLOG) {
                    var7_7 = var5_5.getWaitBacklogCount();
                    if (var2_2 == null || var7_7 < var1_1) {
                        var2_2 = var5_5;
                        var1_1 = var7_7;
                    }
                }
                ++var4_4;
            }
            if (var2_2 == null) break;
            var8_8 = var2_2.pickupMail();
            if (var8_8 != null) {
                return var8_8;
            }
            this._activeList.remove(var2_2);
lbl23:
            // 2 sources

            ** while (this._activeList.size() > 0)
        }
lbl24:
        // 2 sources

        return null;
    }

    protected synchronized void attachQueue(IOQueue iOQueue) {
        this._queueList.add(iOQueue);
    }

    protected synchronized void detachQueue(IOQueue iOQueue) {
        this._queueList.remove(iOQueue);
        this._activeList.remove(iOQueue);
        if (USE_COORDINATOR_THREAD) {
            this.notify();
        }
    }

    protected synchronized void requestPickup(IOQueue iOQueue) {
        if (USE_COORDINATOR_THREAD) {
            this._activeList.add(iOQueue);
            this.notify();
        } else {
            this.waitingForDelivery(iOQueue);
        }
    }

    protected synchronized void waitingForDelivery(IOQueue iOQueue) {
        if (USE_COORDINATOR_THREAD) {
            this.notify();
        } else {
            URL uRL;
            while ((uRL = this.pickupMail(iOQueue)) != null) {
                this.requestProduct(uRL);
            }
        }
    }

    protected void abortRequests(URL[] uRLArray) {
    }

    private synchronized void requestProduct(URL uRL) {
        if (!this._requestList.contains(uRL)) {
            this._requestList.add(uRL);
            IOWorker iOWorker = new IOWorker(this, uRL);
            this._scheduler.scheduleTask((AsyncTask)iOWorker);
        }
    }

    protected synchronized void deliverProduct(IORequest iORequest) {
        if (USE_COORDINATOR_THREAD) {
            this._completedList.add(iORequest);
            this.notify();
        } else {
            this._requestList.remove(iORequest.getURL());
            this.deliverMail(iORequest);
        }
    }
}

