/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.usage.io;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import oracle.jdeveloper.usage.io.EmptyQueueException;
import oracle.jdeveloper.usage.io.IOCoordinator;
import oracle.jdeveloper.usage.io.IORequest;

public final class IOQueue {
    private Object _clientKey;
    private List _requestList;
    private List _pendingList;
    private List _completedList;
    private IOCoordinator _coordinator;

    public IOQueue(Object object) {
        this.$init$();
        this._clientKey = object;
        this.createMailbox();
    }

    protected Object getClientKey() {
        return this._clientKey;
    }

    void $init$() {
        this._requestList = new ArrayList(10);
        this._pendingList = new ArrayList(5);
        this._completedList = new ArrayList(5);
    }

    public void disposeQueue() {
        this.cancelAllRequests();
        this.cancelMailbox();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateQueue() {
        IOQueue iOQueue = this;
        synchronized (iOQueue) {
            if (this._coordinator == null) {
                throw new IllegalStateException("queue disposed already");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendRequest(URL uRL) {
        IOQueue iOQueue = this;
        synchronized (iOQueue) {
            this.validateQueue();
            if (uRL != null) {
                this._requestList.add(uRL);
            }
        }
        this.requestPickup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendRequests(URL[] uRLArray) {
        IOQueue iOQueue = this;
        synchronized (iOQueue) {
            this.validateQueue();
            List<URL> list = Arrays.asList(uRLArray);
            this._requestList.addAll(list);
            this._requestList.remove(null);
        }
        this.requestPickup();
    }

    public void cancelRequest(URL uRL) {
        if (uRL != null) {
            URL[] uRLArray = new URL[]{uRL};
            this.cancelRequests(uRLArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelRequests(URL[] uRLArray) {
        int n;
        int n2 = n = uRLArray == null ? 0 : uRLArray.length;
        if (n == 0) {
            return;
        }
        ArrayList<URL> arrayList = new ArrayList<URL>();
        IOQueue iOQueue = this;
        synchronized (iOQueue) {
            this.validateQueue();
            List<URL> list = Arrays.asList(uRLArray);
            this._requestList.removeAll(list);
            arrayList.addAll(list);
            arrayList.retainAll(this._pendingList);
            this._pendingList.removeAll(list);
            Iterator iterator = this._completedList.iterator();
            while (iterator.hasNext()) {
                IORequest iORequest = (IORequest)iterator.next();
                URL uRL = iORequest.getURL();
                if (!list.contains(uRL)) continue;
                iterator.remove();
            }
        }
        int n3 = arrayList.size();
        URL[] uRLArray2 = new URL[n3];
        uRLArray2 = arrayList.toArray(uRLArray2);
        this.abortMail(uRLArray2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAllRequests() {
        ArrayList arrayList = new ArrayList();
        IOQueue iOQueue = this;
        synchronized (iOQueue) {
            this.validateQueue();
            this._requestList.clear();
            arrayList.addAll(this._pendingList);
            this._pendingList.clear();
            this._completedList.clear();
        }
        int n = arrayList.size();
        URL[] uRLArray = new URL[n];
        uRLArray = arrayList.toArray(uRLArray);
        this.abortMail(uRLArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRequestCount() {
        IOQueue iOQueue = this;
        synchronized (iOQueue) {
            int n;
            this.validateQueue();
            int n2 = n = this._pendingList.size() + this._requestList.size();
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IORequest waitForRequest(long l) throws EmptyQueueException {
        long l2 = l;
        this.validateQueue();
        if (this._completedList.size() == 0) {
            this.needMoreMail();
        }
        IOQueue iOQueue = this;
        synchronized (iOQueue) {
            do {
                IORequest iORequest;
                if (this._completedList.size() > 0 && (iORequest = (IORequest)this._completedList.remove(0)) != null) {
                    IORequest iORequest2 = iORequest;
                    return iORequest2;
                }
                if (this.getRequestCount() == 0) {
                    throw new EmptyQueueException();
                }
                try {
                    this.wait(l2);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (this._completedList.size() > 0 || l2 == 0L);
            IORequest iORequest = null;
            return iORequest;
        }
    }

    public IORequest waitForRequest() throws EmptyQueueException {
        return this.waitForRequest(0L);
    }

    private void createMailbox() {
        this._coordinator = IOCoordinator.attachToCoordinator(this);
    }

    private void requestPickup() {
        this._coordinator.requestPickup(this);
    }

    private void abortMail(URL[] uRLArray) {
        this._coordinator.abortRequests(uRLArray);
    }

    private void needMoreMail() {
        this._coordinator.waitingForDelivery(this);
    }

    private void cancelMailbox() {
        this._coordinator.detachQueue(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected URL pickupMail() {
        URL uRL = null;
        IOQueue iOQueue = this;
        synchronized (iOQueue) {
            if (this._coordinator != null && this._requestList.size() > 0) {
                uRL = (URL)this._requestList.remove(0);
                this._pendingList.add(uRL);
            }
        }
        return uRL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getMailBacklogCount() {
        IOQueue iOQueue = this;
        synchronized (iOQueue) {
            int n = this._completedList.size();
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getWaitBacklogCount() {
        IOQueue iOQueue = this;
        synchronized (iOQueue) {
            int n = this._pendingList.size();
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deliverMail(IORequest iORequest) {
        IOQueue iOQueue = this;
        synchronized (iOQueue) {
            URL uRL = iORequest.getURL();
            if (this._coordinator != null && (this._pendingList.remove(uRL) || this._requestList.remove(uRL))) {
                this._completedList.add(iORequest);
                this.notifyAll();
            }
        }
    }
}

