/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.usage.io;

import java.net.URL;
import java.util.ArrayList;
import oracle.ide.model.Recognizer;
import oracle.ide.model.TextNode;
import oracle.ide.model.UnrecognizedTextNode;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.jdeveloper.model.JavaClassNode;
import oracle.jdeveloper.model.JavaSourceNode;
import oracle.jdeveloper.usage.file.FileList;
import oracle.jdeveloper.usage.file.FileManager;
import oracle.jdeveloper.usage.io.EmptyQueueException;
import oracle.jdeveloper.usage.io.IOQueue;
import oracle.jdeveloper.usage.io.IORequest;
import oracle.jdeveloper.usage.lib.BFLibrarian;

public class IOTester {
    private static final String TEST_DIR = "w:/jdev/src/java";
    private static final String TEMP_DIR = "c:/temp/iotester";

    static {
        System.getProperties().put("ENABLE_BFLIBRARIAN", "true");
        URL uRL = URLFactory.newDirURL((String)TEMP_DIR);
        URLFileSystem.mkdirs((URL)uRL);
        BFLibrarian.setOverrideLocation(TEMP_DIR);
        Recognizer.mapExtensionToClass((String)".java", JavaSourceNode.class);
    }

    public static void main(String[] stringArray) {
        System.out.println("Fetching list of files for: w:/jdev/src/java");
        long l = System.currentTimeMillis();
        URL uRL = URLFactory.newDirURL((String)TEST_DIR);
        FileList fileList = FileManager.getFileList(uRL);
        long l2 = System.currentTimeMillis() - l;
        URL[] uRLArray = fileList.getAllURLs();
        int n = uRLArray != null ? uRLArray.length : 0;
        System.out.println("  Elapsed time (ms): " + l2);
        System.out.println("  File count: " + n);
        System.out.println("Determining files that are text files...");
        l = System.currentTimeMillis();
        Class<TextNode> clazz = TextNode.class;
        Class<JavaClassNode> clazz2 = JavaClassNode.class;
        Class<UnrecognizedTextNode> clazz3 = UnrecognizedTextNode.class;
        ArrayList<URL> arrayList = new ArrayList<URL>(n);
        int n2 = 0;
        while (n2 < n) {
            URL uRL2 = uRLArray[n2];
            Class clazz4 = Recognizer.recognizeURL((URL)uRL2);
            if (clazz4 != null && clazz.isAssignableFrom(clazz4) && !clazz2.isAssignableFrom(clazz4) && !clazz3.isAssignableFrom(clazz4)) {
                arrayList.add(uRL2);
            }
            ++n2;
        }
        int n3 = arrayList.size();
        URL[] uRLArray2 = arrayList.toArray(new URL[n3]);
        l2 = System.currentTimeMillis() - l;
        System.out.println("  Elapsed time (ms): " + l2);
        System.out.println("  Recognized text files: " + n3);
        System.out.println("Starting IO read test using IOQueue...");
        IOQueue iOQueue = new IOQueue("test queue");
        iOQueue.sendRequests(uRLArray2);
        long l3 = 0L;
        long l4 = 0L;
        l = System.currentTimeMillis();
        try {
            while (true) {
                IORequest iORequest;
                if (!(iORequest = iOQueue.waitForRequest()).isSuccessful()) {
                    continue;
                }
                ReadTextBuffer readTextBuffer = iORequest.getTextData();
                ++l3;
                l4 += (long)readTextBuffer.getLength();
            }
        }
        catch (EmptyQueueException emptyQueueException) {
            l2 = System.currentTimeMillis() - l;
            System.out.println("  Elapsed time (ms): " + l2);
            System.out.println("  Chars read: " + l4);
            System.out.println("  Files processed: " + l3);
            System.exit(1);
            return;
        }
    }
}

