/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.usage.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.TextNode;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.parser.util.AsyncTask;
import oracle.jdeveloper.model.JavaClassNode;
import oracle.jdeveloper.usage.io.IOCoordinator;
import oracle.jdeveloper.usage.io.IORequest;
import oracle.jdeveloper.usage.util.FileUtilities;

final class IOWorker
extends AsyncTask {
    private IOCoordinator _coordinator;
    private URL _url;

    IOWorker(IOCoordinator iOCoordinator, URL uRL) {
        this._coordinator = iOCoordinator;
        this._url = uRL;
    }

    IOWorker(URL uRL) {
        this(null, uRL);
    }

    protected Object runImpl() throws AsyncTask.CancelledException {
        try {
            Node node = NodeFactory.findOrCreate((URL)this._url);
            if (node == null) {
                IllegalStateException illegalStateException = new IllegalStateException("Cannot create node: " + this._url);
                IORequest iORequest = this.deliverFailure(null, illegalStateException);
                return iORequest;
            }
            try {
                if (node instanceof TextNode && !(node instanceof JavaClassNode)) {
                    TextNode textNode = (TextNode)node;
                    ReadTextBuffer readTextBuffer = this.loadTextData(textNode);
                    IORequest iORequest = this.deliverData(textNode, readTextBuffer);
                    return iORequest;
                }
                byte[] byArray = this.loadBinaryData();
                IORequest iORequest = this.deliverData(node, byArray);
                return iORequest;
            }
            catch (IOException iOException) {
                IORequest iORequest = this.deliverFailure(node, iOException);
                return iORequest;
            }
        }
        catch (InstantiationException instantiationException) {
            IORequest iORequest = this.deliverFailure(null, instantiationException);
            return iORequest;
        }
        catch (IllegalAccessException illegalAccessException) {
            IORequest iORequest = this.deliverFailure(null, illegalAccessException);
            return iORequest;
        }
        catch (RuntimeException runtimeException) {
            IORequest iORequest = this.deliverFailure(null, runtimeException);
            return iORequest;
        }
    }

    protected void requestCancelImpl() {
    }

    protected boolean isCancelledImpl() {
        return false;
    }

    protected ReadTextBuffer loadTextData(TextNode textNode) throws IOException {
        if (textNode.isOpen()) {
            return textNode.acquireTextBuffer();
        }
        String string = textNode.getLoadEncoding();
        InputStream inputStream = null;
        InputStreamReader inputStreamReader = null;
        try {
            inputStream = URLFileSystem.openInputStream((URL)this._url);
            inputStreamReader = new InputStreamReader(inputStream, string);
            TextBuffer textBuffer = TextBufferFactory.createArrayTextBuffer();
            textBuffer.read((Reader)inputStreamReader);
            TextBuffer textBuffer2 = textBuffer;
            if (inputStream != null) {
                inputStream.close();
            }
            return textBuffer2;
        }
        catch (Throwable throwable) {
            if (inputStream != null) {
                inputStream.close();
            }
            throw throwable;
        }
    }

    protected byte[] loadBinaryData() throws IOException {
        return FileUtilities.readFile(this._url);
    }

    private IORequest deliverFailure(Node node, Throwable throwable) {
        IORequest iORequest = new IORequest(this._url, node, throwable);
        this.deliverRequest(iORequest);
        return iORequest;
    }

    private IORequest deliverData(TextNode textNode, ReadTextBuffer readTextBuffer) {
        IORequest iORequest = new IORequest(this._url, textNode, readTextBuffer);
        this.deliverRequest(iORequest);
        return iORequest;
    }

    private IORequest deliverData(Node node, byte[] byArray) {
        IORequest iORequest = new IORequest(this._url, node, byArray);
        this.deliverRequest(iORequest);
        return iORequest;
    }

    private void deliverRequest(IORequest iORequest) {
        if (this._coordinator != null) {
            this._coordinator.deliverProduct(iORequest);
        }
    }
}

