/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.usage.keyword;

import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.java.v2.scanner.JavaLexer;
import oracle.jdeveloper.usage.keyword.KeywordListener;
import oracle.jdeveloper.usage.keyword.KeywordScanner;
import oracle.jdeveloper.usage.util.CharArrayPool;

public class JavaScanner
extends KeywordScanner {
    public static final int FLAG_INCLUDE_COMMENTS = 65536;
    public static final int FLAG_INCLUDE_LITERALS = 131072;
    public static final int FLAG_INCLUDE_SQLJ = 262144;

    public JavaScanner(ReadTextBuffer readTextBuffer, KeywordListener keywordListener) {
        super(readTextBuffer, keywordListener);
    }

    public JavaScanner(ReadTextBuffer readTextBuffer, CharArrayPool charArrayPool, KeywordListener keywordListener) {
        super(readTextBuffer, charArrayPool, keywordListener);
    }

    public void scan(char[] cArray, int n, int n2, int n3) {
        JavaLexer javaLexer = new JavaLexer();
        LexerToken lexerToken = javaLexer.createLexerToken();
        javaLexer.setTextBuffer(this._textBuffer);
        javaLexer.setPosition(n2);
        boolean bl = (n & 0x10000) != 0;
        boolean bl2 = (n & 0x20000) != 0;
        boolean bl3 = (n & 0x40000) != 0;
        javaLexer.setSkipComments(bl ^ true);
        javaLexer.setRecognizeSQLJ(true);
        block6: while (true) {
            int n4 = javaLexer.lex(lexerToken);
            int n5 = lexerToken.getStartOffset();
            int n6 = lexerToken.getEndOffset();
            if (n5 >= n3 || n4 == 0) {
                return;
            }
            n6 = Math.min(n6, n3);
            switch (n4) {
                case 24: 
                case 25: 
                case 26: {
                    if (!bl) continue block6;
                    this.scanText(cArray, 131072, n5, n6);
                    break;
                }
                case 14: {
                    if (!bl2) continue block6;
                    this.scanText(cArray, 131072, n5, n6);
                    break;
                }
                case 6: {
                    if (!bl3) continue block6;
                    this.scanText(cArray, 0, n5, n6);
                    break;
                }
                case 4: {
                    this.reportKeyword(cArray, 0, n5, n6);
                }
            }
        }
    }

    public void scanText(char[] cArray, int n, int n2, int n3) {
        int n4 = n2;
        int n5 = -1;
        int n6 = -1;
        boolean bl = (n & 0x20000) != 0;
        while (n4 < n3) {
            char c = this._textBuffer.getChar(n4);
            if (n5 == -1) {
                if (c < '\u0100' && KeywordScanner.IDENTIFIER_START[c] || Character.isJavaIdentifierStart(c)) {
                    n5 = n4;
                }
            } else if (!(c < '\u0100' && KeywordScanner.IDENTIFIER_PART[c] || Character.isJavaIdentifierPart(c))) {
                n6 = n4;
            }
            if (c == '\\' && ++n4 < this._textBuffer.getLength()) {
                char c2 = this._textBuffer.getChar(n4);
                switch (c2) {
                    case '\"': 
                    case '\'': 
                    case '\\': 
                    case 'n': 
                    case 'r': 
                    case 't': {
                        if (!bl) break;
                        ++n4;
                        break;
                    }
                    case 'u': {
                        n4 += 5;
                    }
                }
            }
            if (n5 == -1) continue;
            if (n6 == -1 && n4 >= n3) {
                n6 = n3;
            }
            if (n6 == -1) continue;
            this.reportKeyword(cArray, n, n5, n6);
            n5 = -1;
            n6 = -1;
        }
    }
}

