/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.usage.keyword;

import java.io.FileNotFoundException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.ide.model.Node;
import oracle.ide.model.Recognizer;
import oracle.ide.model.TextNode;
import oracle.ide.model.UnrecognizedTextNode;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.assembly.AssemblyException;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.parser.util.AsyncScheduler;
import oracle.javatools.parser.util.AsyncTask;
import oracle.jdeveloper.model.JavaClassNode;
import oracle.jdeveloper.model.JavaSourceNode;
import oracle.jdeveloper.usage.UsageArb;
import oracle.jdeveloper.usage.file.FileList;
import oracle.jdeveloper.usage.file.FileListQueryTask;
import oracle.jdeveloper.usage.file.FileManager;
import oracle.jdeveloper.usage.io.EmptyQueueException;
import oracle.jdeveloper.usage.io.IOQueue;
import oracle.jdeveloper.usage.io.IORequest;
import oracle.jdeveloper.usage.keyword.IndexBook;
import oracle.jdeveloper.usage.keyword.IndexInfo;
import oracle.jdeveloper.usage.keyword.JavaScanner;
import oracle.jdeveloper.usage.keyword.KeywordBatchQueryTask;
import oracle.jdeveloper.usage.keyword.KeywordCollector;
import oracle.jdeveloper.usage.keyword.KeywordQueryTask;
import oracle.jdeveloper.usage.keyword.KeywordScanner;
import oracle.jdeveloper.usage.lib.BrowseStack;
import oracle.jdeveloper.usage.lib.Librarian;
import oracle.jdeveloper.usage.lib.ReservedStack;
import oracle.jdeveloper.usage.util.AbstractBackgroundTask;
import oracle.jdeveloper.usage.util.BackgroundTask;
import oracle.jdeveloper.usage.util.CharArrayPool;
import oracle.jdeveloper.usage.util.TaskMultiplexer;
import oracle.jdevimpl.java.Bug4598932Fix;

public class KeywordIndex {
    private static HashMap _urlToIndexMap = new HashMap();
    private URL _rootURL;
    private String _stackKey;
    private static final String KEY_PREFIX = "*ojuk.KI*:";
    private AsyncScheduler QUERY_SCHEDULER;
    private int _runningQueries;
    private final TaskMultiplexer INDEX_MULTIPLEXER;
    private boolean _loaded;
    private long _versionid;
    private long _lastSyncId;
    private static final AsyncScheduler INDEX_SCHEDULER = new AsyncScheduler("Keyword Index Builder", 10000, 2);
    private IndexBuildTask _runningIndexer;

    public static synchronized KeywordIndex getKeywordIndex(URL uRL) {
        KeywordIndex keywordIndex = (KeywordIndex)_urlToIndexMap.get(uRL);
        if (keywordIndex == null) {
            keywordIndex = new KeywordIndex(uRL);
            _urlToIndexMap.put(uRL, keywordIndex);
        }
        return keywordIndex;
    }

    KeywordIndex(URL uRL) {
        this.$init$();
        this._rootURL = uRL;
        this._stackKey = KEY_PREFIX + this._rootURL.toString();
    }

    public BackgroundTask getBuildTask() {
        return this.getIndexBuildTask();
    }

    public KeywordQueryTask getQueryTask(String string) {
        IndexQueryTask indexQueryTask = new IndexQueryTask(string, null);
        this.QUERY_SCHEDULER.scheduleTask((AsyncTask)indexQueryTask);
        return indexQueryTask;
    }

    public KeywordBatchQueryTask getBatchQueryTask(String[] stringArray) {
        IndexQueryTask indexQueryTask = new IndexQueryTask(stringArray, null);
        this.QUERY_SCHEDULER.scheduleTask((AsyncTask)indexQueryTask);
        return indexQueryTask;
    }

    void $init$() {
        this.QUERY_SCHEDULER = new AsyncScheduler("Keyword Index Query", 10000, 5);
        this._runningQueries = 0;
        this.INDEX_MULTIPLEXER = new TaskMultiplexer("KeywordIndexRedirector");
        this._loaded = false;
        this._versionid = 0;
        this._lastSyncId = 0;
        this._runningIndexer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileListQueryTask notifyQueryStarting() {
        KeywordIndex keywordIndex = this;
        synchronized (keywordIndex) {
            if (this._runningQueries == 0 || this.isIndexerRunning()) {
                ++this._runningQueries;
                FileListQueryTask fileListQueryTask = this.getIndexBuildTask();
                return fileListQueryTask;
            }
            FileListQueryTask fileListQueryTask = null;
            return fileListQueryTask;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyQueryFinished() {
        KeywordIndex keywordIndex = this;
        synchronized (keywordIndex) {
            --this._runningQueries;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FileListQueryTask getIndexBuildTask() {
        KeywordIndex keywordIndex = this;
        synchronized (keywordIndex) {
            IndexWrapper indexWrapper = new IndexWrapper(null);
            return indexWrapper;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileListQueryTask getOrCreateRunningIndexer() {
        KeywordIndex keywordIndex = this;
        synchronized (keywordIndex) {
            if (this._runningIndexer != null && this._runningIndexer.isFinished()) {
                this._runningIndexer = null;
            }
            if (this._runningIndexer == null) {
                this._runningIndexer = new IndexBuildTask(null);
                INDEX_SCHEDULER.scheduleTask((AsyncTask)this._runningIndexer);
            }
            IndexBuildTask indexBuildTask = this._runningIndexer;
            return indexBuildTask;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isIndexerRunning() {
        KeywordIndex keywordIndex = this;
        synchronized (keywordIndex) {
            boolean bl = this._runningIndexer != null;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearRunningIndexer(IndexBuildTask indexBuildTask) {
        KeywordIndex keywordIndex = this;
        synchronized (keywordIndex) {
            if (this._runningIndexer == indexBuildTask) {
                this._runningIndexer = null;
            }
        }
    }

    static FileListQueryTask mav$notifyQueryStarting(KeywordIndex keywordIndex) {
        return keywordIndex.notifyQueryStarting();
    }

    static String ra$_stackKey(KeywordIndex keywordIndex) {
        return keywordIndex._stackKey;
    }

    static void mav$notifyQueryFinished(KeywordIndex keywordIndex) {
        keywordIndex.notifyQueryFinished();
    }

    static AsyncScheduler ra$QUERY_SCHEDULER(KeywordIndex keywordIndex) {
        return keywordIndex.QUERY_SCHEDULER;
    }

    static TaskMultiplexer ra$INDEX_MULTIPLEXER(KeywordIndex keywordIndex) {
        return keywordIndex.INDEX_MULTIPLEXER;
    }

    static FileListQueryTask mav$getOrCreateRunningIndexer(KeywordIndex keywordIndex) {
        return keywordIndex.getOrCreateRunningIndexer();
    }

    static URL ra$_rootURL(KeywordIndex keywordIndex) {
        return keywordIndex._rootURL;
    }

    static long ra$_versionid(KeywordIndex keywordIndex) {
        return keywordIndex._versionid;
    }

    static long ra$_lastSyncId(KeywordIndex keywordIndex) {
        return keywordIndex._lastSyncId;
    }

    static boolean ra$_loaded(KeywordIndex keywordIndex) {
        return keywordIndex._loaded;
    }

    static void wa$_versionid(KeywordIndex keywordIndex, long l) {
        keywordIndex._versionid = l;
    }

    static void wa$_lastSyncId(KeywordIndex keywordIndex, long l) {
        keywordIndex._lastSyncId = l;
    }

    static void wa$_loaded(KeywordIndex keywordIndex, boolean bl) {
        keywordIndex._loaded = bl;
    }

    static void mav$clearRunningIndexer(KeywordIndex keywordIndex, IndexBuildTask indexBuildTask) {
        keywordIndex.clearRunningIndexer(indexBuildTask);
    }

    static AsyncScheduler ra$INDEX_SCHEDULER() {
        return INDEX_SCHEDULER;
    }

    private final class IndexQueryTask
    extends AbstractBackgroundTask
    implements KeywordBatchQueryTask,
    KeywordQueryTask {
        private String _keyword;
        private String[] _batchKeywords;
        private URL[] _urlsResult;
        private URL[][] _batchUrlsResult;

        private IndexQueryTask(String string) {
            this.$init$();
            this._keyword = string;
        }

        private IndexQueryTask(String[] stringArray) {
            this.$init$();
            this._batchKeywords = stringArray;
        }

        void $init$() {
            this._keyword = null;
            this._batchKeywords = null;
            this._urlsResult = null;
            this._batchUrlsResult = null;
        }

        protected AsyncScheduler getSchedulerImpl() {
            return KeywordIndex.ra$QUERY_SCHEDULER(KeywordIndex.this);
        }

        private void setQueryResult(URL[] uRLArray) {
            this._urlsResult = uRLArray;
        }

        private void setBatchQueryResult(URL[][] uRLArray) {
            this._batchUrlsResult = uRLArray;
        }

        public URL[] getQueryResult() {
            return this._urlsResult;
        }

        public URL[][] getBatchQueryResult() {
            return this._batchUrlsResult;
        }

        protected Object runTaskImpl() throws AsyncTask.CancelledException {
            block15: {
                FileListQueryTask fileListQueryTask = null;
                while (true) {
                    this.bailIfCancelled();
                    fileListQueryTask = KeywordIndex.mav$notifyQueryStarting(KeywordIndex.this);
                    if (fileListQueryTask != null) break;
                    this.setProgressText(UsageArb.getString(2));
                    IndexQueryTask.sleep((int)25);
                }
                try {
                    while (!fileListQueryTask.isFinished()) {
                        this.setProgressFromSubTask(fileListQueryTask, 0, 50);
                        this.setProgressText(fileListQueryTask.getProgressText());
                        if (this.isCancelledImpl()) {
                            fileListQueryTask.cancel();
                            this.bailIfCancelled();
                        }
                        IndexQueryTask.sleep((int)25);
                    }
                    FileList fileList = fileListQueryTask.getQueryResult();
                    if (fileList == null) {
                        throw new IllegalStateException("Failed to get file list");
                    }
                    Librarian librarian = Librarian.getLibrarian();
                    BrowseStack browseStack = librarian.browseStack(KeywordIndex.ra$_stackKey(KeywordIndex.this), 1);
                    if (browseStack == null) {
                        throw new IllegalStateException("Failed to open stack data");
                    }
                    try {
                        this.bailIfCancelled();
                        if (this._keyword != null) {
                            URL[] uRLArray = this.findKeyword(this._keyword, browseStack, fileList);
                            this.setQueryResult(uRLArray);
                            break block15;
                        }
                        if (this._batchKeywords != null) {
                            int n = this._batchKeywords.length;
                            URL[][] uRLArray = new URL[n][];
                            int n2 = 0;
                            while (n2 < n) {
                                this.bailIfCancelled();
                                String string = this._batchKeywords[n2];
                                uRLArray[n2] = this.findKeyword(string, browseStack, fileList);
                                ++n2;
                            }
                            this.setBatchQueryResult(uRLArray);
                            break block15;
                        }
                        throw new IllegalStateException("nothing to search for");
                    }
                    finally {
                        if (browseStack != null) {
                            browseStack.releaseStack();
                        }
                    }
                }
                finally {
                    KeywordIndex.mav$notifyQueryFinished(KeywordIndex.this);
                }
            }
            return null;
        }

        private URL[] findKeyword(String string, BrowseStack browseStack, FileList fileList) throws AsyncTask.CancelledException {
            try {
                this.setProgressText(UsageArb.format(6, string));
                IndexBook indexBook = (IndexBook)browseStack.lookupBook(string, IndexBook.INDEX_BOOK_FACTORY);
                if (indexBook != null) {
                    ArrayList<URL> arrayList = new ArrayList<URL>();
                    int[] nArray = indexBook._fileids;
                    int n = nArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        this.bailIfCancelled();
                        URL uRL = fileList.getFileURL(nArray[n2]);
                        if (uRL != null) {
                            arrayList.add(uRL);
                        }
                        ++n2;
                    }
                    n = arrayList.size();
                    URL[] uRLArray = new URL[n];
                    URL[] uRLArray2 = uRLArray = arrayList.toArray(uRLArray);
                    return uRLArray2;
                }
            }
            catch (AssemblyException assemblyException) {
                // empty catch block
            }
            return new URL[0];
        }

        IndexQueryTask(String[] stringArray, 1 var3_3) {
            this(stringArray);
        }

        IndexQueryTask(String string, 1 var3_3) {
            this(string);
        }

        public final class 1 {
        }
    }

    private final class IndexWrapper
    extends TaskMultiplexer.TaskWrapper
    implements FileListQueryTask {
        private FileListQueryTask _sharedTask;
        private FileList _fileListResult;

        private IndexWrapper() {
            super(KeywordIndex.ra$INDEX_MULTIPLEXER(KeywordIndex.this));
            this.$init$();
            this._sharedTask = KeywordIndex.mav$getOrCreateRunningIndexer(KeywordIndex.this);
            this.initializeComplete();
        }

        void $init$() {
            this._sharedTask = null;
            this._fileListResult = null;
        }

        protected BackgroundTask getSharedBackgroundTask() {
            return this._sharedTask;
        }

        protected void saveResults(BackgroundTask backgroundTask) {
            FileListQueryTask fileListQueryTask = (FileListQueryTask)backgroundTask;
            FileList fileList = fileListQueryTask.getQueryResult();
            if (fileList != null) {
                this.setQueryResult(fileList);
            }
        }

        private void setQueryResult(FileList fileList) {
            this._fileListResult = fileList;
        }

        public FileList getQueryResult() {
            return this._fileListResult;
        }

        IndexWrapper(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private final class IndexBuildTask
    extends AbstractBackgroundTask
    implements FileListQueryTask {
        private FileList _fileListResult;

        protected AsyncScheduler getSchedulerImpl() {
            return KeywordIndex.ra$INDEX_SCHEDULER();
        }

        void $init$() {
            this._fileListResult = null;
        }

        private void setQueryResult(FileList fileList) {
            this._fileListResult = fileList;
        }

        public FileList getQueryResult() {
            return this._fileListResult;
        }

        protected Object runTaskImpl() throws AsyncTask.CancelledException {
            try {
                IndexInfo indexInfo;
                FileList fileList = this.fetchFileList(0, 15);
                long l = fileList.getVersionId();
                long l2 = KeywordIndex.ra$_versionid(KeywordIndex.this);
                long l3 = KeywordIndex.ra$_lastSyncId(KeywordIndex.this);
                if (!KeywordIndex.ra$_loaded(KeywordIndex.this) && (indexInfo = this.loadIndexInfo(15, 20)) != null) {
                    l2 = indexInfo._versionid;
                    KeywordIndex.wa$_versionid(KeywordIndex.this, l2);
                    l3 = indexInfo._lastSyncId;
                    KeywordIndex.wa$_lastSyncId(KeywordIndex.this, l3);
                }
                if (l != l2) {
                    int[] nArray = fileList.getFilesSince(l2);
                    Map map = this.buildKeywordData(fileList, nArray, 20, 80);
                    KeywordIndex.wa$_versionid(KeywordIndex.this, l);
                    KeywordIndex.wa$_lastSyncId(KeywordIndex.this, l3);
                    this.saveIndexData(KeywordIndex.ra$_versionid(KeywordIndex.this), KeywordIndex.ra$_lastSyncId(KeywordIndex.this), map, 80, 100);
                }
                KeywordIndex.wa$_loaded(KeywordIndex.this, true);
                this.setProgress(100);
                this.setQueryResult(fileList);
                Object var11_8 = null;
                KeywordIndex.mav$clearRunningIndexer(KeywordIndex.this, this);
                return var11_8;
            }
            catch (Throwable throwable) {
                KeywordIndex.mav$clearRunningIndexer(KeywordIndex.this, this);
                throw throwable;
            }
        }

        protected void saveIndexData(long l, long l2, Map map, int n, int n2) {
            String string = URLFileSystem.getPlatformPathName((URL)KeywordIndex.ra$_rootURL(KeywordIndex.this));
            this.setProgressText(UsageArb.format(7, string));
            long l3 = System.currentTimeMillis();
            Librarian librarian = Librarian.getLibrarian();
            ReservedStack reservedStack = librarian.reserveStack(KeywordIndex.ra$_stackKey(KeywordIndex.this), 1);
            if (reservedStack == null) {
                librarian.createStack(KeywordIndex.ra$_stackKey(KeywordIndex.this), 1);
                reservedStack = librarian.reserveStack(KeywordIndex.ra$_stackKey(KeywordIndex.this), 1);
                if (reservedStack == null) {
                    throw new IllegalStateException("Error saving index to storage");
                }
            }
            try {
                try {
                    IndexInfo indexInfo = new IndexInfo(l, l2);
                    reservedStack.replaceStackInfo(indexInfo, IndexInfo.INDEX_INFO_FACTORY);
                    Set set = map.keySet();
                    int n3 = set.size();
                    int n4 = set.size();
                    char[][] cArray = (char[][])set.toArray((T[])new char[n4][]);
                    Arrays.sort(cArray, CharArrayPool.CHAR_ARRAY_COMPARATOR);
                    int n5 = 0;
                    while (n5 < n4) {
                        int n6 = (int)((double)n5 * 100.0 / (double)n3);
                        char[] cArray2 = cArray[n5];
                        String string2 = new String(cArray2);
                        IndexBook indexBook = (IndexBook)reservedStack.lookupBook(string2, IndexBook.INDEX_BOOK_FACTORY);
                        if (indexBook == null) {
                            indexBook = new IndexBook();
                        }
                        List list = (List)map.remove(cArray2);
                        int[] nArray = this.integerListToIntArray(list);
                        indexBook._fileids = this.mergeIntArrays(indexBook._fileids, nArray);
                        reservedStack.replaceBook(string2, indexBook, IndexBook.INDEX_BOOK_FACTORY);
                        ++n5;
                    }
                }
                catch (AssemblyException assemblyException) {
                    reservedStack.releaseStack();
                    reservedStack = null;
                    librarian.destroyStack(KeywordIndex.ra$_stackKey(KeywordIndex.this));
                    librarian.createStack(KeywordIndex.ra$_stackKey(KeywordIndex.this), 1);
                    throw new IllegalStateException("Error writing index contents");
                }
            }
            finally {
                if (reservedStack != null) {
                    reservedStack.releaseStack();
                }
            }
            long l4 = System.currentTimeMillis() - l3;
            this.setProgressFromSubTask(100, n, n2);
        }

        protected int[] mergeIntArrays(int[] nArray, int[] nArray2) {
            int n = nArray.length;
            int n2 = nArray2.length;
            int n3 = n + n2;
            int[] nArray3 = new int[n3];
            System.arraycopy(nArray, 0, nArray3, 0, n);
            System.arraycopy(nArray2, 0, nArray3, n, n2);
            return nArray3;
        }

        protected int[] integerListToIntArray(List list) {
            int n = list.size();
            int[] nArray = new int[n];
            int n2 = 0;
            while (n2 < n) {
                nArray[n2] = (Integer)list.get(n2);
                ++n2;
            }
            return nArray;
        }

        protected Map buildKeywordData(FileList fileList, int[] nArray, int n, int n2) throws AsyncTask.CancelledException {
            String string = URLFileSystem.getPlatformPathName((URL)KeywordIndex.ra$_rootURL(KeywordIndex.this));
            this.setProgressText(UsageArb.format(4, string));
            long l = System.currentTimeMillis();
            long l2 = 0L;
            long l3 = 0L;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            HashMap hashMap = new HashMap(nArray.length);
            if (nArray.length == 0) {
                return hashMap;
            }
            HashMap<URL, Integer> hashMap2 = new HashMap<URL, Integer>(nArray.length);
            Class<TextNode> clazz = TextNode.class;
            Class<JavaClassNode> clazz2 = JavaClassNode.class;
            Class<UnrecognizedTextNode> clazz3 = UnrecognizedTextNode.class;
            int n6 = nArray.length;
            ArrayList<URL> arrayList = new ArrayList<URL>();
            int n7 = 0;
            while (n7 < n6) {
                this.bailIfCancelled();
                int n8 = nArray[n7];
                URL uRL = fileList.getFileURL(n8);
                Class clazz4 = Recognizer.recognizeURL((URL)uRL);
                if (clazz4 != null && clazz.isAssignableFrom(clazz4) && !clazz2.isAssignableFrom(clazz4) && !clazz3.isAssignableFrom(clazz4)) {
                    hashMap2.put(uRL, new Integer(n8));
                    arrayList.add(uRL);
                } else {
                    ++n5;
                }
                ++n7;
            }
            n6 = arrayList.size();
            URL[] uRLArray = new URL[n6];
            uRLArray = arrayList.toArray(uRLArray);
            int n9 = uRLArray.length;
            int n10 = 0;
            CharArrayPool charArrayPool = new CharArrayPool(1000);
            IOQueue iOQueue = new IOQueue(KeywordIndex.ra$_rootURL(KeywordIndex.this));
            iOQueue.sendRequests(uRLArray);
            try {
                try {
                    while (true) {
                        int n11 = (int)((double)n10 * 100.0 / (double)n9);
                        this.setProgressFromSubTask(n11, n, n2);
                        String string2 = Integer.toString(n9 - n10);
                        this.setProgressText(UsageArb.format(5, string, string2));
                        IORequest iORequest = iOQueue.waitForRequest(100);
                        this.bailIfCancelled();
                        if (iORequest == null) continue;
                        URL uRL = iORequest.getURL();
                        ReadTextBuffer readTextBuffer = iORequest.getTextData();
                        Node node = iORequest.getNode();
                        if (iORequest.isSuccessful() && node instanceof TextNode && !(node instanceof JavaClassNode) && !(node instanceof UnrecognizedTextNode) && readTextBuffer != null) {
                            KeywordCollector keywordCollector = new KeywordCollector();
                            KeywordScanner keywordScanner = node instanceof JavaSourceNode ? new JavaScanner(readTextBuffer, charArrayPool, keywordCollector) : new KeywordScanner(readTextBuffer, charArrayPool, keywordCollector);
                            boolean bl = true;
                            if (Bug4598932Fix.getPreventDeadlock()) {
                                bl = readTextBuffer.tryReadLock();
                            } else {
                                readTextBuffer.readLock();
                            }
                            try {
                                keywordScanner.scan(null, -1);
                            }
                            finally {
                                if (bl) {
                                    readTextBuffer.readUnlock();
                                }
                            }
                            Set set = keywordCollector.getKeywordSet();
                            Integer n12 = (Integer)hashMap2.remove(uRL);
                            if (n12 != null) {
                                this.processKeywordSet(n12, set, hashMap);
                            }
                            ++n4;
                            l2 += (long)readTextBuffer.getLength();
                            l3 += (long)set.size();
                        } else {
                            Class clazz5 = node != null ? node.getClass() : null;
                            Throwable throwable = iORequest.getException();
                            if (throwable == null || throwable instanceof FileNotFoundException) {
                                // empty if block
                            }
                        }
                        ++n10;
                    }
                }
                catch (EmptyQueueException emptyQueueException) {
                }
            }
            finally {
                iOQueue.disposeQueue();
            }
            int n13 = hashMap2.size();
            if (n13 > 0) {
                URL[] uRLArray2 = new URL[n13];
                uRLArray2 = hashMap2.keySet().toArray(uRLArray2);
            }
            n3 += hashMap.size();
            long l4 = System.currentTimeMillis() - l;
            this.setProgressFromSubTask(100, n, n2);
            return hashMap;
        }

        protected void processKeywordSet(Integer n, Set set, Map map) {
            for (char[] cArray : set) {
                ArrayList<Integer> arrayList = (ArrayList<Integer>)map.get(cArray);
                if (arrayList == null) {
                    arrayList = new ArrayList<Integer>();
                    map.put(cArray, arrayList);
                }
                arrayList.add(n);
            }
        }

        protected IndexInfo loadIndexInfo(int n, int n2) throws AsyncTask.CancelledException {
            Librarian librarian = Librarian.getLibrarian();
            BrowseStack browseStack = librarian.browseStack(KeywordIndex.ra$_stackKey(KeywordIndex.this), 1);
            if (browseStack == null) {
                librarian.createStack(KeywordIndex.ra$_stackKey(KeywordIndex.this), 1);
                browseStack = librarian.browseStack(KeywordIndex.ra$_stackKey(KeywordIndex.this), 1);
                if (browseStack == null) {
                    throw new IllegalStateException("Error loading index from storage");
                }
            }
            IndexInfo indexInfo = null;
            try {
                try {
                    this.bailIfCancelled();
                    indexInfo = (IndexInfo)browseStack.lookupStackInfo(IndexInfo.INDEX_INFO_FACTORY);
                }
                catch (AssemblyException assemblyException) {
                    browseStack.releaseStack();
                    browseStack = null;
                    librarian.destroyStack(KeywordIndex.ra$_stackKey(KeywordIndex.this));
                    librarian.createStack(KeywordIndex.ra$_stackKey(KeywordIndex.this), 1);
                    indexInfo = null;
                }
            }
            finally {
                if (browseStack != null) {
                    browseStack.releaseStack();
                }
            }
            this.setProgressFromSubTask(100, n, n2);
            return indexInfo;
        }

        private FileList fetchFileList(int n, int n2) throws AsyncTask.CancelledException {
            String string = URLFileSystem.getPlatformPathName((URL)KeywordIndex.ra$_rootURL(KeywordIndex.this));
            this.setProgressText(UsageArb.format(3, string));
            FileListQueryTask fileListQueryTask = FileManager.getFileListQueryTask(KeywordIndex.ra$_rootURL(KeywordIndex.this));
            while (!fileListQueryTask.isFinished()) {
                int n3 = fileListQueryTask.getProgress();
                this.setProgressFromSubTask(fileListQueryTask, n, n2);
                if (this.isCancelledImpl()) {
                    fileListQueryTask.cancel();
                    this.bailIfCancelled();
                }
                IndexBuildTask.sleep((int)25);
            }
            this.setProgressFromSubTask(100, n, n2);
            FileList fileList = fileListQueryTask.getQueryResult();
            if (fileList == null) {
                throw new IllegalStateException("Unexpected null file list");
            }
            return fileList;
        }

        private IndexBuildTask() {
            this.$init$();
        }

        IndexBuildTask(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

