/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.usage.keyword;

import javax.swing.text.Segment;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.jdeveloper.usage.keyword.KeywordListener;
import oracle.jdeveloper.usage.util.CharArrayPool;

public class KeywordScanner {
    public static final int FLAG_NONE = 0;
    public static final int FLAG_INCLUDE_ALL = -1;
    protected ReadTextBuffer _textBuffer;
    protected CharArrayPool _charArrayPool;
    protected KeywordListener _listener;
    protected Segment _segment;
    protected static final int IDENTIFIER_ARRAY_SIZE = 256;
    protected static final boolean[] IDENTIFIER_PART = new boolean[256];
    protected static final boolean[] IDENTIFIER_START = new boolean[256];

    static {
        char c = '\u0000';
        while (c < '\u0100') {
            KeywordScanner.IDENTIFIER_PART[c] = Character.isJavaIdentifierPart(c);
            KeywordScanner.IDENTIFIER_START[c] = Character.isJavaIdentifierStart(c);
            c = (char)(c + '\u0001');
        }
    }

    public KeywordScanner(ReadTextBuffer readTextBuffer, KeywordListener keywordListener) {
        this(readTextBuffer, new CharArrayPool(100), keywordListener);
    }

    public KeywordScanner(ReadTextBuffer readTextBuffer, CharArrayPool charArrayPool, KeywordListener keywordListener) {
        this.$init$();
        this._textBuffer = readTextBuffer;
        this._charArrayPool = charArrayPool;
        this._listener = keywordListener;
    }

    public void setTextBuffer(ReadTextBuffer readTextBuffer) {
        this._textBuffer = readTextBuffer;
    }

    void $init$() {
        this._segment = new Segment();
    }

    protected char[] filterKeyword(char[] cArray, int n, int n2) {
        this._textBuffer.getText(n, n2 - n, this._segment);
        if (cArray != null) {
            if (CharArrayPool.CHAR_ARRAY_COMPARATOR.compare(cArray, this._segment) == 0) {
                return this._charArrayPool.add(cArray);
            }
            return null;
        }
        return this._charArrayPool.add(this._segment);
    }

    protected void reportKeyword(char[] cArray, int n, int n2, int n3) {
        char[] cArray2 = this.filterKeyword(cArray, n2, n3);
        if (cArray2 != null) {
            this._listener.notifyKeyword(cArray2, n, n2, n3);
        }
    }

    public void scan(char[] cArray, int n) {
        int n2 = this._textBuffer.getLength();
        this.scan(cArray, n, 0, n2);
    }

    public void scan(char[] cArray, int n, int n2, int n3) {
        int n4 = n2;
        int n5 = -1;
        int n6 = -1;
        while (n4 < n3) {
            char c = this._textBuffer.getChar(n4);
            if (n5 == -1) {
                if (c < '\u0100' && IDENTIFIER_START[c] || Character.isJavaIdentifierStart(c)) {
                    n5 = n4;
                }
            } else if (!(c < '\u0100' && IDENTIFIER_PART[c] || Character.isJavaIdentifierPart(c))) {
                n6 = n4;
            }
            ++n4;
            if (n5 == -1) continue;
            if (n4 >= n3 && n6 == -1) {
                n6 = n3;
            }
            if (n6 == -1) continue;
            this.reportKeyword(cArray, 0, n5, n6);
            n5 = -1;
            n6 = -1;
        }
    }
}

