/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.usage.lib;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.assembly.AssemblyException;
import oracle.javatools.assembly.AssemblyFactory;
import oracle.javatools.assembly.MapFactory;
import oracle.javatools.assembly.ObjectFactory;
import oracle.javatools.assembly.StringFactory;
import oracle.jdeveloper.usage.lib.BFStack;
import oracle.jdeveloper.usage.lib.BrowseStack;
import oracle.jdeveloper.usage.lib.Librarian;
import oracle.jdeveloper.usage.lib.ReservedStack;
import oracle.jdeveloper.usage.util.FileUtilities;

public final class BFLibrarian
extends Librarian {
    private static BFLibrarian _librarian = null;
    private int _nextId;
    private Map _stackMap;
    private URL _baseURL;
    private boolean _tocLoaded;
    private static final String TOC_FILENAME = "bftoc.dat";
    private static final String BASE_DIRECTORY = "storage";
    private static String OVERRIDE_LOCATION = "/home/acyu/tmp";
    private Map _openStackMap;
    private static final String STACK_FILENAME = "bfstackNUM.dat";
    private static final String STACK_PATTERN = "NUM";
    private static final BFLibrarianFactory LIBRARIAN_FACTORY = new BFLibrarianFactory(null);

    public static synchronized Librarian getLibrarian() {
        if (_librarian == null) {
            _librarian = new BFLibrarian();
        }
        return _librarian;
    }

    private BFLibrarian() {
        this.$init$();
        this.initializeStorageLocation();
        this.loadTableOfContents();
    }

    void $init$() {
        this._nextId = 1;
        this._stackMap = new HashMap();
        this._tocLoaded = false;
        this._openStackMap = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTableOfContents() {
        BFLibrarian bFLibrarian = this;
        synchronized (bFLibrarian) {
            if (!this._tocLoaded) {
                BFLibrarianObject bFLibrarianObject = null;
                try {
                    URL uRL = this.getStorageURL(TOC_FILENAME);
                    byte[] byArray = FileUtilities.readFile(uRL);
                    bFLibrarianObject = (BFLibrarianObject)LIBRARIAN_FACTORY.assemble(byArray);
                }
                catch (AssemblyException assemblyException) {
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (bFLibrarianObject == null) {
                    bFLibrarianObject = new BFLibrarianObject(1, new HashMap(), null);
                }
                this._nextId = BFLibrarianObject.ra$nextId(bFLibrarianObject);
                this._stackMap = BFLibrarianObject.ra$stackMap(bFLibrarianObject);
                this._tocLoaded = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveTableOfContents() {
        BFLibrarian bFLibrarian = this;
        synchronized (bFLibrarian) {
            BFLibrarianObject bFLibrarianObject = new BFLibrarianObject(this._nextId, this._stackMap, null);
            try {
                byte[] byArray = LIBRARIAN_FACTORY.disassemble(bFLibrarianObject);
                URL uRL = this.getStorageURL(TOC_FILENAME);
                FileUtilities.writeFile(uRL, byArray);
            }
            catch (AssemblyException assemblyException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void initializeStorageLocation() {
        String string;
        block8: {
            string = OVERRIDE_LOCATION;
            try {
                try {
                    if (string == null) {
                        ExtensionRegistry extensionRegistry = ExtensionRegistry.getOracleRegistry();
                        URL uRL = extensionRegistry.getSystemDirectory("oracle.jdeveloper");
                        string = uRL.getPath();
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    string = null;
                }
                if (string == null) {
                    string = Ide.getUserHomeDirectory();
                }
            }
            catch (NullPointerException nullPointerException) {
                if (string != null) break block8;
                string = System.getProperty("user.home");
            }
        }
        if (string == null) {
            string = System.getProperty("user.dir");
        }
        if (string == null) {
            string = "";
        }
        URL uRL = URLFactory.newDirURL((String)string);
        this._baseURL = URLFactory.newDirURL((URL)uRL, (String)BASE_DIRECTORY);
    }

    private URL getStorageURL(String string) {
        return URLFactory.newURL((URL)this._baseURL, (String)string);
    }

    public static void setOverrideLocation(String string) {
        OVERRIDE_LOCATION = string;
    }

    private String getNextFileName() {
        int n;
        String string;
        URL uRL;
        do {
            ++this._nextId;
        } while (URLFileSystem.exists((URL)(uRL = this.getStorageURL(string = STACK_FILENAME.replaceFirst(STACK_PATTERN, Integer.toString(n))))));
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createStack(String string, int n) {
        BFLibrarian bFLibrarian = this;
        synchronized (bFLibrarian) {
            if (this._stackMap.containsKey(string)) {
                boolean bl = false;
                return bl;
            }
            String string2 = this.getNextFileName();
            this._stackMap.put(string, string2);
            this.saveTableOfContents();
            boolean bl = true;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean destroyStack(String string) {
        BFLibrarian bFLibrarian = this;
        synchronized (bFLibrarian) {
            String string2 = (String)this._stackMap.get(string);
            if (string2 == null) {
                boolean bl = false;
                return bl;
            }
            this._openStackMap.remove(string);
            this._stackMap.remove(string);
            this.saveTableOfContents();
            boolean bl = true;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BFStack lookupStack(String string) {
        BFLibrarian bFLibrarian = this;
        synchronized (bFLibrarian) {
            String string2 = (String)this._stackMap.get(string);
            if (string2 == null) {
                BFStack bFStack = null;
                return bFStack;
            }
            URL uRL = this.getStorageURL(string2);
            BFStack bFStack = (BFStack)this._openStackMap.get(string);
            if (bFStack == null) {
                bFStack = new BFStack(uRL);
                this._openStackMap.put(string, bFStack);
            }
            BFStack bFStack2 = bFStack;
            return bFStack2;
        }
    }

    public BrowseStack browseStack(String string, int n) {
        BFStack bFStack = this.lookupStack(string);
        if (bFStack != null) {
            return bFStack.acquireBrowseStack();
        }
        return null;
    }

    public ReservedStack reserveStack(String string, int n) {
        BFStack bFStack = this.lookupStack(string);
        if (bFStack != null) {
            return bFStack.acquireReservedStack();
        }
        return null;
    }

    public void releaseStack(BrowseStack browseStack) {
        if (browseStack != null) {
            browseStack.releaseStack();
        }
    }

    private static final class BFLibrarianObject {
        private int nextId;
        private Map stackMap;

        private BFLibrarianObject(int n, Map map) {
            this.nextId = n;
            this.stackMap = map;
        }

        BFLibrarianObject(int n, Map map, 1 var3_3) {
            this(n, map);
        }

        static int ra$nextId(BFLibrarianObject bFLibrarianObject) {
            return bFLibrarianObject.nextId;
        }

        static Map ra$stackMap(BFLibrarianObject bFLibrarianObject) {
            return bFLibrarianObject.stackMap;
        }

        public final class 1 {
        }
    }

    private static final class BFLibrarianFactory
    extends ObjectFactory {
        private AssemblyFactory stackMapFactory;
        public static final byte LIBRARIAN_CODE = -79;

        void $init$() {
            this.stackMapFactory = new MapFactory((AssemblyFactory)StringFactory.STRING_FACTORY, (AssemblyFactory)StringFactory.STRING_FACTORY);
        }

        public byte getObjectCode() {
            return -79;
        }

        public Object assembleImpl(DataInput dataInput) throws IOException, AssemblyException {
            int n = dataInput.readInt();
            Map map = (Map)this.stackMapFactory.assemble(dataInput);
            return new BFLibrarianObject(n, map, null);
        }

        public void disassembleImpl(Object object, DataOutput dataOutput) throws IOException, ClassCastException, AssemblyException {
            BFLibrarianObject bFLibrarianObject = (BFLibrarianObject)object;
            dataOutput.writeInt(BFLibrarianObject.ra$nextId(bFLibrarianObject));
            this.stackMapFactory.disassemble((Object)BFLibrarianObject.ra$stackMap(bFLibrarianObject), dataOutput);
        }

        private BFLibrarianFactory() {
            this.$init$();
        }

        BFLibrarianFactory(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

