/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.usage.lib;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import oracle.ide.util.TimedCache;
import oracle.javatools.assembly.AssemblyException;
import oracle.javatools.assembly.AssemblyFactory;
import oracle.javatools.assembly.ByteArrayFactory;
import oracle.javatools.assembly.MapFactory;
import oracle.javatools.assembly.ObjectFactory;
import oracle.javatools.assembly.StringFactory;
import oracle.javatools.buffer.ReadWriteLock;
import oracle.jdeveloper.usage.lib.BrowseStack;
import oracle.jdeveloper.usage.lib.ReservedStack;
import oracle.jdeveloper.usage.util.FileUtilities;

final class BFStack {
    private URL _fileURL;
    private byte[] _info;
    private Map _bookMap;
    private static TimedCache _dataCache = new TimedCache();
    private int _browseCount;
    private int _reservedCount;
    private boolean _dirty;
    private ReadWriteLock _lock;
    private static final BFStackFactory STACK_FACTORY = new BFStackFactory(null);

    BFStack(URL uRL) {
        this.$init$();
        this._fileURL = uRL;
    }

    void $init$() {
        this._info = null;
        this._bookMap = null;
        this._browseCount = 0;
        this._reservedCount = 0;
        this._dirty = false;
        this._lock = new ReadWriteLock();
    }

    private synchronized void loadDataFromCacheOrDisk() {
        BFStackObject bFStackObject = (BFStackObject)_dataCache.remove((Object)this._fileURL);
        if (bFStackObject == null) {
            try {
                byte[] byArray = FileUtilities.readFile(this._fileURL);
                bFStackObject = (BFStackObject)STACK_FACTORY.assemble(byArray);
            }
            catch (AssemblyException assemblyException) {
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (bFStackObject == null) {
            this._bookMap = new HashMap();
            this._info = null;
        } else {
            this._bookMap = BFStackObject.ra$bookMap(bFStackObject);
            this._info = BFStackObject.ra$info(bFStackObject);
        }
    }

    private synchronized void saveDataToDisk() {
        BFStackObject bFStackObject = new BFStackObject(this._info, this._bookMap, null);
        try {
            byte[] byArray = STACK_FACTORY.disassemble(bFStackObject);
            FileUtilities.writeFile(this._fileURL, byArray);
        }
        catch (AssemblyException assemblyException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private synchronized void saveDataToCache() {
        BFStackObject bFStackObject = new BFStackObject(this._info, this._bookMap, null);
        _dataCache.put((Object)this._fileURL, (Object)bFStackObject);
        this._bookMap = null;
        this._info = null;
    }

    private Object _lookupBook(String string, AssemblyFactory assemblyFactory) throws AssemblyException {
        byte[] byArray = (byte[])this._bookMap.get(string);
        if (byArray != null) {
            return assemblyFactory.assemble(byArray);
        }
        return null;
    }

    private String[] _lookupContents() {
        Set set = this._bookMap.keySet();
        int n = set.size();
        return set.toArray(new String[n]);
    }

    private Object _lookupStackInfo(AssemblyFactory assemblyFactory) throws AssemblyException {
        if (this._info != null) {
            return assemblyFactory.assemble(this._info);
        }
        return null;
    }

    private void _removeBook(String string) {
        this._bookMap.remove(string);
    }

    private void _removeAllBooks() {
        this._bookMap.clear();
    }

    private void _replaceBook(String string, Object object, AssemblyFactory assemblyFactory) throws AssemblyException {
        if (string == null) {
            throw new IllegalArgumentException("Null names not allowed in stack");
        }
        byte[] byArray = assemblyFactory.disassemble(object);
        this._bookMap.put(string, byArray);
    }

    private void _replaceStackInfo(Object object, AssemblyFactory assemblyFactory) throws AssemblyException {
        byte[] byArray = assemblyFactory.disassemble(object);
        this._info = byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BrowseStack acquireBrowseStack() {
        this._lock.readLock();
        BFStack bFStack = this;
        synchronized (bFStack) {
            if (this._browseCount == 0 && this._reservedCount == 0) {
                this.loadDataFromCacheOrDisk();
            }
            ++this._browseCount;
            BrowseStackWrapper browseStackWrapper = new BrowseStackWrapper(null);
            return browseStackWrapper;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ReservedStack acquireReservedStack() {
        this._lock.writeLock();
        BFStack bFStack = this;
        synchronized (bFStack) {
            if (this._browseCount == 0 && this._reservedCount == 0) {
                this.loadDataFromCacheOrDisk();
            }
            ++this._reservedCount;
            ReservedStackWrapper reservedStackWrapper = new ReservedStackWrapper(null);
            return reservedStackWrapper;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseBrowseStack() {
        BFStack bFStack = this;
        synchronized (bFStack) {
            --this._browseCount;
            if (this._browseCount == 0 && this._reservedCount == 0) {
                this.saveDataToCache();
            }
        }
        this._lock.readUnlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseReservedStack(boolean bl) {
        BFStack bFStack = this;
        synchronized (bFStack) {
            --this._reservedCount;
            boolean bl2 = this._dirty = this._dirty || bl;
            if (this._dirty && this._reservedCount == 0) {
                this.saveDataToDisk();
                this._dirty = false;
            }
            if (this._browseCount == 0) {
                this.saveDataToCache();
            }
        }
        this._lock.writeUnlock();
    }

    static Object mav$_lookupStackInfo(BFStack bFStack, AssemblyFactory assemblyFactory) {
        return bFStack._lookupStackInfo(assemblyFactory);
    }

    static String[] mav$_lookupContents(BFStack bFStack) {
        return bFStack._lookupContents();
    }

    static Object mav$_lookupBook(BFStack bFStack, String string, AssemblyFactory assemblyFactory) {
        return bFStack._lookupBook(string, assemblyFactory);
    }

    static void mav$releaseBrowseStack(BFStack bFStack) {
        bFStack.releaseBrowseStack();
    }

    static void mav$_replaceStackInfo(BFStack bFStack, Object object, AssemblyFactory assemblyFactory) {
        bFStack._replaceStackInfo(object, assemblyFactory);
    }

    static void mav$_replaceBook(BFStack bFStack, String string, Object object, AssemblyFactory assemblyFactory) {
        bFStack._replaceBook(string, object, assemblyFactory);
    }

    static void mav$_removeAllBooks(BFStack bFStack) {
        bFStack._removeAllBooks();
    }

    static void mav$_removeBook(BFStack bFStack, String string) {
        bFStack._removeBook(string);
    }

    static void mav$releaseReservedStack(BFStack bFStack, boolean bl) {
        bFStack.releaseReservedStack(bl);
    }

    private class BrowseStackWrapper
    implements BrowseStack {
        protected boolean _released;

        void $init$() {
            this._released = false;
        }

        public void releaseStack() {
            this.assertNotReleased();
            BFStack.mav$releaseBrowseStack(BFStack.this);
            this._released = true;
        }

        protected void assertNotReleased() {
            if (this._released) {
                throw new IllegalStateException("Attempted access to released resource");
            }
        }

        public Object lookupBook(String string, AssemblyFactory assemblyFactory) throws AssemblyException {
            this.assertNotReleased();
            return BFStack.mav$_lookupBook(BFStack.this, string, assemblyFactory);
        }

        public String[] lookupContents() {
            this.assertNotReleased();
            return BFStack.mav$_lookupContents(BFStack.this);
        }

        public Object lookupStackInfo(AssemblyFactory assemblyFactory) throws AssemblyException {
            this.assertNotReleased();
            return BFStack.mav$_lookupStackInfo(BFStack.this, assemblyFactory);
        }

        private BrowseStackWrapper() {
            this.$init$();
        }

        BrowseStackWrapper(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private final class ReservedStackWrapper
    extends BrowseStackWrapper
    implements ReservedStack {
        private boolean _modified;

        void $init$() {
            this._modified = false;
        }

        public void releaseStack() {
            this.assertNotReleased();
            BFStack.mav$releaseReservedStack(BFStack.this, this._modified);
            this._released = true;
        }

        public void removeBook(String string) {
            this.assertNotReleased();
            BFStack.mav$_removeBook(BFStack.this, string);
            this._modified = true;
        }

        public void removeAllBooks() {
            this.assertNotReleased();
            BFStack.mav$_removeAllBooks(BFStack.this);
            this._modified = true;
        }

        public void replaceBook(String string, Object object, AssemblyFactory assemblyFactory) throws AssemblyException {
            this.assertNotReleased();
            BFStack.mav$_replaceBook(BFStack.this, string, object, assemblyFactory);
            this._modified = true;
        }

        public void replaceStackInfo(Object object, AssemblyFactory assemblyFactory) throws AssemblyException {
            this.assertNotReleased();
            BFStack.mav$_replaceStackInfo(BFStack.this, object, assemblyFactory);
            this._modified = true;
        }

        private ReservedStackWrapper() {
            super(null);
            this.$init$();
        }

        ReservedStackWrapper(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private static final class BFStackObject {
        private byte[] info;
        private Map bookMap;

        private BFStackObject(byte[] byArray, Map map) {
            this.info = byArray;
            this.bookMap = map;
        }

        BFStackObject(byte[] byArray, Map map, 1 var3_3) {
            this(byArray, map);
        }

        static Map ra$bookMap(BFStackObject bFStackObject) {
            return bFStackObject.bookMap;
        }

        static byte[] ra$info(BFStackObject bFStackObject) {
            return bFStackObject.info;
        }

        public final class 1 {
        }
    }

    private static final class BFStackFactory
    extends ObjectFactory {
        private AssemblyFactory bookMapFactory;
        public static final byte STACK_CODE = -75;

        void $init$() {
            this.bookMapFactory = new MapFactory((AssemblyFactory)StringFactory.STRING_FACTORY, (AssemblyFactory)ByteArrayFactory.BYTE_ARRAY_FACTORY);
        }

        public byte getObjectCode() {
            return -75;
        }

        public Object assembleImpl(DataInput dataInput) throws IOException, AssemblyException {
            ByteArrayFactory byteArrayFactory = ByteArrayFactory.BYTE_ARRAY_FACTORY;
            byte[] byArray = (byte[])byteArrayFactory.assemble(dataInput);
            Map map = (Map)this.bookMapFactory.assemble(dataInput);
            return new BFStackObject(byArray, map, null);
        }

        public void disassembleImpl(Object object, DataOutput dataOutput) throws IOException, ClassCastException, AssemblyException {
            BFStackObject bFStackObject = (BFStackObject)object;
            ByteArrayFactory byteArrayFactory = ByteArrayFactory.BYTE_ARRAY_FACTORY;
            byteArrayFactory.disassemble((Object)BFStackObject.ra$info(bFStackObject), dataOutput);
            this.bookMapFactory.disassemble((Object)BFStackObject.ra$bookMap(bFStackObject), dataOutput);
        }

        private BFStackFactory() {
            this.$init$();
        }

        BFStackFactory(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

